<?php
    use App\Livewire\PuntoDeVenta\PuntoVentas\PuntoVentasBaseLogic as Logic;
?>

<div>

    <div class="min-h-screen bg-gray-50">
        <div class="bg-white shadow-sm border-b border-gray-200 px-6 py-4 mb-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Punto de Venta</h1>
                </div>
                <div class="flex items-center space-x-6">
                    <div class="text-right">
                        <div class="text-sm font-medium text-gray-900"><?php echo e($folio); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e(now()->format('d/m/Y')); ?></div>
                    </div>
                    <div class="flex space-x-2">
                        <button class="p-2 text-gray-400 hover:text-gray-600 transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z">
                                </path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="px-6">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="w-5 h-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium"><?php echo e(session('message')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(session()->has('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="w-5 h-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm font-medium"><?php echo e(session('error')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

                <div class="lg:col-span-2 space-y-6">

                    <div class="bg-white rounded-xl shadow-sm p-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="sucursal"
                                    class="block text-xs font-medium text-gray-700 mb-1">Sucursal</label>
                                <select wire:model="sucursalid" id="sucursal"
                                    class="w-full text-sm border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                    <option value="">Seleccione una sucursal</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $nombre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>"><?php echo e($nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                            <div>
                                <label for="serie" class="block text-xs font-medium text-gray-700 mb-1">Serie</label>
                                <input wire:model="serie" type="text" id="serie"
                                    class="w-full text-sm border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            </div>
                            <div>
                                <label for="cliente_search"
                                    class="block text-xs font-medium text-gray-700 mb-1">Cliente</label>
                                <div class="relative" x-data="{ open: <?php if ((object) ('mostrarTablaClientes') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('mostrarTablaClientes'->value()); ?>')<?php echo e('mostrarTablaClientes'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('mostrarTablaClientes'); ?>')<?php endif; ?> }" x-on:click.away="open = false">
                                    <div class="flex">
                                        <input type="text" id="cliente_search"
                                            wire:model.live.debounce.300ms="search.clientes"
                                            x-on:focus="$wire.abrirDropdownClientes()"
                                            class="flex-1 text-sm border-gray-300 rounded-l-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                            placeholder="Buscar cliente...">
                                        <button type="button"
                                            x-on:click="if (open) { open = false; $wire.cerrarDropdownClientes(); } else { open = true; $wire.abrirDropdownClientes(); }"
                                            class="px-3  border-gray-300 rounded-r-lg hover:bg-gray-100">
                                            <svg class="w-4 h-4 text-gray-600" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7"></path>
                                            </svg>
                                        </button>
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($clientes && count($clientes) > 0): ?>
                                        <div x-show="open" x-transition
                                            class="absolute z-10 w-full mt-1 bg-white border border-gray-200 rounded-lg shadow-lg max-h-60 overflow-y-auto">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="px-3 py-2 hover:bg-gray-50 cursor-pointer border-b border-gray-100 last:border-b-0"
                                                    wire:click="seleccionarCliente(<?php echo e($cliente->idclient); ?>)"
                                                    x-on:click="open = false">
                                                    <div class="font-medium text-sm"><?php echo e($cliente->nombre); ?></div>
                                                    <div class="text-xs text-gray-500"><?php echo e($cliente->rfc); ?></div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h2 class="text-lg font-semibold text-gray-900">Agregar Producto</h2>
                            <span class="px-2 py-1 bg-blue-100 text-blue-800 text-xs font-medium rounded-full">
                                <?php echo e(count($productosagregados)); ?> productos
                            </span>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                            <div class="md:col-span-2">
                                <label for="producto_search"
                                    class="block text-sm font-medium text-gray-700 mb-2">Producto</label>
                                <div class="relative" x-data="{ open: <?php if ((object) ('mostrarTablaProductos') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('mostrarTablaProductos'->value()); ?>')<?php echo e('mostrarTablaProductos'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('mostrarTablaProductos'); ?>')<?php endif; ?> }" x-on:click.away="open = false">
                                    <div class="flex">
                                        <input type="text" id="producto_search"
                                            wire:model.live.debounce.300ms="search.productos"
                                            x-on:focus="$wire.abrirDropdownProductos()"
                                            class="flex-1 border-gray-300 rounded-l-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                                            placeholder="Buscar por código o descripción...">
                                        <button type="button"
                                            x-on:click="if (open) { open = false; $wire.cerrarDropdownProductos(); } else { open = true; $wire.abrirDropdownProductos(); }"
                                            class="px-3 border-gray-300 rounded-r-lg hover:bg-gray-100">
                                            <svg class="w-4 h-4 text-gray-600" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 9l-7 7-7-7"></path>
                                            </svg>
                                        </button>
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($productos && count($productos) > 0): ?>
                                        <div x-show="open" x-transition
                                            class="absolute z-10 w-full mt-1 bg-white border border-gray-200 rounded-lg shadow-lg max-h-60 overflow-y-auto">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="px-4 py-3 hover:bg-gray-50 cursor-pointer border-b border-gray-100 last:border-b-0"
                                                    wire:click="seleccionarProducto(<?php echo e($producto->idproduct); ?>)"
                                                    x-on:click="open = false">
                                                    <div class="flex justify-between items-start">
                                                        <div>
                                                            <div class="font-medium text-gray-900">
                                                                <?php echo e($producto->clave); ?>

                                                            </div>
                                                            <div class="text-sm text-gray-600">
                                                                <?php echo e($producto->descripcion); ?></div>
                                                        </div>
                                                        <div class="text-right">
                                                            <div class="text-sm font-medium text-green-600">
                                                                $<?php echo e(Logic::formatearMoneda(Logic::calcularPrecioFinalSimple($producto->precioventaantesiva))); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                            <div>
                                <label for="cantidad"
                                    class="block text-sm font-medium text-gray-700 mb-2">Cantidad</label>
                                <input wire:model="cantidad" type="number" min="1" step="1"
                                    id="cantidad"
                                    class="w-full border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent text-center">
                            </div>

                            <div>
                                <label for="precio"
                                    class="block text-sm font-medium text-gray-700 mb-2">Precio</label>
                                <input wire:model="precio" type="number" min="0" step="0.01"
                                    id="precio"
                                    class="w-full border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent text-center">
                            </div>

                            <div class="flex items-end">
                                <button wire:click="agregarProducto" type="button"
                                    class="w-full bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white font-medium py-3 px-4 rounded-lg transition-all duration-200 transform hover:scale-105 shadow-lg hover:shadow-xl">
                                    <svg class="w-5 h-5 mx-auto" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 4v16m8-8H4"></path>
                                    </svg>
                                </button>
                            </div>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedProducto): ?>
                            <div class="mt-4 p-3 bg-blue-50 rounded-lg border border-blue-200">
                                <p class="text-sm font-medium text-blue-900"><?php echo e($descripcion); ?></p>
                                <p class="text-xs text-blue-600"><?php echo e($claveproductoservicio); ?> |
                                    <?php echo e($claveunidadmedida); ?>

                                </p>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($productosagregados) > 0): ?>
                        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
                            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                                <h3 class="text-lg font-semibold text-gray-900">Productos en la Venta</h3>
                            </div>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th
                                                class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                                Cant.</th>
                                            <th
                                                class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                                Producto</th>
                                            <th
                                                class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">
                                                Precio</th>
                                            <th
                                                class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">
                                                Total</th>
                                            <th
                                                class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase">
                                                Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $productosagregados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="hover:bg-gray-50 transition-colors">
                                                <td class="px-4 py-4 text-sm font-medium text-gray-900">
                                                    <input type="number"
                                                        wire:model.live="productosagregados.<?php echo e($index); ?>.cantidad"
                                                        wire:change="actualizarCantidad(<?php echo e($index); ?>)"
                                                        min="1" step="1"
                                                        class="w-16 text-center border-gray-300 rounded focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                                </td>
                                                <td class="px-4 py-4">
                                                    <div class="text-sm font-medium text-gray-900">
                                                        <?php echo e($producto['clave'] ?? ($producto['producto_id'] ?? '')); ?>

                                                    </div>
                                                    <div class="text-sm text-gray-500 truncate max-w-xs">
                                                        <?php echo e($producto['descripcion']); ?></div>
                                                </td>
                                                <td class="px-4 py-4 text-sm text-gray-900 text-right">
                                                    $<?php echo e(number_format($producto['precio_unitario'], 2)); ?></td>
                                                <td class="px-4 py-4 text-sm font-semibold text-gray-900 text-right">
                                                    $<?php echo e(number_format($producto['total'], 2)); ?></td>
                                                <td class="px-4 py-4 text-center">
                                                    <div class="flex justify-center space-x-2">
                                                        <button wire:click="eliminarProducto(<?php echo e($index); ?>)"
                                                            class="text-red-600 hover:text-red-800 transition-colors">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                                viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                                    stroke-width="2"
                                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                                </path>
                                                            </svg>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <div class="lg:col-span-1">
                    <div class="sticky top-6 space-y-6">

                        <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-xl p-6 border border-gray-200">
                            <div class="text-center">
                                <h3 class="text-lg font-medium text-black-800 mb-2">Total de la Venta</h3>
                                <div class="text-4xl font-bold text-black-900 mb-2">
                                    $<?php echo e(number_format($totalfinal, 2)); ?>

                                </div>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($importetotalletras)): ?>
                                    <p class="text-sm text-black-700"><?php echo e($importetotalletras); ?></p>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($productosagregados) > 0): ?>
                            <div class="bg-white rounded-xl shadow-sm p-4">
                                <h4 class="font-medium text-gray-900 mb-3">Resumen</h4>
                                <div class="space-y-2 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Productos:</span>
                                        <span class="font-medium"><?php echo e(count($productosagregados)); ?></span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Artículos:</span>
                                        <span
                                            class="font-medium"><?php echo e(array_sum(array_column($productosagregados, 'cantidad'))); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <div class="space-y-3">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($productosagregados) > 0): ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(empty($idclient)): ?>
                                    <div
                                        class="w-full bg-gray-300 text-gray-500 font-semibold py-4 px-6 rounded-xl text-center">
                                        <div class="flex items-center justify-center">
                                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z">
                                                </path>
                                            </svg>
                                            Seleccione un cliente para procesar
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <button wire:click="procesarVenta" type="button"
                                        class="w-full bg-gradient-to-r from-green-600 to-green-700 hover:from-green-700 hover:to-green-800 text-white font-semibold py-4 px-6 rounded-xl transition-all duration-200 transform hover:scale-105 shadow-lg hover:shadow-xl">
                                        <div class="flex items-center justify-center">
                                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                                                </path>
                                            </svg>
                                            Procesar Venta
                                        </div>
                                    </button>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <button wire:click="limpiarTodo" type="button"
                                class="w-full bg-white hover:bg-gray-50 text-gray-700 font-medium py-3 px-6 rounded-xl border border-gray-300 transition-colors">
                                <div class="flex items-center justify-center">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                        </path>
                                    </svg>
                                    Nueva Venta
                                </div>
                            </button>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($clientenombre)): ?>
                            <div class="bg-blue-50 rounded-xl p-4 border border-blue-200">
                                <h4 class="font-medium text-blue-900 mb-2">Cliente Seleccionado</h4>
                                <div class="text-sm">
                                    <div class="font-medium text-blue-800"><?php echo e($clientenombre); ?></div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($clienterfc)): ?>
                                        <div class="text-blue-600">RFC: <?php echo e($clienterfc); ?></div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Confirmación de Pago -->
    <div x-data="{ open: <?php if ((object) ('mostrarModalPago') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('mostrarModalPago'->value()); ?>')<?php echo e('mostrarModalPago'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('mostrarModalPago'); ?>')<?php endif; ?> }" x-show.transition.opacity="open" x-cloak
        class="fixed inset-0 z-50 flex items-center justify-center">
        <div class="absolute inset-0 bg-black opacity-50"></div>
        <div class="bg-white rounded-lg shadow-lg p-6 z-10 w-full max-w-lg">
            <h3 class="text-lg font-semibold mb-4">Confirmar Pago</h3>
            <div class="mb-3">
                <div class="text-sm text-gray-600">Cliente</div>
                <div class="font-medium"><?php echo e($clientenombre); ?></div>
            </div>
            <div class="mb-3">
                <div class="text-sm text-gray-600">Total</div>
                <div class="text-2xl font-bold">$<?php echo e(number_format($totalfinal, 2)); ?></div>
            </div>
            <div class="mb-4">
                <div class="text-sm font-medium text-gray-700 mb-2">Formas de Pago</div>

                <div class="grid grid-cols-12 gap-2 items-end mb-3">
                    <div class="col-span-5">
                        <label for="pagoActual_forma" class="block text-xs text-gray-600 mb-1">Forma</label>
                        <select id="pagoActual_forma" wire:model="pagoActual.idtipopago"
                            class="w-full border-gray-300 rounded p-2 text-sm" aria-label="Forma de pago actual">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $formasPago; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formaPagoOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($formaPagoOption['id']); ?>"><?php echo e($formaPagoOption['nombre']); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </select>
                    </div>
                    <div class="col-span-4">
                        <label for="pagoActual_importe" class="block text-xs text-gray-600 mb-1">Importe</label>
                        <input id="pagoActual_importe" wire:model.lazy="pagoActual.importe" type="number"
                            step="0.01" min="0" class="w-full border-gray-300 rounded p-2 text-sm"
                            placeholder="Importe" aria-label="Importe del pago actual">
                    </div>
                    <div class="col-span-3">
                        <button type="button" wire:click="agregarPagoDesdeActual"
                            class="w-full bg-blue-600 hover:bg-blue-700 text-white rounded p-2 text-sm">Agregar</button>
                    </div>
                </div>

                <div class="border rounded">
                    <table class="w-full text-sm">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="text-left px-3 py-2">Forma</th>
                                <th class="text-right px-3 py-2">Importe</th>
                                <th class="text-center px-3 py-2">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pagoIndex => $pagoLinea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t">
                                    <td class="px-3 py-2"><?php echo e($pagoLinea['tipopago'] ?? ''); ?></td>
                                    <td class="px-3 py-2 text-right">
                                        $<?php echo e(number_format($pagoLinea['importe'] ?? 0, 2)); ?></td>
                                    <td class="px-3 py-2 text-center">
                                        <button type="button" wire:click="eliminarPagoLinea(<?php echo e($pagoIndex); ?>)"
                                            class="text-red-600 hover:text-red-800">Eliminar</button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="px-3 py-2 text-center text-gray-500">Sin pagos agregados
                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td class="px-3 py-2 font-medium">Saldo</td>
                                <td class="px-3 py-2 text-right font-semibold">
                                    $<?php echo e(number_format(max(0, $totalfinal - (collect($pagos)->sum('importe') ?? 0)), 2)); ?>

                                </td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="text-xs text-red-600 mt-2">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($pagos) > 0 && abs((collect($pagos)->sum('importe') ?? 0) - $totalfinal) > 0.01): ?>
                        La suma de pagos debe ser igual al total.
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
            <div class="flex justify-end space-x-2">
                <button type="button" wire:click="cancelarPago"
                    class="px-4 py-2 bg-gray-100 rounded">Cancelar</button>
                <button type="button" wire:click="procesarVenta"
                    class="px-4 py-2 bg-green-600 text-white rounded">Confirmar y Guardar</button>
            </div>
        </div>
    </div>

</div><?php /**PATH /Users/gabrielsp/Documents/Development/Enkelt/resources/views/livewire/punto-de-venta/punto-ventas/index.blade.php ENDPATH**/ ?>