<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Ventas por <?php echo e($tipoVenta === 'familia' ? 'Familia' : 'Producto'); ?></title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 11px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        h1 {
            font-size: 18px;
            margin: 0 0 10px 0;
            color: #333;
        }
        .info {
            font-size: 10px;
            color: #666;
        }
        .filters {
            background-color: #f9f9f9;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            font-size: 10px;
        }
        .filters strong {
            color: #333;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 6px 8px;
            text-align: left;
        }
        .table th {
            background-color: #4a5568;
            color: white;
            font-weight: bold;
            font-size: 10px;
        }
        .table td {
            font-size: 10px;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
        }
        .totals {
            background-color: #e2e8f0;
            font-weight: bold;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 9px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Reporte de Ventas por <?php echo e($tipoVenta === 'familia' ? 'Familia' : 'Producto'); ?></h1>
        <p class="info">Reporte generado el: <?php echo e(now()->format('d/m/Y H:i:s')); ?></p>
    </div>

    <div class="filters">
        <strong>Filtros aplicados:</strong><br>
        Fecha: <?php echo e(\Carbon\Carbon::parse($fechainicial)->format('d/m/Y')); ?> - <?php echo e(\Carbon\Carbon::parse($fechafinal)->format('d/m/Y')); ?><br>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sucursal): ?>
            Sucursal: <?php echo e($sucursal); ?><br>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($familia): ?>
            Familia: <?php echo e($familia); ?><br>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($usuario): ?>
            Usuario: <?php echo e($usuario); ?><br>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($turnosInfo): ?>
            <?php echo e($turnosInfo); ?><br>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th><?php echo e($tipoVenta === 'familia' ? 'Familia' : 'Producto'); ?></th>
                <th class="text-right">Cantidad</th>
                <th class="text-right">Costo</th>
                <th class="text-right">Subtotal</th>
                <th class="text-right">IVA</th>
                <th class="text-right">Total</th>
                <th class="text-right">Utilidad</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($item->nombre); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->cantidad, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($item->costo, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($item->subtotal, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($item->iva, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($item->total, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($item->utilidad, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="text-align: center;">No hay datos para mostrar</td>
                </tr>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
        <tfoot>
            <tr class="totals">
                <td><strong>TOTALES</strong></td>
                <td class="text-right"><strong><?php echo e(number_format($totales['cantidad'], 2)); ?></strong></td>
                <td class="text-right"><strong>$<?php echo e(number_format($totales['costo'], 2)); ?></strong></td>
                <td class="text-right"><strong>$<?php echo e(number_format($totales['subtotal'], 2)); ?></strong></td>
                <td class="text-right"><strong>$<?php echo e(number_format($totales['iva'], 2)); ?></strong></td>
                <td class="text-right"><strong>$<?php echo e(number_format($totales['total'], 2)); ?></strong></td>
                <td class="text-right"><strong>$<?php echo e(number_format($totales['utilidad'], 2)); ?></strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Página {PAGENO} de {nbpg}</p>
    </div>
</body>
</html>
<?php /**PATH /Users/gabrielsp/Documents/Development/Enkelt/resources/views/exports/ventas-familia-producto.blade.php ENDPATH**/ ?>