<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ProductoController;
use App\Http\Controllers\Api\ClienteController;
use App\Http\Controllers\Api\ConfigController;
use App\Http\Controllers\Api\EmpresaController;
use App\Http\Controllers\Api\MovInvExistenciaController;
use App\Http\Controllers\Api\PedidosIntermediosController;
use App\Http\Controllers\Api\PedidosIntermediosDetalleController;
use App\Http\Controllers\Api\PedidosIntermediosGeneralController;
use App\Http\Controllers\Api\RutasController;
use App\Http\Controllers\Api\SucursalController;


Route::group(['prefix' => 'auth'], function () {
    Route::post('/login', [AuthController::class, 'login']);
    Route::middleware(['jwt'])->group( function () {
        Route::get('/me', [AuthController::class, 'me']);
        Route::get('/logout', [AuthController::class, 'logout']);
    });
    Route::get('/refresh-token', [AuthController::class, 'refreshToken']);
});

Route::middleware(['jwt', 'tenancy.jwt'])->group(function () {
    
    Route::group(['prefix' => 'products'], function () {
        Route::get('/', [ProductoController::class, 'index']);
    });
    
    Route::get('productos', [ProductoController::class, 'index']);
    Route::get('productos/buscar_uno_solo', [ProductoController::class, 'buscarUnoSolo']);
    Route::get('productos/con-existencia', [ProductoController::class, 'productosConExistencia']);
    
    // Punto de Venta
    Route::group(['prefix' => 'punto-venta'], function () {
        $idPath = '/{id}';
        Route::get('/', [\App\Http\Controllers\Api\PuntoVentaController::class, 'index']);
        Route::post('/', [\App\Http\Controllers\Api\PuntoVentaController::class, 'store']);
        Route::get($idPath, [\App\Http\Controllers\Api\PuntoVentaController::class, 'show']);
        Route::get($idPath . '/productos', [\App\Http\Controllers\Api\PuntoVentaController::class, 'showProductos']);
        Route::put($idPath, [\App\Http\Controllers\Api\PuntoVentaController::class, 'update']);
        Route::delete($idPath, [\App\Http\Controllers\Api\PuntoVentaController::class, 'destroy']);
    });

    // Endpoint para obtener la lista de pedidos intermedios generales
    Route::get('pedidos_intermedios_general', [PedidosIntermediosGeneralController::class, 'index']);

    // Pedidos Intermedios
    Route::post('pedidos_intermedios', [PedidosIntermediosController::class, 'store']);

    // Endpoint para obtener los detalles de un pedido intermedio específico
    Route::get('pedidos_intermedios/{id}', [PedidosIntermediosController::class, 'show']);

    // Clientes
    Route::get('clientes', [ClienteController::class, 'index']);

    // Sucursales
    Route::get('sucursales', [SucursalController::class, 'index']);
    Route::get('sucursales/{id}', [SucursalController::class, 'show']);
    
    // Rutas
    Route::get('rutas', [RutasController::class, 'index']);
    Route::post('rutas', [RutasController::class, 'store']);
    
    // Configuración
    Route::get('config', [ConfigController::class, 'getConfig']);
        
    // Utilidades
    Route::get('valida_token', function(){
        return response()->json(['valid' => true, 'message' => 'Token is valid']);
    });
    
    Route::get('prueba', function(){
        return response()->json(['status' => 'ok', 'message' => 'API is working']);
    });
});

