@if($mostrarModalPartida)
<div class="fixed inset-0 z-50 overflow-y-auto">
    <div class="flex min-h-screen items-center justify-center p-4">
        <!-- Overlay transparente con blur -->
        <div class="fixed inset-0 bg-black/20 backdrop-blur-sm" wire:click="cancelarEdicionPartida"></div>
        
        <!-- Modal content -->
        <div class="relative bg-white/95 backdrop-blur-md rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto border border-white/20">
            <div class="p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold text-gray-900">Edición de Partida</h2>
                    <button wire:click="cancelarEdicionPartida" class="text-gray-400 hover:text-gray-600 transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                @if($partidaEditando)
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Información del Producto -->
                    <div class="space-y-4">
                        <div class="bg-blue-50/80 backdrop-blur-sm p-4 rounded-lg border border-blue-200/50">
                            <h3 class="text-lg font-semibold mb-3 text-blue-800">Información del Producto</h3>
                            
                            <div class="space-y-3">
                                <div>
                                    <label for="clave" class="block text-sm font-medium text-gray-700">Clave:</label>
                                    <input id="clave" type="text" value="{{ $partidaEditando['clave'] ?? 'N/A' }}" readonly class="text-sm text-gray-900 font-medium bg-transparent border-0 p-0 focus:ring-0">
                                </div>
                                
                                <div>
                                    <label for="descripcion" class="block text-sm font-medium text-gray-700">Descripción:</label>
                                    <p id="descripcion" class="text-sm text-gray-900 font-medium">{{ $partidaEditando['descripcion'] ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Datos Básicos -->
                        <div class="bg-gray-50/80 backdrop-blur-sm p-4 rounded-lg border border-gray-200/50">
                            <h3 class="text-lg font-semibold mb-3 text-gray-800">Datos Básicos</h3>
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label for="cantidad" class="block text-sm font-medium text-gray-700">Cantidad:</label>
|                                       <input id="cantidad" wire:model.live.debounce.1s="partidaEditando.cantidad" type="number" step="1" min="1"
                                           class="mt-1 block w-full rounded-md border-gray-300/50 bg-white/80 backdrop-blur-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500 transition-all">
                                </div>
                                
                                <div>
                                    <label for="precio_unitario" class="block text-sm font-medium text-gray-700">Precio Unitario:</label>
                                    <input id="precio_unitario" wire:model.live.debounce.1s="partidaEditando.precio_unitario" type="number" step="0.01" min="0"
                                           class="mt-1 block w-full rounded-md border-gray-300/50 bg-white/80 backdrop-blur-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500 transition-all">
                                </div>
                                
                                <div>
                                    <label for="importe" class="block text-sm font-medium text-gray-700">Importe:</label>
                                    <input id="importe" wire:model="partidaEditando.importe" type="number" step="0.01" readonly
                                           class="mt-1 block w-full rounded-md border-gray-300/50 bg-gray-100/80 backdrop-blur-sm shadow-sm">
                                </div>
                                
                                <div>
                                    <label for="subtotal" class="block text-sm font-medium text-gray-700">Subtotal:</label>
                                    <input id="subtotal" wire:model="partidaEditando.subtotal" type="number" step="0.01" readonly
                                           class="mt-1 block w-full rounded-md border-gray-300/50 bg-gray-100/80 backdrop-blur-sm shadow-sm">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Tres Descuentos -->
                        <div class="bg-red-50/80 backdrop-blur-sm p-4 rounded-lg border border-red-200/50">
                            <h3 class="text-lg font-semibold mb-3 text-red-800">Descuentos</h3>
                            
                            <div class="space-y-3">
                                <!-- Descuento 1 -->
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <label for="descuento1_porcentaje" class="block text-sm font-medium text-gray-700">Desc. 1 (%):</label>
                                        <input id="descuento1_porcentaje" wire:model.live.debounce.1s="partidaEditando.descuento1_porcentaje" type="number" step="0.01" min="0" max="100"
                                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    </div>
                                    
                                    <div>
                                        <label for="descuento1_importe" class="block text-sm font-medium text-gray-700">Importe Desc. 1:</label>
                                        <input id="descuento1_importe" wire:model="partidaEditando.descuento1_importe" type="number" step="0.01" readonly
                                               class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                    </div>
                                </div>
                                
                                <!-- Descuento 2 -->
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <label for="descuento2_porcentaje" class="block text-sm font-medium text-gray-700">Desc. 2 (%):</label>
                                        <input id="descuento2_porcentaje" wire:model.live.debounce.1s="partidaEditando.descuento2_porcentaje" type="number" step="0.01" min="0" max="100"
                                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    </div>
                                    
                                    <div>
                                        <label for="descuento2_importe" class="block text-sm font-medium text-gray-700">Importe Desc. 2:</label>
                                        <input id="descuento2_importe" wire:model="partidaEditando.descuento2_importe" type="number" step="0.01" readonly
                                               class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                    </div>
                                </div>
                                
                                <!-- Descuento 3 -->
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <label for="descuento3_porcentaje" class="block text-sm font-medium text-gray-700">Desc. 3 (%):</label>
                                        <input id="descuento3_porcentaje" wire:model.live.debounce.1s="partidaEditando.descuento3_porcentaje" type="number" step="0.01" min="0" max="100"
                                               class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    </div>
                                    
                                    <div>
                                        <label for="descuento3_importe" class="block text-sm font-medium text-gray-700">Importe Desc. 3:</label>
                                        <input id="descuento3_importe" wire:model="partidaEditando.descuento3_importe" type="number" step="0.01" readonly
                                               class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                    </div>
                                </div>
                                
                                <!-- Descuento Total -->
                                <div class="pt-2 border-t">
                                    <div>
                                        <label for="descuento_total" class="block text-sm font-medium text-gray-700">Descuento Total:</label>
                                        <input id="descuento_total" wire:model="partidaEditando.descuento_total" type="number" step="0.01" readonly
                                               class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Información de Impuestos -->
                    <div class="space-y-4">
                        <div class="bg-green-50/80 backdrop-blur-sm p-4 rounded-lg border border-green-200/50">
                            <h3 class="text-lg font-semibold mb-3 text-green-800">Impuestos</h3>
                            
                            <div class="space-y-3">
                                <div>
                                    <label for="iva_porcentaje" class="block text-sm font-medium text-gray-700">IVA (%):</label>
                                    <input id="iva_porcentaje" wire:model.live.debounce.1s="partidaEditando.iva_porcentaje" type="number" step="0.01" min="0" max="100"
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                
                                <div>
                                    <label for="iva_importe" class="block text-sm font-medium text-gray-700">Importe IVA:</label>
                                    <input id="iva_importe" wire:model="partidaEditando.iva_importe" type="number" step="0.01" readonly
                                           class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                </div>
                                
                                <div>
                                    <label for="ieps_porcentaje" class="block text-sm font-medium text-gray-700">IEPS (%):</label>
                                    <input id="ieps_porcentaje" wire:model.live.debounce.1s="partidaEditando.ieps_porcentaje" type="number" step="0.01" min="0"
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                
                                <div>
                                    <label for="ieps_importe" class="block text-sm font-medium text-gray-700">Importe IEPS:</label>
                                    <input id="ieps_importe" wire:model="partidaEditando.ieps_importe" type="number" step="0.01" readonly
                                           class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                </div>
                                
                                <!-- Retenciones -->
                                <div class="pt-3 border-t border-green-200">
                                    <h4 class="text-md font-medium text-gray-800 mb-2">Retenciones</h4>
                                    
                                    <!-- Retención ISR -->
                                    <div class="grid grid-cols-2 gap-4 mb-3">
                                        <div>
                                            <label for="retencion_isr_porcentaje" class="block text-sm font-medium text-gray-700">R.ISR (%):</label>
                                            <input id="retencion_isr_porcentaje" wire:model.live.debounce.1s="partidaEditando.retencion_isr_porcentaje" type="number" step="0.01" min="0" max="100"
                                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        </div>
                                        
                                        <div>
                                            <label for="retencion_isr_importe" class="block text-sm font-medium text-gray-700">Importe R.ISR:</label>
                                            <input id="retencion_isr_importe" wire:model="partidaEditando.retencion_isr_importe" type="number" step="0.01" readonly
                                                   class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                        </div>
                                    </div>
                                    
                                    <!-- Retención IVA -->
                                    <div class="grid grid-cols-2 gap-4">
                                        <div>
                                            <label for="retencion_iva_porcentaje" class="block text-sm font-medium text-gray-700">R.IVA (%):</label>
                                            <input id="retencion_iva_porcentaje" wire:model.live.debounce.1s="partidaEditando.retencion_iva_porcentaje" type="number" step="0.01" min="0" max="100"
                                                   class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        </div>
                                        
                                        <div>
                                            <label for="retencion_iva_importe" class="block text-sm font-medium text-gray-700">Importe R.IVA:</label>
                                            <input id="retencion_iva_importe" wire:model="partidaEditando.retencion_iva_importe" type="number" step="0.01" readonly
                                                   class="mt-1 block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Modalidad IEPS -->
                        <div class="bg-yellow-50/80 backdrop-blur-sm p-4 rounded-lg border border-yellow-200/50">
                            <h3 class="text-lg font-semibold mb-3 text-yellow-800">Modalidad IEPS</h3>
                            
                            <select wire:model="partidaEditando.modalidad_ieps"
                                    class="mt-1 block w-full rounded-md border-gray-300/50 bg-white/80 backdrop-blur-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500 transition-all">
                                <option value="exento">IEPS Exento</option>
                                <option value="tasa">IEPS Tasa</option>
                                <option value="cuota">IEPS Cuota</option>
                            </select>
                        </div>
                        
                        <!-- Descripción Adicional -->
                        <div class="bg-gray-50/80 backdrop-blur-sm p-4 rounded-lg border border-gray-200/50">
                            <h3 class="text-lg font-semibold mb-3 text-gray-800">Descripción Adicional</h3>
                            
                            <textarea wire:model="partidaEditando.descripcion_adicional" placeholder="Descripción adicional del producto..." rows="3"
                                      class="mt-1 block w-full rounded-md border-gray-300/50 bg-white/80 backdrop-blur-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500 transition-all"></textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Resumen Total -->
                <div class="mt-6 bg-blue-50/80 backdrop-blur-sm p-4 rounded-lg border border-blue-200/50">
                    <h3 class="text-lg font-semibold mb-3 text-blue-800">Resumen Total</h3>
                    
                    <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                        <div class="text-center">
                            <span class="text-sm text-gray-600">Importe</span>
                            <div class="text-lg font-bold text-blue-600">${{ number_format($partidaEditando['importe'] ?? 0, 2) }}</div>
                        </div>
                        <div class="text-center">
                            <span class="text-sm text-gray-600">Descuento</span>
                            <div class="text-lg font-bold text-red-600">${{ number_format($partidaEditando['descuento_total'] ?? 0, 2) }}</div>
                        </div>
                        <div class="text-center">
                            <span class="text-sm text-gray-600">Subtotal</span>
                            <div class="text-lg font-bold text-green-600">${{ number_format($partidaEditando['subtotal'] ?? 0, 2) }}</div>
                        </div>
                        <div class="text-center">
                            <span class="text-sm text-gray-600">Impuestos</span>
                            <div class="text-lg font-bold text-purple-600">${{ number_format(($partidaEditando['iva_importe'] ?? 0) + ($partidaEditando['ieps_importe'] ?? 0), 2) }}</div>
                        </div>
                        <div class="text-center">
                            <span class="text-sm text-gray-600">Retenciones</span>
                            <div class="text-lg font-bold text-orange-600">-${{ number_format(($partidaEditando['retencion_isr_importe'] ?? 0) + ($partidaEditando['retencion_iva_importe'] ?? 0), 2) }}</div>
                        </div>
                        <div class="text-center">
                            <span class="text-sm text-gray-600">Total</span>
                            <div class="text-xl font-bold text-gray-800">${{ number_format($partidaEditando['importe_total'] ?? 0, 2) }}</div>
                        </div>
                    </div>
                </div>
                @endif
                
                <!-- Botones -->
                <div class="mt-6 flex justify-end space-x-3">
                    <button wire:click="cancelarEdicionPartida"
                            class="px-4 py-2 border border-gray-300/50 rounded-md text-sm font-medium text-gray-700 bg-white/80 backdrop-blur-sm hover:bg-white/90 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all">
                        Cancelar
                    </button>
                    <button wire:click="confirmarEdicionPartida"
                            class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600/90 backdrop-blur-sm hover:bg-indigo-700/90 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-all">
                        Confirmar Cambios
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
