@php
use App\Livewire\Ventas\Cotizaciones\CotizacionesBaseLogic as Logic;
@endphp

<div>
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Nueva Cotización</h1>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Información General</h2>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
            <x-select id="sucursal" wire:model="sucursal" label="Sucursal:" placeholder="Selecciona una sucursal"
                error="sucursal" :options="$sucursales" />

            <x-input-label id="serie" wire:model="serie" label="Serie:" placeholder="Serie" readonly />

            <x-input-label id="fecha" wire:model="fechaForm" label="Fecha (*)" placeholder="Fecha" readonly/>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Datos del Cliente</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="cliente_search" class="block text-sm font-medium text-gray-700 mb-2">Cliente:</label>
                
                <div class="relative" x-data="{ open: @entangle('mostrarTablaClientes') }" x-on:click.away="open = false">
                    <div class="flex">
                        <input type="text"
                               id="cliente_search"
                               wire:model.live.debounce.300ms="search.clientes"
                               x-on:focus="$wire.abrirDropdownClientes()"
                               class="flex-1 border border-gray-300 rounded-l-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                               placeholder="Buscar cliente...">
                        <button type="button"
                                x-on:click="if (open) { open = false; $wire.cerrarDropdownClientes(); } else { open = true; $wire.abrirDropdownClientes(); }"
                                class="px-3 py-2 bg-gray-100 border border-l-0 border-gray-300 rounded-r-md hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <svg class="w-5 h-5 text-gray-600 transform transition-transform duration-200"
                                 x-bind:class="{ 'rotate-180': open }"
                                 fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                    </div>
                    
                    @if($clientes && count($clientes) > 0)
                        <div x-show="open"
                             x-transition
                             class="dropdown-cliente absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-y-auto">
                            @foreach($clientes as $cliente)
                                <div class="px-3 py-2 hover:bg-gray-100 cursor-pointer border-b border-gray-100"
                                     wire:click="seleccionarCliente({{ $cliente->idclient }})"
                                     x-on:click="open = false">
                                    <div class="font-medium">{{ $cliente->nombre }}</div>
                                    <div class="text-sm text-gray-600">{{ $cliente->rfc }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            <x-input-label id="nombre" wire:model="clientenombre" label="Nombre:" placeholder="Nombre del cliente"
                readonly />

            <x-input-label id="rfc" wire:model="clienterfc" label="RFC:" placeholder="RFC del cliente"
                readonly />

            <div>
                <label for="direccion_fiscal" class="block text-sm font-medium text-gray-700 mb-2">Dirección
                    fiscal:</label>
                <textarea id="direccion_fiscal" wire:model="clientedireccion"
                    class="w-full border border-gray-300 rounded-md px-3 py-2 bg-gray-100" rows="3" readonly></textarea>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Datos del Producto</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
            <div>
                <label for="producto_search" class="block text-sm font-medium text-gray-700 mb-2">Producto:</label>
                
                <div class="relative" x-data="{ open: @entangle('mostrarTablaProductos') }" x-on:click.away="open = false">
                    <div class="flex">
                        <input type="text"
                               id="producto_search"
                               wire:model.live.debounce.300ms="search.productos"
                               x-on:focus="$wire.abrirDropdownProductos()"
                               class="flex-1 border border-gray-300 rounded-l-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                               placeholder="Buscar producto...">
                        <button type="button"
                                x-on:click="if (open) { open = false; $wire.cerrarDropdownProductos(); } else { open = true; $wire.abrirDropdownProductos(); }"
                                class="px-3 py-2 bg-gray-100 border border-l-0 border-gray-300 rounded-r-md hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <svg class="w-5 h-5 text-gray-600 transform transition-transform duration-200"
                                 x-bind:class="{ 'rotate-180': open }"
                                 fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                    </div>
                    
                    @if($productos && count($productos) > 0)
                        <div x-show="open"
                             x-transition
                             class="dropdown-producto absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-y-auto">
                            @foreach($productos as $producto)
                                <div class="px-3 py-2 hover:bg-gray-100 cursor-pointer border-b border-gray-100"
                                     wire:click="seleccionarProducto({{ $producto->idproduct }})"
                                     x-on:click="open = false">
                                    <div class="font-medium">{{ $producto->clave }} - {{ $producto->descripcion }}</div>
                                    <div class="text-sm text-gray-600">Precio: {{ Logic::formatearMoneda($producto->precioventaantesiva) }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            <x-input-label id="cantidad" wire:model.live="cantidad" label="Cantidad:" placeholder="Cantidad"
                type="number" min="1" step="1" />

            <x-input-label id="precioventaantesiva" wire:model.live="precioventaantesiva" label="Precio venta antes iva:"
                placeholder="Precio venta antes iva" type="number" step="0.01" min="0" />

            <x-input-label id="precioventaconiva" wire:model="precioventaconiva" label="Precio venta con iva:"
                placeholder="Precio venta con iva" type="number" step="0.01" readonly />

            <x-input-label id="descuento" wire:model.live="descuento" label="Descuento:" placeholder="Descuento"
                type="number" step="0.01" min="0" />

            <x-input-label id="descripcion" wire:model="descripcion" label="Descripción:"
                placeholder="Descripción del producto" readonly />
        </div>

        <div class="mb-4">
            <label for="descripcionadicional" class="block text-sm font-medium text-gray-700 mb-2">Descripción
                adicional:</label>
            <textarea id="descripcionadicional" wire:model="descripcionadicional"
                class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500"
                rows="3"></textarea>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
            <x-input-label id="claveproductoservicio" wire:model="claveproductoservicio"
                label="Clave producto/servicio:" placeholder="Clave producto/servicio" readonly />

            <x-input-label id="descripcionclaveproductoservicio" wire:model="descripcionclaveproductoservicio"
                label="Descripción clave producto/servicio:" placeholder="Descripción clave producto/servicio"
                readonly />

            <x-input-label id="claveunidadmedida" wire:model="claveunidadmedida" label="Clave unidad medida:"
                placeholder="Clave unidad medida" readonly />

            <x-input-label id="descripcionunidadmedida" wire:model="descripcionunidadmedida"
                label="Descripción unidad medida:" placeholder="Descripción unidad medida" readonly />
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
            <x-input-label id="ivatrasladado" wire:model="ivatrasladado" label="IVA trasladado:"
                placeholder="IVA trasladado" type="number" step="0.01" readonly />

            <x-input-label id="ivaretenido" wire:model="ivaretenido" label="IVA retenido:"
                placeholder="IVA retenido" type="number" step="0.01" readonly />

            <x-input-label id="iepstrasladado" wire:model="iepstrasladado" label="IEPS trasladado:"
                placeholder="IEPS trasladado" type="number" step="0.01" readonly />

            <x-input-label id="isrretenido" wire:model="isrretenido" label="ISR retenido:"
                placeholder="ISR retenido" type="number" step="0.01" readonly />
        </div>

        <div class="flex space-x-3">
            <button type="button" wire:click="agregarProducto"
                class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded-md flex items-center space-x-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                <span>Agregar</span>
            </button>
            <button type="button" wire:click="cancelarProducto"
                class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-md flex items-center space-x-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                    </path>
                </svg>
                <span>Cancelar</span>
            </button>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-lg font-semibold text-gray-800">Productos Agregados</h2>
            <span class="text-sm text-gray-600">Partidas totales: {{ Logic::getTotalPartidas($productosagregados) }} | Límite: 300</span>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full border-collapse border border-gray-300">
                <thead>
                    <tr class="bg-gray-50">
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">
                            Cantidad</th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">Clave
                        </th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">
                            Descripción</th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">Precio
                            Unit.</th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">
                            Importe</th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">
                            Descuento</th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">
                            Subtotal</th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">IEPS
                        </th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">IVA
                        </th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">R. IVA
                        </th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">R. ISR
                        </th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">Total
                        </th>
                        <th class="border border-gray-300 px-4 py-2 text-left text-sm font-medium text-gray-700">
                            Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @if (count($productosagregados) > 0)
                        @foreach ($productosagregados as $indice => $producto)
                            <tr class="hover:bg-gray-50 hover:cursor-pointer" wire:dblclick="editarPartida({{ $indice }})" title="Doble click para editar partida"
                                wire:key="producto-{{ $indice }}">
                                <td class="border border-gray-300 px-4 py-2 text-center">{{ $producto['cantidad'] }}
                                </td>
                                <td class="border border-gray-300 px-4 py-2">{{ $producto['clave'] }}</td>
                                <td class="border border-gray-300 px-4 py-2">
                                    <div>{{ $producto['descripcion'] }}</div>
                                    @if ($producto['descripcion_adicional'])
                                        <div class="text-sm text-gray-600">{{ $producto['descripcion_adicional'] }}
                                        </div>
                                    @endif
                                </td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['precio_unitario']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['importe']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['descuento']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['subtotal']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['ieps_trasladado']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['iva_trasladado']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['iva_retenido']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right">
                                    {{ Logic::formatearMoneda($producto['isr_retenido']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-right font-bold">
                                    {{ Logic::formatearMoneda($producto['total']) }}</td>
                                <td class="border border-gray-300 px-4 py-2 text-center">
                                    <div class="flex justify-center space-x-2">
                                        <button type="button" wire:click="editarPartida({{ $indice }})"
                                            class="text-blue-600 hover:text-blue-800" title="Editar partida">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                            </svg>
                                        </button>
                                        
                                        <!-- Botón Eliminar -->
                                        <button type="button" wire:click="eliminarProducto('{{ $producto['id'] }}')"
                                            class="text-red-600 hover:text-red-800" title="Eliminar producto">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                </path>
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="13" class="border border-gray-300 px-4 py-8 text-center text-gray-500">
                                No hay productos agregados
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Totales</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <div>
                <label for="importetotal" class="block text-sm font-medium text-gray-700 mb-2">Importe:</label>
                <div id="importetotal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($importetotal) }}</div>
            </div>
            <div>
                <label for="descuentototal" class="block text-sm font-medium text-gray-700 mb-2">Descuento:</label>
                <div id="descuentototal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($descuentototal) }}</div>
            </div>
            <div>
                <label for="subtotaltotal" class="block text-sm font-medium text-gray-700 mb-2">Subtotal:</label>
                <div id="subtotaltotal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($subtotaltotal) }}</div>
            </div>
            <div>
                <label for="retivatotal" class="block text-sm font-medium text-gray-700 mb-2">Ret. IVA:</label>
                <div id="retivatotal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($retivatotal) }}</div>
            </div>

            <div>
                <label for="retisrtotal" class="block text-sm font-medium text-gray-700 mb-2">Ret. ISR:</label>
                <div id="retisrtotal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($retisrtotal) }}</div>
            </div>
            <div>
                <label for="iepstotal" class="block text-sm font-medium text-gray-700 mb-2">IEPS:</label>
                <div id="iepstotal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($iepstotal) }}</div>
            </div>
            <div>
                <label for="impuestototal" class="block text-sm font-medium text-gray-700 mb-2">Impuesto:</label>
                <div id="impuestototal" class="bg-gray-100 border rounded-md px-3 py-2 text-right">
                    {{ Logic::formatearMoneda($impuestototal) }}</div>
            </div>
            <div>
                <label for="totalfinal" class="block text-sm text-gray-700 mb-2 font-bold">Total:</label>
                <div id="totalfinal"
                    class="bg-blue-50 border-2 border-blue-300 rounded-md px-3 py-2 text-right font-bold text-blue-800">
                    {{ Logic::formatearMoneda($totalfinal) }}</div>
            </div>
        </div>

        <div class="mt-4">
            <label for="importetotalletras" class="block text-sm font-medium text-gray-700 mb-2">Importe total en
                letras:</label>
            <div id="importetotalletras" class="bg-gray-100 border rounded-md px-3 py-2 text-gray-600">
                {{ $importetotalletras }}
            </div>
        </div>
    </div>

    @if ($errors->any())
        <div class="bg-red-50 border border-red-200 rounded-md p-4 mb-6">
            <div class="flex">
                <svg class="w-5 h-5 text-red-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16c-.77.833.192 2.5 1.732 2.5z">
                    </path>
                </svg>
                <div>
                    <h3 class="text-sm font-medium text-red-800">Se encontraron errores:</h3>
                    <ul class="mt-2 text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    @if (session()->has('message'))
        <div class="bg-green-50 border border-green-200 rounded-md p-4 mb-6">
            <div class="flex">
                <svg class="w-5 h-5 text-green-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <h3 class="text-sm font-medium text-green-800">{{ session('message') }}</h3>
                </div>
            </div>
        </div>
    @endif

    <div class="flex justify-end space-x-3">
        <button type="button" wire:click="cancelar" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-md">
            Cancelar
        </button>
        <button type="button" wire:click="guardarCotizacion" class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-2 rounded-md flex items-center space-x-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <span>Guardar Cotización</span>
        </button>
    </div>

    @include('livewire.ventas.cotizaciones.modal-partida')
</div>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('console-log', (data) => {
        console.log('Datos del cliente seleccionado:', data);
    });
});
</script>
