{{-- Tabla de productos con existencias por sucursal --}}
<x-data-table :title="'Productos'" :total="$productos->total()" :count="$productos->count()">
    <thead class="bg-gray-50 dark:bg-gray-900">
        <tr>
            <x-data-table.header sticky position="0">Folio</x-data-table.header>
            <x-data-table.header sticky position="20">Clave</x-data-table.header>
            <x-data-table.header sticky position="40" class="min-w-[150px]">Familia</x-data-table.header>
            <x-data-table.header sticky position="60" class="min-w-[250px]">Descripción</x-data-table.header>
            
            @foreach ($sucursales as $sucursal)
                <x-data-table.header class="text-center min-w-[120px]">
                    {{ $sucursal->razon_social }}
                </x-data-table.header>
            @endforeach
        </tr>
    </thead>
    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
        @forelse ($productos as $index => $producto)
            <tr wire:key="producto-{{ $producto->idproduct }}" class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                <x-data-table.cell sticky position="0" class="font-medium">
                    {{ $productos->firstItem() + $index }}
                </x-data-table.cell>

                <x-data-table.cell sticky position="20" class="text-gray-700 dark:text-gray-300">
                    {{ $producto->clave }}
                </x-data-table.cell>

                <x-data-table.cell sticky position="40" class="text-gray-700 dark:text-gray-300">
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                        {{ $producto->familia ?? 'Sin familia' }}
                    </span>
                </x-data-table.cell>

                <x-data-table.cell sticky position="60">
                    {{ $producto->descripcion }}
                </x-data-table.cell>

                @foreach ($sucursales as $sucursal)
                    <td class="px-4 py-3 text-center">
                        @php
                            $existencia = $producto->existencias[$sucursal->idbranchoffice] ?? 0;
                            $colorClass = $existencia > 0 
                                ? 'text-green-600 dark:text-green-400 font-semibold' 
                                : 'text-gray-400 dark:text-gray-600';
                        @endphp
                        <span class="{{ $colorClass }}">
                            {{ number_format($existencia, 0) }}
                        </span>
                    </td>
                @endforeach
            </tr>
        @empty
            <tr>
                <td colspan="{{ 4 + count($sucursales) }}" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                    <div class="flex flex-col items-center justify-center">
                        <svg class="w-12 h-12 mb-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                        </svg>
                        <p class="text-lg font-medium">No se encontraron productos</p>
                        <p class="text-sm mt-1">Intenta ajustar los filtros de búsqueda</p>
                    </div>
                </td>
            </tr>
        @endforelse
    </tbody>
</x-data-table>

{{-- Paginación --}}
<div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-800 rounded-b-xl">
    {{ $productos->onEachSide(1)->links() }}
</div>
