
<div class="flex w-full flex-1 flex-col gap-6 p-4 md:p-6">
    {{-- Header Section --}}
    <div class="flex items-center justify-between">
        <div>
            <flux:heading size="xl">Existencias por Sucursales</flux:heading>
            <flux:subheading class="mt-1">Consulta el inventario de productos distribuido por cada sucursal</flux:subheading>
        </div>
        <div class="flex items-center gap-2">
            <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
            </svg>
            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">{{ count($sucursales) }} Sucursales</span>
        </div>
    </div>
    

    {{-- Formulario de Filtros --}}
    @include('livewire.reportes.ventas-por-sucursales.partials.filter-form')

    {{-- Tabla de Resultados --}}
    @include('livewire.reportes.ventas-por-sucursales.partials.tabla-resultados')

    {{-- Modal de Exportación --}}
    <x-export-modal
        title="Exportar reporte de existencias por sucursales"
        description="Seleccione el formato para exportar el reporte de existencias."
        wire:model="isOpenModalExportarReporte"
        exportPdf="exportarPdfReporteVentasPorSucursales"
        exportExcel="exportarExcelReporteVentasPorSucursales"
    />
</div>
