<x-data-table>
    <thead>
        <tr class="text-sm font-semibold text-right border-b dark:border-zinc-700">
            <x-data-table.header class="text-left">
                @if ($tipoVenta === 'familia')
                    Familia
                @else
                    Producto
                @endif
            </x-data-table.header>
            <x-data-table.header class="text-right">Cantidad</x-data-table.header>
            <x-data-table.header class="text-right">Costo</x-data-table.header>
            <x-data-table.header class="text-right">Subtotal</x-data-table.header>
            <x-data-table.header class="text-right">IVA</x-data-table.header>
            <x-data-table.header class="text-right">Total</x-data-table.header>
            <x-data-table.header class="text-right">Utilidad</x-data-table.header>
        </tr>
    </thead>
    <tbody class="divide-y dark:divide-zinc-700">
        @forelse($ventasPorFamilia as $venta)
            <tr class="text-sm hover:bg-zinc-50 dark:hover:bg-zinc-800/50 transition-colors">
                <x-data-table.cell class="text-left">
                    {{ $venta->nombre }}
                </x-data-table.cell>
                <x-data-table.cell class="text-right font-mono tabular-nums">
                    {{ number_format($venta->cantidad, 3) }}
                </x-data-table.cell>
                <x-data-table.cell class="text-right font-mono tabular-nums">
                    ${{ number_format($venta->costo, 2) }}
                </x-data-table.cell>
                <x-data-table.cell class="text-right font-mono tabular-nums">
                    ${{ number_format($venta->subtotal, 2) }}
                </x-data-table.cell>
                <x-data-table.cell class="text-right font-mono tabular-nums">
                    ${{ number_format($venta->iva, 2) }}
                </x-data-table.cell>
                <x-data-table.cell class="text-right font-mono tabular-nums">
                    ${{ number_format($venta->total, 2) }}
                </x-data-table.cell>
                <x-data-table.cell class="text-right font-mono tabular-nums">
                    ${{ number_format($venta->utilidad, 2) }}
                </x-data-table.cell>
            </tr>
        @empty
            <tr>
                <td colspan="7" class="py-12 text-center">
                    <div class="flex flex-col items-center gap-2 text-zinc-500 dark:text-zinc-400">
                        <flux:icon.document-magnifying-glass class="w-12 h-12" />
                        <p class="text-sm">No hay datos disponibles</p>
                        <p class="text-xs">Ajusta los filtros y presiona Consultar</p>
                    </div>
                </td>
            </tr>
        @endforelse
    </tbody>
    <tfoot class="border-t-2 dark:border-zinc-700 bg-zinc-50 dark:bg-zinc-800/50">
        <tr class="font-bold text-sm">
            <td class="py-3 px-4">Totales</td>
            <td class="py-3 px-4 text-right font-mono tabular-nums">
                {{ number_format($totalCantidad, 3) }}
            </td>
            <td class="py-3 px-4 text-right font-mono tabular-nums">
                ${{ number_format($totalCosto, 2) }}
            </td>
            <td class="py-3 px-4 text-right font-mono tabular-nums">
                ${{ number_format($totalSubtotal, 2) }}
            </td>
            <td class="py-3 px-4 text-right font-mono tabular-nums">
                ${{ number_format($totalIva, 2) }}
            </td>
            <td class="py-3 px-4 text-right font-mono tabular-nums">
                ${{ number_format($totalTotal, 2) }}
            </td>
            <td class="py-3 px-4 text-right font-mono tabular-nums">
                ${{ number_format($totalUtilidad, 2) }}
            </td>
        </tr>
    </tfoot>
</x-data-table>
