<x-card class="space-y-6">
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">

        {{-- Fecha Inicio --}}
        <flux:field>
            <flux:label>Fecha inicio</flux:label>
            <flux:input type="date" wire:model="fechainicial" />
        </flux:field>

        {{-- Fecha Final --}}
        <flux:field>
            <flux:label>Fecha final</flux:label>
            <flux:input type="date" wire:model="fechafinal" />
        </flux:field>

        {{-- Sucursal --}}
        <flux:field>
            <flux:label>Sucursal</flux:label>
            <flux:select wire:model.live="idsucursal">
                <option value="0">Todas las Sucursales</option>
                @foreach ($sucursales as $key => $sucursal)
                    <option value="{{ $key }}">{{ $sucursal }}</option>
                @endforeach
            </flux:select>
        </flux:field>

        {{-- Ventas por --}}
        <flux:field>
            <flux:label>Ventas por</flux:label>
            <flux:select wire:model.live="tipoVenta">
                <option value="familia">Familia</option>
                <option value="producto">Producto</option>
            </flux:select>
        </flux:field>

        {{-- Familias --}}
        <flux:field>
            <flux:label>Familias</flux:label>
            <flux:select wire:model="idfamilia">
                <option value="0">Todas las familias</option>
                @foreach ($familias as $key => $familia)
                    <option value="{{ $key }}">{{ $familia }}</option>
                @endforeach
            </flux:select>
        </flux:field>

        {{-- Usuario --}}
        <flux:field>
            <flux:label>Usuario</flux:label>
            <flux:select wire:model="idusuario">
                <option value="0">Todos</option>
                @foreach ($usuarios as $key => $usuario)
                    <option value="{{ $key }}">{{ $usuario }}</option>
                @endforeach
            </flux:select>
        </flux:field>

        {{-- Turnos --}}
        <flux:field>
            <flux:label>Turnos</flux:label>
            <div class="flex gap-2">
                <flux:input.group class="flex-1">
                    <flux:input
                        wire:model="turnosLabel"
                        readonly
                        class="flex-1 {{ $usarTurnos ? 'font-medium text-blue-600 dark:text-blue-400' : 'text-zinc-500' }}"
                        placeholder="Seleccionar turnos"
                    />

                    <flux:modal.trigger name="turnos-modal">
                        <flux:button icon="magnifying-glass" />
                    </flux:modal.trigger>
                </flux:input.group>

                @if($usarTurnos)
                    <flux:button
                        wire:click="limpiarTurnos"
                        variant="ghost"
                        icon="x-mark"
                        title="Limpiar filtro de turnos"
                    />
                @endif
            </div>
        </flux:field>

        {{-- Botones de Acción --}}
        <flux:field>
            <flux:label>Opción</flux:label>
            <div class="flex gap-2">
                <flux:button wire:click="consultar" class="w-full" variant="primary">
                    Consultar
                </flux:button>
                <flux:button wire:click="$set('modalExportarOpen', true)" variant="primary"
                    class="bg-green-600 hover:bg-green-700 text-white w-full">
                    Exportar
                </flux:button>
            </div>
        </flux:field>
    </div>

    {{-- Mensaje Importante --}}
    <div>
        <flux:heading class="font-semibold">Importante:</flux:heading>
        <flux:text class="text-sm mt-1">El tiempo de respuesta de la consulta varía dependiendo del rango de
            fechas
            proporcionado.</flux:text>
    </div>
</x-card>
