<div class="w-full px-6 py-4">
    <h1 class="text-2xl font-semibold mb-6">Productos <strong>más/menos</strong> vendidos</h1>

    <div class="bg-white rounded-lg shadow-sm border p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
            <!-- Primera fila -->
            <div>
                <label for="orden" class="block text-sm font-medium mb-1">Orden:</label>
                <select id="orden" wire:model="orden" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="masvendidos">Más vendidos</option>
                    <option value="menosvendidos">Menos vendidos</option>
                </select>
            </div>
            <div>
                <label for="fecha_inicio" class="block text-sm font-medium mb-1">Fecha inicio:</label>
                <input type="date" id="fecha_inicio" wire:model="fechainicio" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
            </div>
            <div>
                <label for="fecha_final" class="block text-sm font-medium mb-1">Fecha final:</label>
                <input type="date" id="fecha_final" wire:model="fechafinal" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
            </div>
            <div>
                <label for="sucursal" class="block text-sm font-medium mb-1">Sucursal:</label>
                <select id="sucursal" wire:model="sucursal" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todas las sucursales</option>
                    @foreach($sucursales ?? [] as $suc)
                        <option value="{{ $suc->idsucursal }}">{{ $suc->razon_social }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
            <!-- Segunda fila -->
            <div>
                <label for="usuario" class="block text-sm font-medium mb-1">Usuario:</label>
                <select id="usuario" wire:model="usuario" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todos</option>
                    @foreach($usuarios ?? [] as $usu)
                        <option value="{{ $usu->idusuario }}">{{ $usu->nombre }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="familias" class="block text-sm font-medium mb-1">Familias</label>
                <select id="familias" wire:model="familia" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todas las familias</option>
                    @foreach($familias ?? [] as $fam)
                        <option value="{{ $fam->idfamily }}">{{ $fam->nombrefamilia }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="marcas" class="block text-sm font-medium mb-1">Marcas</label>
                <select id="marcas" wire:model="marca" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todas las marcas</option>
                    @foreach($marcas ?? [] as $mar)
                        <option value="{{ $mar->idbrand }}">{{ $mar->marca }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="turnos" class="block text-sm font-medium mb-1">Turnos:</label>
                <div class="relative">
                    <input type="text" id="turnos" wire:model="turno" class="w-full border border-gray-300 rounded px-3 py-2 pr-10 text-sm" placeholder="">
                    <button type="button" class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- Tercera fila -->
            <div>
                <label for="filas" class="block text-sm font-medium mb-1">Filas:</label>
                <select id="filas" wire:model="filas" class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="20">20</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            <div class="md:col-span-3 flex items-end gap-2">
                <div class="text-sm font-medium mb-1 invisible" aria-hidden="true">Opción</div>
                <div class="flex gap-2">
                    <button type="button" wire:click="consultar" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded text-sm font-medium">
                        Consulta
                    </button>
                    <button type="button" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded text-sm font-medium">
                        Exportar
                    </button>
                </div>
            </div>
        </div>

        <div class="mt-4 p-3 bg-blue-50 border-l-4 border-blue-500 text-sm">
            <p class="text-blue-800">
                <strong>Importante:</strong> El tiempo de respuesta de la consulta varía dependiendo del rango de fechas proporcionado.
            </p>
        </div>
    </div>

    <!-- Tabla de resultados -->
    <div class="bg-white rounded-lg shadow-sm border overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-100 border-b">
                    <tr>
                        <th class="text-left px-4 py-3 font-semibold">Producto</th>
                        <th class="text-left px-4 py-3 font-semibold">Familia</th>
                        <th class="text-left px-4 py-3 font-semibold">Marca</th>
                        <th class="text-right px-4 py-3 font-semibold">Existencia actual</th>
                        <th class="text-right px-4 py-3 font-semibold">Cantidad Vendida</th>
                        <th class="text-right px-4 py-3 font-semibold">Total Vendido</th>
                        <th class="text-right px-4 py-3 font-semibold">Costo</th>
                        <th class="text-right px-4 py-3 font-semibold">Utilidad</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @forelse ($productos ?? [] as $producto)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3">{{ $producto->descripcion ?? $producto->nombre ?? 'N/A' }}</td>
                            <td class="px-4 py-3">{{ $producto->familia->nombrefamilia ?? 'N/A' }}</td>
                            <td class="px-4 py-3">{{ $producto->marca->marca ?? 'N/A' }}</td>
                            <td class="px-4 py-3 text-right">{{ number_format($producto->existencia_actual ?? 0, 2) }}</td>
                            <td class="px-4 py-3 text-right">{{ number_format($producto->cantidad_vendida ?? 0, 2) }}</td>
                            <td class="px-4 py-3 text-right">$ {{ number_format($producto->total_vendido ?? 0, 2) }}</td>
                            <td class="px-4 py-3 text-right">$ {{ number_format($producto->costo ?? 0, 2) }}</td>
                            <td class="px-4 py-3 text-right">$ {{ number_format($producto->utilidad ?? 0, 2) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-4 py-8 text-center text-gray-500">
                                No se encontraron resultados para los filtros seleccionados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
                <tfoot class="bg-gray-50 border-t-2">
                    <tr class="font-semibold">
                        <td colspan="4" class="px-4 py-3 text-right">Totales</td>
                        <td class="px-4 py-3 text-right">{{ number_format($totales['cantidadvendida'] ?? 0, 2) }}</td>
                        <td class="px-4 py-3 text-right">$ {{ number_format($totales['totalvendido'] ?? 0, 2) }}</td>
                        <td class="px-4 py-3 text-right">$ {{ number_format($totales['costo'] ?? 0, 2) }}</td>
                        <td class="px-4 py-3 text-right">$ {{ number_format($totales['utilidad'] ?? 0, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
