<div>
    {{-- Título --}}
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Costo-Utilidad</h1>
    </div>

    {{-- Filtros --}}
    <div class="bg-white rounded-lg shadow-sm border p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            {{-- Fecha inicio --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Fecha inicio:</label>
                <input type="date" wire:model.live="fechainicio"
                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            {{-- Fecha fin --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Fecha fin:</label>
                <input type="date" wire:model.live="fechafinal"
                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            {{-- Sucursal --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Sucursal</label>
                <select wire:model.live="sucursal"
                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Todas las Sucursales</option>
                    @foreach ($sucursales as $suc)
                        <option value="{{ $suc->idbranchoffice }}">{{ $suc->razon_social }}</option>
                    @endforeach
                </select>
            </div>

            {{-- Número de filas --}}
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Número de filas:</label>
                <select wire:model.live="filas"
                    class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                    <option value="500">500</option>
                </select>
            </div>
        </div>

        {{-- Botones --}}
        <div class="mt-4 flex gap-2">
            <button class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                <i class="fas fa-search mr-2"></i>Consulta
            </button>
            <button class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500">
                <i class="fas fa-file-export mr-2"></i>Exportar
            </button>
        </div>
    </div>

    {{-- Totales --}}
    <div class="bg-white rounded-lg shadow-sm border p-6 mb-6">
        <h2 class="text-lg font-semibold mb-4">Opción:</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="bg-gray-50 p-4 rounded-lg">
                <label class="block text-sm font-medium text-gray-700 mb-1">Venta total:</label>
                <div class="text-xl font-semibold text-gray-900">
                    ${{ number_format($ventaTotal, 2) }}
                </div>
            </div>

            <div class="bg-gray-50 p-4 rounded-lg">
                <label class="block text-sm font-medium text-gray-700 mb-1">Costo total:</label>
                <div class="text-xl font-semibold text-gray-900">
                    ${{ number_format($costoTotal, 2) }}
                </div>
            </div>

            <div class="bg-gray-50 p-4 rounded-lg">
                <label class="block text-sm font-medium text-gray-700 mb-1">Utilidad total:</label>
                <div class="text-xl font-semibold text-gray-900">
                    ${{ number_format($utilidadTotal, 2) }}
                </div>
            </div>
        </div>
    </div>

    {{-- Tabla de resultados --}}
    <div class="bg-white rounded-lg shadow-sm border overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">Folio</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">Fecha venta</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">Hora venta</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-700 uppercase tracking-wider">Costo total</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-700 uppercase tracking-wider">Venta total</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-700 uppercase tracking-wider">Utilidad total</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-700 uppercase tracking-wider">Sucursal</th>
                        <th class="px-4 py-3 text-center text-xs font-medium text-gray-700 uppercase tracking-wider">Opciones</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($ventas as $venta)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 text-sm">{{ $venta->folio }}</td>
                            <td class="px-4 py-3 text-sm">{{ \Carbon\Carbon::parse($venta->fechaventa)->format('d-m-Y') }}</td>
                            <td class="px-4 py-3 text-sm">{{ $venta->horaventa }}</td>
                            <td class="px-4 py-3 text-sm text-right">${{ number_format($venta->costo_total, 2) }}</td>
                            <td class="px-4 py-3 text-sm text-right">${{ number_format($venta->venta_total, 2) }}</td>
                            <td class="px-4 py-3 text-sm text-right">${{ number_format($venta->utilidad_total, 2) }}</td>
                            <td class="px-4 py-3 text-sm">{{ $venta->sucursal }}</td>
                            <td class="px-4 py-3 text-center">
                                <button class="px-3 py-1 bg-blue-600 text-white text-sm rounded hover:bg-blue-700">
                                    Detalles
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-4 py-8 text-center text-gray-500">
                                No se encontraron ventas para los filtros seleccionados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
