<div>
    <flux:heading size="xl">Datos del Inventario</flux:heading>
    <flux:separator></flux:separator>
</div>
<div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
    <flux:field>
        <flux:label>Fecha</flux:label>
        <flux:input wire:model="fechaTraspaso" type="date" max="2999-12-31" size="sm" />
        <flux:error name="fecha_traspaso" />
    </flux:field>
    
    <flux:field>
        <flux:label>Concepto</flux:label>
        <flux:select wire:model="selectedConceptoId" placeholder="Selecciona un concepto" size="sm">
            @foreach ($conceptos ?? [] as $concepto)
                <flux:select.option value="{{ $concepto->idinventoryconcept }}">
                    {{ $concepto->conceptoinventario }}
                </flux:select.option>
            @endforeach
        </flux:select>
        <flux:error name="concepto_id" />
    </flux:field>

    <flux:field id="{{ rand() }}">
        <flux:label>Sucursal origen:</flux:label>
        <flux:tooltip toggleable>
            <flux:input.group>
                <flux:input value="{{ $selectedSucursalOrigen->sucursal->razon_social ?? '' }}" readonly size="sm"
                    placeholder="Busca una sucursal" />
                <flux:modal.trigger name="{{ count($partidasActuales ?? []) === 0 ? 'sucursal-origen-modal' : '' }}">
                    <flux:button size="sm" icon="magnifying-glass" />
                </flux:modal.trigger>
            </flux:input.group>
            @if (count($partidasActuales ?? []) > 0)
                <flux:tooltip.content id="sucursal-origen-tooltip" class="max-w-[20rem] space-y-2">
                    <p>
                        Es necesario limpiar las partidas actuales antes de cambiar de sucursal origen.
                    </p>
                </flux:tooltip.content>
            @endif
        </flux:tooltip>
        <flux:error name="sucursal_origen_id" />
    </flux:field>

    <flux:field id="{{ rand() }}">
        <flux:label>Sucursal destino:</flux:label>
        <flux:tooltip toggleable>
            <flux:input.group>
                <flux:input value="{{ $selectedSucursalDestino->sucursal->razon_social ?? '' }}" readonly size="sm"
                    placeholder="Busca una sucursal" />
                <flux:modal.trigger name="{{ count($partidasActuales ?? []) === 0 ? 'sucursal-destino-modal' : '' }}">
                    <flux:button size="sm" icon="magnifying-glass" />
                </flux:modal.trigger>
            </flux:input.group>
            @if (count($partidasActuales ?? []) > 0)
                <flux:tooltip.content id="sucursal-destino-tooltip" class="max-w-[20rem] space-y-2">
                    <p>
                        Es necesario limpiar las partidas actuales antes de cambiar de sucursal destino.
                    </p>
                </flux:tooltip.content>
            @endif
        </flux:tooltip>
        <flux:error name="sucursal_destino_id" />
    </flux:field>

    <flux:field>
        <flux:label>Proveedor</flux:label>
        <flux:input.group>
            <flux:input value="{{ $selectedProveedor->nombre ?? '' }}" readonly size="sm"
                placeholder="Busca un proveedor" />
            <flux:modal.trigger name="proveedor-modal">
                <flux:button size="sm" icon="magnifying-glass" />
            </flux:modal.trigger>
        </flux:input.group>
        <flux:error name="proveedor_id" />
    </flux:field>
</div>
