<flux:modal name="sucursal-destino-modal" class="w-screen sm:!max-w-[75vw] !max-w-[95vw] !p-2 sm:!p-6" wire:close="resetModal()">
    <div class="space-y-2 sm:space-y-6">
        <div>
            <flux:heading size="lg">Buscar Sucursal Destino</flux:heading>
            <flux:text class="mt-2">Ingresa la clave o descripción de la sucursal destino.</flux:text>
        </div>
        <flux:input size="sm" wire:model.live.debounce.500ms="search.sucursalDestino" type="text" placeholder="Buscar..." />
        @if ($warehousesDestino !== [])
            <x-generic-table x-data="{ selectedIndex: null }" header="Sucursales" overflowY="max-h-48 md:max-h-84" :headerValues="['Nombre Comercial', 'Dirección Fiscal']">
                @slot('body')
                    @foreach ($warehousesDestino as $warehouse)
                        <tr wire:click="$set('searchWarehouseDestinoId', {{ $warehouse->idwarehouse }})"
                            class="hover:cursor-pointer {{ $searchWarehouseDestinoId && $searchWarehouseDestinoId === $warehouse->idwarehouse ? 'bg-gray-200' : '' }}"
                            wire:key="{{ rand() }}">
                            <x-generic-table.cell>{{ $warehouse->sucursal->razon_social }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $warehouse->sucursal->direccion_fiscal }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>
        @endif
        <div class="flex">
            <flux:spacer />
            <flux:button wire:click="saveSelectedSucursalDestino" type="submit" variant="primary">Seleccionar
            </flux:button>
        </div>
    </div>
</flux:modal>
