<flux:modal name="proveedor-modal" class="w-screen sm:!max-w-[75vw] !max-w-[95vw] !p-2 sm:!p-6" wire:close="resetModal()">
    <div class="space-y-2 sm:space-y-6">
        <div>
            <flux:heading size="lg">Buscar Proveedor</flux:heading>
            <flux:text class="mt-2">Ingresa el nombre del proveedor.</flux:text>
        </div>
        <flux:input size="sm" wire:model.live.debounce.500ms="search.proveedor" type="text"
            placeholder="Buscar..." />
        @if ($proveedores !== [])
            <x-generic-table header="Lista de Proveedores" overflowY="max-h-48 md:max-h-84" :headerValues="['Razón Social']">
                @slot('body')
                    @foreach ($proveedores as $proveedor)
                        <tr wire:click="$set('searchProveedorId', {{ $proveedor->idprovider }})"
                            class="hover:cursor-pointer {{ $searchProveedorId && $searchProveedorId === $proveedor->idprovider ? 'bg-gray-200' : '' }}"
                            wire:key="{{ rand() }}">
                            <x-generic-table.cell>{{ $proveedor->nombre }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>

            <div class="overflow-x-auto">
                {{ $proveedores->links() }}
            </div>
        @endif
        <div class="flex">
            <flux:spacer />
            <flux:button wire:click="saveSelectedProveedor" type="submit" variant="primary">Seleccionar
            </flux:button>
        </div>
    </div>
</flux:modal>
