<flux:modal name="producto-modal" class="w-screen sm:!max-w-[75vw] !max-w-[95vw] !p-2 sm:!p-6" wire:close="resetModal()">
    <div class="space-y-2 sm:space-y-6">
        <div>
            <flux:heading size="lg">Buscar Producto</flux:heading>
            <flux:text class="mt-2">Ingresa la clave, descripción o código de barras del producto.</flux:text>
        </div>
        <flux:input size="sm" wire:model.live.debounce.500ms="search.producto" type="text"
            placeholder="Buscar..." />
        @if ($productos !== [])
            <x-generic-table header="Productos" overflowY="max-h-48 md:max-h-84" :headerValues="['Clave', 'Cod. Barras', 'Descripción', 'Costo compra', 'Existencia', 'Prod. Compuesto']">
                @slot('body')
                    @foreach ($productos as $producto)
                        <tr wire:click="$set('searchProductoId', {{ $producto->idproduct }})"
                            class="hover:cursor-pointer {{ $searchProductoId && $searchProductoId === $producto->idproduct ? 'bg-gray-200' : '' }}"
                            wire:key="{{ rand() }}">
                            <x-generic-table.cell>{{ $producto->clave }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $producto->codigo_barras }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $producto->descripcion }}</x-generic-table.cell>
                            <x-generic-table.cell>${{ number_format($producto->costo_compra, 2) }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $producto->existencia }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $producto->prod_compuesto ? 'Sí' : 'No' }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>

            <div class="overflow-x-auto">
                {{ $productos->links() }}
            </div>
        @endif
        <div class="flex">
            <flux:spacer />
            <flux:button wire:click="saveSelectedProducto" type="submit" variant="primary">Seleccionar
            </flux:button>
        </div>
    </div>
</flux:modal>
