@php
    use App\Enums\ActionOption;
@endphp
<div>
    <x-sticky-scroll-box>
        @slot('header')
            <div class="flex justify-between items-center py-2 px-1 bg-blue-100">
                <div class="flex gap-4 items-center">
                    <flux:button class="!hidden sm:!flex" icon="chevron-left" variant="subtle" x-on:click="history.back();">
                        Regresar
                    </flux:button>
                </div>

                <div class="flex gap-4 items-center">
                    <flux:button variant="subtle" wire:click="clearPartidas">
                        Limpiar
                    </flux:button>
                    <x-button-primary wire:click="finalizePartidas">
                        Finalizar
                    </x-button-primary>
                </div>
            </div>
        @endslot
        <div class="flex flex-col gap-4 p-1" x-data="{ selectedPartidaIndex: null }">
            @include('livewire.inventarios.traspasos.partials.traspaso-general-info')

            @include('livewire.inventarios.traspasos.partials.producto-traspasar')

            <x-generic-table :headerValues="['Cantidad', 'Clave Prod.', 'Descripción', 'Precio sin impuestos', 'Importe']">
                @slot('header')
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
                        <div class="col-span-1 sm:col-span-2 flex flex-row gap-4">
                            <span>Partidas totales: {{ count($partidasActuales ?? []) }}</span>
                            <span>Límite: 300</span>
                            <flux:button size="sm" variant="ghost" disabled>
                                Importar partidas
                            </flux:button>
                        </div>
                        <flux:field class="col-span-1 md:col-span-1">
                            <flux:input.group>
                                <flux:input.group.prefix>Importe total: $</flux:input.group.prefix>
                                <flux:input size="sm" wire:model="importeTotal" readonly variant="filled" />
                            </flux:input.group>
                            <flux:error name="importeTotal" />
                        </flux:field>
                    </div>
                @endslot

                @slot('body')
                    @if (count($partidasActuales ?? []) === 0)
                        <tr>
                            <x-generic-table.cell colspan="5">
                                No hay partidas agregadas.
                            </x-generic-table.cell>
                        </tr>
                    @else
                        @foreach ($partidasActuales as $partida)
                            <tr :class="selectedPartidaIndex === {{ $loop->index }} ? 'bg-blue-100' : ''"
                                @click="selectedPartidaIndex = {{ $loop->index }}">
                                <x-generic-table.cell>{{ $partida['cantidad'] }}</x-generic-table.cell>
                                <x-generic-table.cell>{{ $partida['producto']->clave }}</x-generic-table.cell>
                                <x-generic-table.cell>{{ $partida['producto']->descripcion }}</x-generic-table.cell>
                                <x-generic-table.cell>${{ number_format($partida['precio'], 2) }}</x-generic-table.cell>
                                <x-generic-table.cell>${{ number_format($partida['importe'], 2) }}</x-generic-table.cell>
                            </tr>
                        @endforeach
                    @endif
                @endslot
            </x-generic-table>
        </div>
    </x-sticky-scroll-box>
    {{-- Modals --}}
    @include('livewire.inventarios.traspasos.partials.modal-sucursal-origen')
    @include('livewire.inventarios.traspasos.partials.modal-sucursal-destino')
    @include('livewire.inventarios.traspasos.partials.modal-producto')
    @include('livewire.inventarios.traspasos.partials.modal-proveedor')

</div>
