@php
    use App\Enums\ActionOption;
    $currentAction = ActionOption::fromLabel($movOption);
    if (!$currentAction) {
        $currentAction = ActionOption::ENTRADA;
    }
    $headerBgClass = $currentAction === ActionOption::ENTRADA ? 'bg-green-100' : 'bg-red-100';

@endphp
<div>
    <x-sticky-scroll-box>
        @slot('header')
            <div class="flex justify-between items-center py-2 px-1 {{ $headerBgClass }}">
                <div class="flex gap-4 items-center">
                    <flux:button class="!hidden sm:!flex" icon="chevron-left" variant="subtle" x-on:click="history.back();">
                        Regresar
                    </flux:button>

                    <flux:input.group>
                        <flux:input.group.prefix class="!bg-gray-100">Movimiento:</flux:input.group.prefix>
                        <flux:select size="sm" wire:model.live="movOption">
                            <flux:select.option value="entrada">
                                Entrada
                            </flux:select.option>
                            <flux:select.option value="salida">
                                Salida
                            </flux:select.option>
                        </flux:select>
                    </flux:input.group>
                </div>

                <div class="flex gap-4 items-center">
                    <flux:button variant="subtle" wire:click="clearPartidas">
                        Limpiar
                    </flux:button>
                    <x-button-primary wire:click="finalizePartidas">
                        Finalizar entrada
                    </x-button-primary>
                </div>
            </div>
        @endslot
        <div class="flex flex-col gap-4 p-1" x-data="{ selectedPartidaIndex: null }">
            @include('livewire.inventarios.movimientos.partials.movimiento-general-info')

            @include('livewire.inventarios.movimientos.partials.producto-inventariar')

            <x-generic-table :headerValues="['Cantidad', 'Clave Prod.', 'Descripción', 'Precio', 'Importe']">
                @slot('header')
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
                        <div class="col-span-1 sm:col-span-2 flex flex-row  gap-4">
                            <span>Partidas totales: {{ count($partidasActuales) }}</span>
                            <span>Límite: 100</span>
                        </div>
                        <flux:field class="col-span-1 md:col-span-1">
                            <flux:input.group>
                                <flux:input.group.prefix>Importe total: $</flux:input.group.prefix>
                                <flux:input size="sm" wire:model="importeTotal" />
                            </flux:input.group>
                            <flux:error name="importeTotal" />
                        </flux:field>
                    </div>
                @endslot

                @slot('body')
                    @if (count($partidasActuales) === 0)
                        <tr>
                            <x-generic-table.cell colspan="5">
                                No hay partidas agregadas.
                            </x-generic-table.cell>
                        </tr>
                    @else
                        @foreach ($partidasActuales as $partida)
                            <tr :class="selectedPartidaIndex === {{ $loop->index }} ? 'bg-blue-100' : ''"
                                @click="selectedPartidaIndex = {{ $loop->index }}">
                                <x-generic-table.cell>{{ $partida['cantidad'] }}</x-generic-table.cell>
                                <x-generic-table.cell>{{ $partida['producto']->clave }}</x-generic-table.cell>
                                <x-generic-table.cell>{{ $partida['producto']->descripcion }}</x-generic-table.cell>
                                <x-generic-table.cell>{{ $partida['precio'] }}</x-generic-table.cell>
                                <x-generic-table.cell>{{ $partida['importe'] }}</x-generic-table.cell>
                            </tr>
                        @endforeach
                    @endif
                @endslot
            </x-generic-table>
        </div>
    </x-sticky-scroll-box>
    {{-- Modals --}}
    @include('livewire.inventarios.movimientos.partials.modal-sucursal')
    @include('livewire.inventarios.movimientos.partials.modal-producto')
    @include('livewire.inventarios.movimientos.partials.modal-proveedor')

</div>
