<div class="w-full px-6 py-4 space-y-6" x-data>
    <div class="flex items-center justify-between flex-wrap gap-4">
        <h1 class="text-xl font-semibold tracking-tight">Establecer precios y costos</h1>
        <div class="flex flex-wrap gap-2 text-xs">
            <span wire:click="cambiarFamiliaSeleccionados" x-data x-init="const btn=$el.firstElementChild; if(btn){btn.addEventListener('click', (e)=>{e.preventDefault(); e.stopPropagation(); $wire.cambiarFamiliaSeleccionados();});}">
                <flux:button size="sm" variant="ghost">Cambiar familia</flux:button>
            </span>
            <span wire:click="cambiarMarcaSeleccionados" x-data x-init="const btn=$el.firstElementChild; if(btn){btn.addEventListener('click', (e)=>{e.preventDefault(); e.stopPropagation(); $wire.cambiarMarcaSeleccionados();});}">
                <flux:button size="sm" variant="ghost">Cambiar marca</flux:button>
            </span>
            <span wire:click="restaurarTodos" x-data x-init="const btn=$el.firstElementChild; if(btn){btn.addEventListener('click', (e)=>{e.preventDefault(); e.stopPropagation(); $wire.restaurarTodos();});}">
                <flux:button size="sm" variant="ghost">Restaurar todos</flux:button>
            </span>
            <x-button-primary type="button" wire:click="guardarCambios">Guardar cambios</x-button-primary>
        </div>
    </div>

    {{-- Filtros --}}
    <div class="bg-white rounded p-4">
        <div class="grid grid-cols-2 md:grid-cols-4 xl:grid-cols-8 gap-4 text-xs">
            <div class="flex flex-col gap-1">
                <label for="fechainicial" class="block text-sm font-medium text-gray-900">Fecha inicial ventas
                    (*)</label>
                <input type="date" wire:model.live="fechaInicialVentas" wire:change="filtroChanged" class="rounded border p-1 text-xs" />
            </div>
            <div class="flex flex-col gap-1">
                <label for="fechafinal" class="block text-sm font-medium text-gray-900">Fecha final ventas (*)</label>
                <input type="date" wire:model.live="fechaFinalVentas" wire:change="filtroChanged" class="rounded border p-1 text-xs" />
            </div>
            <div class="flex flex-col gap-1 col-span-2 md:col-span-2">
                <label for="filtroSucursal" class="block text-sm font-medium text-gray-900">Sucursal</label>
                <select id="filtroSucursal" wire:model.live.number="sucursalId" wire:change="filtroChanged" class="rounded border p-1 text-xs">
                    <option value="">Cualquier sucursal</option>
                    @foreach ($sucursales ?? [] as $s)
                        <option value="{{ $s->id }}">
                            {{ $s->nombre ?? ($s->descripcion ?? ($s->razon_social ?? 'Sucursal ' . $s->id)) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex flex-col gap-1">
                <label for="filtroMarca" class="block text-sm font-medium text-gray-900">Marca</label>
                <select id="filtroMarca" wire:model.live.number="marcaId" wire:change="filtroChanged" class="rounded border p-1 text-xs">
                    <option value="">Todas las marcas</option>
                    @foreach ($marcas ?? [] as $m)
                        <option value="{{ $m->id }}">
                            {{ $m->nombre ?? ($m->descripcion ?? ($m->NOMBRE ?? 'Marca ' . $m->id)) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex flex-col gap-1">
                <label for="filtroFamilia" class="block text-sm font-medium text-gray-900">Familia</label>
                <select id="filtroFamilia" wire:model.live.number="familiaId" wire:change="filtroChanged" class="rounded border p-1 text-xs">
                    <option value="">Todas las familias</option>
                    @foreach ($familias ?? [] as $f)
                        <option value="{{ $f->id }}">
                            {{ $f->nombre ?? ($f->descripcion ?? ($f->NOMBRE ?? 'Familia ' . $f->id)) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex flex-col gap-1">
                <label for="filtroFilas" class="block text-sm font-medium text-gray-900">Filas</label>
                <input id="filtroFilas" type="number" min="1" wire:model.live.debounce.300ms.number="filas" wire:change="filtroChanged" placeholder="10"
                    class="rounded border p-1 text-xs" />
            </div>
            <div class="flex flex-col gap-1">
                <label for="filtroExistencia" class="block text-sm font-medium text-gray-900">Existencias</label>
                <select id="filtroExistencia" wire:model.live="existenciaFiltro" wire:change="filtroChanged" class="rounded border p-1 text-xs">
                    @foreach ($existenciasOptions ?? ['Todos' => 'Todos'] as $val => $txt)
                        <option value="{{ $val }}">{{ $txt }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex flex-col justify-end">
                <x-button-primary type="button" wire:click="guardarCambios">Guardar cambios</x-button-primary>
            </div>
            <div class="col-span-full pt-2 flex flex-wrap gap-6">
                <label class="inline-flex items-center gap-2">
                    <input type="checkbox" wire:model.live="filtrarSinFechas" wire:change="filtroChanged" class="rounded border" />
                    <label for="ignorarfecha" class="block text-sm font-medium text-gray-900">Ignorar fechas</label>
                </label>
                <label class="inline-flex items-center gap-2">
                    <input type="checkbox" wire:model.live="soloVendidos" wire:change="filtroChanged" class="rounded border" />
                    <label for="solovendidos" class="block text-sm font-medium text-gray-900">Solo vendidos
                    </label>
                    <label class="inline-flex items-center gap-2">
                        <input type="checkbox" wire:model.live="incluirInactivos" wire:change="filtroChanged" class="rounded border" />
                        <label for="incluirInactivos" class="block text-sm font-medium text-gray-900">Incluir
                            inactivos</label>
                    </label>
            </div>
        </div>
    </div>

    <div class="flex flex-wrap items-center gap-8 text-xs">
        <label class="inline-flex items-center gap-2 text-sm font-medium text-gray-900">
            <input id="selectAll" type="checkbox" wire:click="toggleSeleccionTodos" class="rounded border" />
            <span class="text-sm font-medium text-gray-900">Seleccionar todos</span>
        </label>
        <label class="inline-flex items-center gap-2 text-sm font-medium text-gray-900">
            <input id="activarTodos" type="checkbox" wire:click="toggleActivoSeleccionados" class="rounded border" />
            <span class="text-sm font-medium text-gray-900">Activar/Desactivar todos</span>
        </label>
    <span class="font-medium">Mostrando: {{ $productos->count() }} elementos</span>
    </div>

    @php
        $headerValues = [
            '',
            'Descripción',
            'Clave',
            'Código barras',
            'Stock mínimo',
            'Costo compra',
            'Precio venta',
            'Existencia',
            'Ventas',
            'Familia',
            'Marca',
            'Activo',
            '',
        ];
    @endphp
    @php
        // Mapas id->nombre para reflejar cambios en tiempo real desde edits.*
        $familiaMap = collect($familias ?? [])->mapWithKeys(function ($f) {
            $id = is_array($f) ? ($f['id'] ?? null) : ($f->id ?? null);
            if ($id === null) return [];
            $nombre = is_array($f)
                ? ($f['nombre'] ?? ($f['descripcion'] ?? ($f['NOMBRE'] ?? ('Familia ' . $id))))
                : ($f->nombre ?? ($f->descripcion ?? ($f->NOMBRE ?? ('Familia ' . $id))));
            return [$id => $nombre];
        })->all();
        $marcaMap = collect($marcas ?? [])->mapWithKeys(function ($m) {
            $id = is_array($m) ? ($m['id'] ?? null) : ($m->id ?? null);
            if ($id === null) return [];
            $nombre = is_array($m)
                ? ($m['nombre'] ?? ($m['descripcion'] ?? ($m['NOMBRE'] ?? ('Marca ' . $id))))
                : ($m->nombre ?? ($m->descripcion ?? ($m->NOMBRE ?? ('Marca ' . $id))));
            return [$id => $nombre];
        })->all();
    @endphp
    <div wire:key="tabla-{{ $refreshKey }}">
    <x-generic-table :headerValues="$headerValues" header="Listado de productos">
        @slot('headerAction')
        @endslot
        @slot('body')
            @forelse($productos ?? [] as $p)
                @php $pid = $p->id; @endphp
                <tr wire:key="prod-{{ $pid }}"
                    class="@if ($edits[$pid]['_dirty'] ?? false) bg-amber-50 @endif hover:bg-gray-50">
                    <x-generic-table.cell class="!px-2 text-center">
                        <input type="checkbox" value="{{ $pid }}" wire:model="seleccion"
                            class="rounded border" />
                    </x-generic-table.cell>
                    <x-generic-table.cell
                        class="!whitespace-normal">{{ $p->descripcion ?? ($p->DESCRIPCION ?? '—') }}</x-generic-table.cell>
                    <x-generic-table.cell class="!px-2">
                        <input type="text" wire:model.lazy="edits.{{ $pid }}.clave"
                            class="w-full border rounded p-1 text-xs" />
                    </x-generic-table.cell>
                    <x-generic-table.cell class="!px-2">
                        <input type="text" wire:model.lazy="edits.{{ $pid }}.codigo_barras"
                            class="w-full border rounded p-1 text-xs" />
                    </x-generic-table.cell>
                    <x-generic-table.cell class="!px-2">
                        <input type="number" step="0.001" wire:model.lazy="edits.{{ $pid }}.stock_minimo"
                            class="w-full border rounded p-1 text-right text-xs" />
                    </x-generic-table.cell>
                    <x-generic-table.cell class="!px-2">
                        <input type="number" step="0.01" wire:model.lazy="edits.{{ $pid }}.costo_compra"
                            class="w-full border rounded p-1 text-right text-xs" />
                    </x-generic-table.cell>
                    <x-generic-table.cell class="!px-2">
                        <input type="number" step="0.01" wire:model.lazy="edits.{{ $pid }}.precio_venta"
                            class="w-full border rounded p-1 text-right text-xs" />
                    </x-generic-table.cell>
                    <x-generic-table.cell
                        class="text-right">{{ number_format($p->existencia ?? 0, 3) }}</x-generic-table.cell>
                    <x-generic-table.cell
                        class="text-right">{{ number_format($p->ventas ?? 0, 3) }}</x-generic-table.cell>
                    <x-generic-table.cell>
                        {{ $familiaMap[$edits[$pid]['familia_aplicada'] ?? ($p->idfamilia ?? null)]
                            ?? ($p->familia_nombre ?? ($p->familia ?? '—')) }}
                    </x-generic-table.cell>
                    <x-generic-table.cell>
                        {{ $marcaMap[$edits[$pid]['marca_aplicada'] ?? ($p->idmarca ?? null)]
                            ?? ($p->marca_nombre ?? ($p->marca ?? 'SINMARCA')) }}
                    </x-generic-table.cell>
                    <x-generic-table.cell class="text-center">
                        <input type="checkbox" wire:model="edits.{{ $pid }}.activo"
                            @checked($p->activo) />
                    </x-generic-table.cell>
                    <x-generic-table.cell class="text-center !px-2">
                        @if ($edits[$pid]['_dirty'] ?? false)
                            <span class="inline-block w-2.5 h-2.5 rounded-full bg-amber-500" title="Modificado"></span>
                        @endif
                    </x-generic-table.cell>
                </tr>
            @empty
                <tr>
                    <x-generic-table.cell colspan="13" class="text-center">Sin resultados</x-generic-table.cell>
                </tr>
            @endforelse
        @endslot
    </x-generic-table>

    {{-- Panels de totales (venta / compra) --}}
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6" wire:key="totales-{{ $refreshKey }}">
        <div class="bg-white rounded p-4">
            <h3 class="font-semibold mb-3">Importes totales a precio <strong>venta (público)</strong></h3>
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left">
                        <th></th>
                        <th class="text-right">Stock mínimo</th>
                        <th class="text-right">Existencia</th>
                        <th class="text-right">Ventas</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="font-medium">Importe total:</td>
                        <td class="text-right">{{ number_format($totals['venta']['stockmin_total'] ?? 0, 2) }}</td>
                        <td class="text-right">{{ number_format($totals['venta']['existencia_total'] ?? 0, 2) }}</td>
                        <td class="text-right">{{ number_format($totals['venta']['ventas_total'] ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td class="font-medium">Stock mínimo - Existencia:</td>
                        <td class="text-right text-green-600 font-semibold" colspan="3">
                            {{ number_format(($totals['venta']['stockmin_total'] ?? 0) - ($totals['venta']['existencia_total'] ?? 0), 2) }}
                        </td>
                    </tr>
                </tbody>
            </table>

            <div class="mt-4">
                <div class="block font-medium">Utilidad:</div>
                <div class="mt-1 p-2 bg-gray-100 text-right font-semibold">
                    {{ number_format(($totals['venta']['existencia_total'] ?? 0) + ($totals['venta']['ventas_total'] ?? 0) - (($totals['compra']['existencia_total'] ?? 0) + ($totals['compra']['ventas_total'] ?? 0)), 2) }}
                </div>
            </div>

            <div class="mt-3">
                <div class="block font-medium">Pérdida ((Existencia + Venta) - Stock mínimo ):</div>
                <div class="mt-1 p-2 bg-gray-100 text-right font-semibold">
                    {{ number_format($totals['perdida_compra'] ?? 0, 2) }}</div>
            </div>
        </div>

        <div class="bg-white rounded p-4">
            <h3 class="font-semibold mb-3">Importes totales a precio <strong>compra</strong></h3>
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left">
                        <th></th>
                        <th class="text-right">Stock mínimo</th>
                        <th class="text-right">Existencia</th>
                        <th class="text-right">Ventas</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="font-medium">Importe total:</td>
                        <td class="text-right">{{ number_format($totals['compra']['stockmin_total'] ?? 0, 2) }}</td>
                        <td class="text-right">{{ number_format($totals['compra']['existencia_total'] ?? 0, 2) }}</td>
                        <td class="text-right">{{ number_format($totals['compra']['ventas_total'] ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <td class="font-medium">Stock mínimo - Existencia:</td>
                        <td class="text-right text-green-600 font-semibold" colspan="3">
                            {{ number_format(($totals['compra']['stockmin_total'] ?? 0) - ($totals['compra']['existencia_total'] ?? 0), 2) }}
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    </div>

    {{ $productos->links() }}

    @if (session()->has('message'))
        <div class="mt-3 text-sm px-3 py-2 rounded bg-emerald-100 text-emerald-800">{{ session('message') }}</div>
    @endif
    @if (session()->has('error'))
        <div class="mt-3 text-sm px-3 py-2 rounded bg-rose-100 text-rose-800">{{ session('error') }}</div>
    @endif

    {{-- Modal cambiar familia --}}
    @if ($mostrarModalFamilia)
        <div class="fixed inset-0 z-50 flex items-center justify-center">
            <div class="absolute inset-0 bg-black/40" wire:click="cerrarModales"></div>
            <div class="relative bg-white rounded shadow-lg w-full max-w-md mx-3 p-4 space-y-4">
                <h3 class="text-base font-semibold">Cambiar familia a seleccionados</h3>
                <div>
                    <label for="modalFamiliaDestino" class="block text-sm font-medium mb-1">Familia destino</label>
                    <select id="modalFamiliaDestino" class="w-full rounded border p-2 text-sm" wire:model.live.number="familiaCambioId">
                        <option value="">Selecciona una familia…</option>
                        @foreach ($familias ?? [] as $f)
                            <option value="{{ $f->id }}">{{ $f->nombre ?? ($f->descripcion ?? ($f->NOMBRE ?? 'Familia ' . $f->id)) }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="flex justify-end gap-2 pt-2">
                    <span wire:click="cerrarModales">
                        <flux:button size="sm" variant="ghost">Cancelar</flux:button>
                    </span>
                    <span wire:click="confirmarCambiarFamilia">
                        <x-button-primary type="button">Aplicar</x-button-primary>
                    </span>
                </div>
            </div>
        </div>
    @endif

    {{-- Modal cambiar marca --}}
    @if ($mostrarModalMarca)
        <div class="fixed inset-0 z-50 flex items-center justify-center">
            <div class="absolute inset-0 bg-black/40" wire:click="cerrarModales"></div>
            <div class="relative bg-white rounded shadow-lg w-full max-w-md mx-3 p-4 space-y-4">
                <h3 class="text-base font-semibold">Cambiar marca a seleccionados</h3>
                <div>
                    <label for="modalMarcaDestino" class="block text-sm font-medium mb-1">Marca destino</label>
                    <select id="modalMarcaDestino" class="w-full rounded border p-2 text-sm" wire:model.live.number="marcaCambioId">
                        <option value="">Selecciona una marca…</option>
                        @foreach ($marcas ?? [] as $m)
                            <option value="{{ $m->id }}">{{ $m->nombre ?? ($m->descripcion ?? ($m->NOMBRE ?? 'Marca ' . $m->id)) }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="flex justify-end gap-2 pt-2">
                    <span wire:click="cerrarModales">
                        <flux:button size="sm" variant="ghost">Cancelar</flux:button>
                    </span>
                    <span wire:click="confirmarCambiarMarca">
                        <x-button-primary type="button">Aplicar</x-button-primary>
                    </span>
                </div>
            </div>
        </div>
    @endif
</div>
