<div class="p-4 gap-4">
    <input wire:model.live.debounce.500ms="search" type="text" placeholder="Buscar usuarios por clave o nombre"
        class="rounded-lg border p-2 w-full shadow-md" />
    <x-generic-table header="Listado de usuarios" :headerValues="$headerValues" :showActions="true">
        @slot('headerAction')
            <x-button wire:click="create">Crear nuevo usuario</x-button>
        @endslot

        @slot('body')
            @foreach ($usuarios as $usuario)
                <tr wire:key="usuario-{{$usuario->iduser}}">
                    <x-generic-table.cell>{{ $usuario->iduser }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $usuario->idsucursal }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $usuario->idusuario }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $usuario->usuario }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $usuario->nombre }}</x-generic-table.cell>
                    
                    
                    <x-generic-table.cell>
                        @if ($usuario->idperfil === 1001 || $usuario->idperfil === 2001)
                        <flux:button wire:click="edit({{ $usuario->iduser }})" disabled>Editar</flux:button>
                        <flux:button wire:click="confirmdelete({{ $usuario->iduser }})" variant="danger" disabled>
                            Eliminar
                        </flux:button>
                        @else
                        <flux:button wire:click="edit({{ $usuario->iduser }})">Editar</flux:button>
                        <flux:button wire:click="confirmdelete({{ $usuario->iduser }})" variant="danger">
                            Eliminar
                        </flux:button>
                        @endif
                    </x-generic-table.cell>
                </tr>
            @endforeach
        @endslot
    </x-generic-table>

    <div>
        {{ $usuarios->links() }}
    </div>
    <x-confirm-delete/>
</div>
