<div class="p-4 gap-4">
    <input wire:model.live.debounce.500ms="search" type="text" placeholder="Busca provedores" class="rounded-lg border p-2 w-full shadow-md"/>

    <!-- Tabla -->
    <x-generic-table header="Listado de proveedores" :headerValues="$headerValues" :rowsValues="$rowsValues" :showActions="true" >
        @slot('headerAction')
            <x-button wire:click="create">Crear nuevo proveedor</x-button>
        @endslot

        @slot('body')
            @foreach ($proveedores as $proveedor)
                <tr wire:key="proveedor-{{ $proveedor->idprovider }}">
                    <x-generic-table.cell>{{ $proveedor->idempresa }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $proveedor->idprovider }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $proveedor->clave }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $proveedor->nombrecorto}}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $proveedor->nombrecomercial }}</x-generic-table.cell>

                    <x-generic-table.cell>
                        <flux:button wire:key="button-{{$proveedor->idprovider}}" wire:click="edit({{ $proveedor->idprovider }})">Editar</flux:button>
                        <flux:button wire:click="delete( {{ $proveedor->idprovider }})"
                            wire:confirm="¿Estas seguro que quieres eliminar el proveedor '{{ $proveedor->nombreproveedor }}'?"
                            variant="danger"> Eliminar </flux:button>
                    </x-generic-table.cell>
                </tr>
            @endforeach
        @endslot
    </x-generic-table>

    <!-- Paginación -->
    <div>
        {{ $proveedores->links() }}
    </div>
</div>
