<div class="w-4/5 mx-auto my-4">
    <form wire:submit.prevent="save" class="flex flex-col">
        <x-sticky-scroll-box class="space-y-8">
            @slot('header')
                <div class="flex items-center justify-between w-full">
                    <div class="flex border-b border-gray-200">
                        <button type="button" wire:click="$set('activeTab', 'general')"
                            class="px-4 py-2 text-sm font-medium text-gray-700 border-b-2 focus:outline-none {{ $activeTab === 'general' ? 'border-indigo-500 text-indigo-600' : 'border-transparent hover:text-gray-800 hover:border-gray-300' }}">
                            Información General
                        </button>
                        <button type="button" wire:click="$set('activeTab', 'domicilio')"
                            class="px-4 py-2 text-sm font-medium text-gray-700 border-b-2 focus:outline-none {{ $activeTab === 'domicilio' ? 'border-indigo-500 text-indigo-600' : 'border-transparent hover:text-gray-800 hover:border-gray-300' }}">
                            Domicilio
                        </button>
                    </div>
                    <div class="transition-all flex items-center justify-between">
                        <flux:button variant="subtle" icon="chevron-left" x-on:click="history.back();" >Regresar</flux:button>
                        <div class="flex items-center justify-end gap-x-4">
                            <flux:button variant="ghost" wire:click="clear">
                                Limpiar
                            </flux:button>
            
                            <x-button-primary>Guardar</x-button-primary>
                        </div>
                    </div>        
                </div>
            @endslot

            <div class=" grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-6 p-4">
                <!-- Información General -->
                @if ($activeTab === 'general')
                    <div class="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-6">
                        <div class="sm:col-span-3">
                            <x-input-label id="clave" wire:model="clave" label="Clave (*)" placeholder="Clave" error="clave" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="nombrecorto" wire:model="nombrecorto" label="Nombre Corto" placeholder="Nombre Corto" />
                        </div>
                        <div class="sm:col-span-6">
                            <x-input-label id="nombrecomercial" wire:model="nombrecomercial" label="Nombre Comercial" placeholder="Nombre Comercial" />
                        </div>
                        <div class="sm:col-span-6">
                            <x-input-label id="razonsocial" wire:model="razonsocial" label="Razón Social (*)" placeholder="Razón Social" error="razonsocial" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="rfc" wire:model="rfc" label="RFC (*)" placeholder="RFC" error="rfc" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="curp" wire:model="curp" label="CURP" placeholder="CURP" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="telefono" wire:model="telefono" label="Teléfono" placeholder="Teléfono" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="fax" wire:model="fax" label="Fax" placeholder="Fax" />
                        </div>
                        <div class="sm:col-span-6">
                            <x-input-label id="email" wire:model="email" label="Correo Electrónico" placeholder="Correo Electrónico" error="email" />
                        </div>
                        <div class="sm:col-span-6">
                            <x-input-label id="contacto" wire:model="contacto" label="Contacto" placeholder="Contacto" />
                        </div>  
                        <div class="sm:col-span-3">
                            <x-input-label id="limite_credito" wire:model="limite_credito" label="Límite de Crédito" placeholder="Límite de Crédito" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="dias_credito" wire:model="dias_credito" label="Días de Crédito" placeholder="Días de Crédito" />
                        </div>
                        <div class="sm:col-span-6">
                            <label class="block text-sm font-medium text-gray-900">
                                Tipo de persona
                            </label>
                        </div>
                        <div class="sm:col-span-6 flex items-center">
                            <label class="inline-flex items-center mr-4">
                                <input type="radio" id="tipo_persona_fisica" wire:model="tipo_persona" value="0" class="form-radio h-5 w-5 text-indigo-600" name="tipo_persona">
                                <span class="ml-2 text-sm text-gray-700">Persona Física</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="radio" id="tipo_persona_moral" wire:model="tipo_persona" value="1" class="form-radio h-5 w-5 text-indigo-600" name="tipo_persona">
                                <span class="ml-2 text-sm text-gray-700">Persona Moral</span>
                            </label>
                        </div>
                    </div>
                @endif

                <!-- Domicilio Fiscal -->
                @if ($activeTab === 'domicilio')
                    <div class="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-6">
                        <div class="sm:col-span-6">
                            <x-input-label id="calle" wire:model="calle" label="Calle (*)" placeholder="Calle" error="calle" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="cruzamientos" wire:model="cruzamientos" label="Cruzamientos" placeholder="Cruzamientos" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="no_exterior" wire:model="no_exterior" label="No. Exterior" placeholder="No. Exterior" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="no_interior" wire:model="no_interior" label="No. Interior" placeholder="No. Interior" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="colonia" wire:model="colonia" label="Colonia" placeholder="Colonia" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="localidad" wire:model="localidad" label="Localidad (*)" placeholder="Localidad" error="localidad" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="municipio" wire:model="municipio" label="Municipio (*)" placeholder="Municipio" error="municipio" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="estado" wire:model="estado" label="Estado (*)" placeholder="Estado" error="estado" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="pais" wire:model="pais" label="País (*)" placeholder="País" error="pais" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="cp" wire:model="cp" label="C.P. (*)" placeholder="Código Postal" error="cp" />
                        </div>
                        <div class="sm:col-span-6">
                            <x-textarea-label id="referencia" wire:model="referencia" label="Referencia" placeholder="Referencia" />
                        </div>
                    </div>
                @endif
            </div>
        </x-sticky-scroll-box>
    </form>
</div>
