<flux:modal name="producto-servicio" class="w-screen sm:!max-w-[75vw] !max-w-[95vw] !p-2 sm:!p-6" wire:close="resetModal()">
    <div class="space-y-2 sm:space-y-6">
        <div>
            <flux:heading size="lg">Buscar Producto-Servicio</flux:heading>
            <flux:text class="mt-2">Ingresa la clave o descripción del producto-servicio.</flux:text>
        </div>
        <flux:input size="sm" wire:model.live.debounce.500ms="search.productos_servicios" type="text" placeholder="Buscar..." />
        @if ($productServices !== [])
            <x-generic-table header="Productos Servicios" overflowY="max-h-48 md:max-h-84" :headerValues="['Clave', 'Descripción']">
                @slot('body')
                    @foreach ($productServices as $productService)
                        <tr wire:click="$set('selectedProductService', {{ $productService }})"
                            class="hover:cursor-pointer {{ $selectedProductService && $selectedProductService['clave_prodserv'] === $productService->clave_prodserv ? 'bg-gray-200' : '' }}"
                            wire:key="{{ rand() }}">
                            <x-generic-table.cell>{{ $productService->clave_prodserv }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $productService->descripcion }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>



            <div class="overflow-x-auto">
                {{ $productServices->links() }}
            </div>
        @endif
        <div class="flex">

            <flux:spacer />

            <flux:button wire:click="saveProductService" type="submit" variant="primary">Seleccionar
            </flux:button>
        </div>
    </div>
</flux:modal>
