<div class="sm:col-span-6">
    <x-input-label wire:model="form.stockminimo" type="number" id="stockminimo" label="Stock mínimo" />
    @if ($form['manejainventario'])
        @if (isset($inventarios) && count($inventarios) > 0)
            <x-generic-table header="Listado de almacenes existentes" :headerValues="['Sucursal', 'Existencia actual', 'Diferencia', 'Acción', 'Cantidad ajuste']">
                @slot('body')
                    @foreach ($inventarios as $index => $inventario)
                        @php
                            $diferencia = bcsub($inventario['existencia'], $form['stockminimo'], 3);
                        @endphp
                        <tr>
                            <x-generic-table.cell>{{ $inventario['almacen']['sucursal']['razon_social'] }}</x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input variant="filled" size="sm"
                                    wire:model="inventarios.{{ $index }}.existencia" disabled></flux:input>
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input variant="filled" size="sm"
                                    value="{{ $diferencia }} {{ $diferencia >= 0 ? 'Sobrantes' : 'Faltantes' }}"
                                    disabled />
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:select size="sm" wire:model="inventarios.{{ $index }}.almacen.accion">
                                    <flux:select.option value="ENTRADA">SUMAR</flux:select.option>
                                    <flux:select.option value="SALIDA">RESTAR</flux:select.option>
                                    <flux:select.option value="INICIAL">ESTABLECER</flux:select.option>
                                </flux:select>
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input wire:model="inventarios.{{ $index }}.almacen.cantidadajuste"
                                    size="sm">
                                </flux:input>
                            </x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>
        @else
            <x-generic-table header="Listado de almacenes" :headerValues="['Sucursal', 'Existencia actual', 'Acción', 'Cantidad ajuste']">
                @slot('body')
                    @foreach ($warehouses as $index => $warehouse)
                        <tr>
                            <x-generic-table.cell>{{ $warehouse['sucursal']['razon_social'] }}</x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input variant="filled" size="sm" value="0" disabled></flux:input>
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input variant="filled" size="sm" value="SUMAR" disabled></flux:input>
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input wire:model="warehouses.{{ $index }}.cantidadajuste" size="sm">
                                </flux:input>
                            </x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>
        @endif
    @else
        <div class="mt-6">
            <flux:heading size="lg">No disponible</flux:heading>
            <flux:text class="mt-2">Seleccione la casilla 'Maneja inventarios' para habilitar esta funcionalidad.</flux:text>
        </div>
    @endif
</div>
