<div class="p-4">
    <input wire:model.live.debounce.500ms="search" type="text"
        placeholder="Buscar productos por clave o código de barras" class="rounded-lg border p-2 w-full shadow-md" />
    <x-generic-table :headerValues="$headerValues">
        @slot('header')
            <div class="flex flex-col gap-2 items-start">
                Listado de familias

                <div class="flex flex-row gap-2 items-center">

                    <span class="!font-normal">Familia:</span>
                    <flux:select wire:model.live='filters.family' size="sm">
                        @foreach ($families as $family)
                            <option value="{{ $family['idfamily'] }}">{{ $family['nombrefamilia'] }}</option>
                        @endforeach
                    </flux:select>

                    <span class="!font-normal">Marca:</span>
                    <flux:select wire:model.live='filters.brand' size="sm">
                        @foreach ($brands as $brand)
                            <option value="{{ $brand['idbrand'] }}">{{ $brand['marca'] }}</option>
                        @endforeach
                    </flux:select>

                    <flux:button variant="subtle" class="justify-start" :loading="false" wire:click="clean">Limpiar
                        filtros</flux:button>
                </div>
            </div>
        @endslot
        @slot('headerAction')
            <div class="flex space-x-2">
                <x-button wire:click="create">Crear un nuevo producto</x-button>
                <x-custom-dropdown label="Exportar" align="right">
                    <x-button wire:click.prevent="exportExcel" class="!bg-transparent !border-none !shadow-none !text-gray-700 !font-normal w-full text-left px-4 py-2 hover:bg-gray-100">
                        Exportar a Excel </x-button>
                    <x-button wire:click.prevent="exportPdf" class="!bg-transparent !border-none !shadow-none !text-gray-700 !font-normal w-full text-left px-4 py-2 hover:bg-gray-100">
                        Exportar a PDF </x-button>
                </x-custom-dropdown>
            </div>
        @endslot

        @slot('body')
            @foreach ($productos as $producto)
                <tr wire:key="producto-{{ $producto->idproduct }}">
                    <x-generic-table.cell>{{ $producto->clave }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $producto->codigodebarras }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $producto->descripcion }}</x-generic-table.cell>

                    <x-generic-table.cell>
                        <flux:button wire:click="edit({{ $producto->idproduct }})">Editar</flux:button>
                        <flux:button wire:click="confirmDelete({{ $producto->idproduct }})"
                            variant="danger"> Eliminar </flux:button>
                    </x-generic-table.cell>
                </tr>
            @endforeach
        @endslot
    </x-generic-table>

    {{ $productos->links() }}

    <x-error-alert event="error-delete" text="No es posible eliminar el producto"/>
</div>
