<div class="w-full">

    <form wire:submit.prevet="save" method="post" class="flex flex-col">
        <x-sticky-scroll-box class="space-y-8">
            @slot('header')
                <div class="transition-all flex items-center justify-between gap-x-2 p-4">
                    <x-custom-tab.group model="activeTab" :selected="$activeTab">
                        <x-custom-tab value="general">Información General</x-custom-tab>
                        <x-custom-tab value="precios">Precios</x-custom-tab>
                        <x-custom-tab value="inventarios">Inventarios</x-custom-tab>
                        <x-custom-tab value="notas">Notas</x-custom-tab>
                        @if ($action == 'edit')
                            <x-custom-tab value="h-salidas">Histórico Salidas</x-custom-tab>
                            <x-custom-tab value="h-entradas">Histórico entradas</x-custom-tab>
                        @endif
                    </x-custom-tab.group>

                    <div class="flex flex-col items-center justify-end gap-y-1 md:gap-x-4 md:flex-row">
                        <div class="hidden md:block">
                            <flux:button type="button" variant="subtle" icon="chevron-left" x-on:click="history.back();">
                                Regresar
                            </flux:button>
                        </div>

                        <flux:button type="button" variant="ghost" wire:click="clear">
                            Limpiar
                        </flux:button>

                        <x-button-primary type="submit">Guardar</x-button-primary>
                    </div>
                </div>
            @endslot
            <div class="grid grid-cols-1 gap-8 sm:grid-cols-6 p-4">
                @switch($activeTab)
                    @case('general')
                        @include('livewire.catalogos.productos.partials.general-info')
                    @break

                    @case('precios')
                        @include('livewire.catalogos.productos.partials.precios')
                    @break

                    @case('inventarios')
                        @include('livewire.catalogos.productos.partials.inventarios')
                    @break

                    @case('notas')
                        @include('livewire.catalogos.productos.partials.notas')
                    @break

                    @case('h-salidas')
                        @include('livewire.catalogos.productos.partials.historico-generic', [
                            'action' => 'getHistoricoSalidas',
                            'model' => 'historicoSalida',
                            'items' => $historicoSalidaItems,
                        ])
                    @break

                    @case('h-entradas')
                        @include('livewire.catalogos.productos.partials.historico-generic', [
                            'action' => 'getHistoricoEntradas',
                            'model' => 'historicoEntrada',
                            'items' => $historicoEntradaItems,
                        ])
                    @break

                    @default
                        <h2>Error</h2>
                @endswitch


            </div>

        </x-sticky-scroll-box>
    </form>

    {{-- Modals --}}
    @include('livewire.catalogos.productos.partials.modal-service')
    @include('livewire.catalogos.productos.partials.modal-unidad')
    @include('livewire.catalogos.productos.partials.modal-components')
    @include('livewire.catalogos.productos.partials.modal-search-components')
    @include('livewire.catalogos.productos.partials.modal-barcode')
</div>
