<div class="p-4 gap-4">
    <input wire:model.live.debounce.500ms="search" type="text" placeholder="Buscar Marcas por clave o nombre"
        class="rounded-lg border p-2 w-full shadow-md" />
    <x-generic-table header="Listado de marcas" :headerValues="$headerValues" :showActions="true">
        @slot('headerAction')
            <div class="flex space-x-2">
                <x-button wire:click="create">Crear nueva marca</x-button>
                <x-custom-dropdown label="Exportar" align="right">
                    <x-button wire:click.prevent="exportExcel" class="!bg-transparent !border-none !shadow-none !text-gray-700 !font-normal w-full text-left px-4 py-2 hover:bg-gray-100">
                        Exportar a Excel </x-button>
                    <x-button wire:click.prevent="exportPdf" class="!bg-transparent !border-none !shadow-none !text-gray-700 !font-normal w-full text-left px-4 py-2 hover:bg-gray-100">
                        Exportar a PDF </x-button>
                </x-custom-dropdown>
            </div>
        @endslot

        @slot('body')
            @foreach ($marcas as $marca)
                <tr wire:key="marca-{{$marca->idmarca}}">
                    <x-generic-table.cell>{{ $marca->idmarca }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $marca->clave }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $marca->marca }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $marca->comentarios }}</x-generic-table.cell>
                    
                    <x-generic-table.cell>
                        <flux:button wire:click="edit({{ $marca->idmarca }})">Editar</flux:button>
                        <flux:button wire:click="confirmdelete({{ $marca->idmarca }})" variant="danger">
                            Eliminar
                        </flux:button>
                    </x-generic-table.cell>
                </tr>
            @endforeach
        @endslot
    </x-generic-table>

    <div>
        {{ $marcas->links() }}
    </div>
    <x-confirm-delete />
</div>
