<div class="p-4 gap-4">
    <input wire:model.live.debounce.500ms="search" type="text" placeholder="Buscar Familias por clave o nombre"
        class="rounded-lg border p-2 w-full shadow-md" />
    <x-generic-table header="Listado de familias" :headerValues="$headerValues" :showActions="true">
        @slot('headerAction')
            <div class="flex space-x-2">
                <x-button wire:click="create">Crear nueva familia</x-button>
                <x-button wire:click="export">Exportar</x-button>
            </div>
        @endslot

        @slot('body')
            @foreach ($familias as $familia)
                <tr wire:key="familia-{{$familia->idfamilia}}">
                    <x-generic-table.cell>{{ $familia->idfamilia }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $familia->idempresa }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $familia->clave }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $familia->nombrefamilia }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $familia->comentario }}</x-generic-table.cell>

                    <x-generic-table.cell>
                        <flux:button wire:click="edit({{ $familia->idfamilia }})">Editar</flux:button>
                        <flux:button wire:click="confirmdelete({{ $familia->idfamilia }})" variant="danger">
                            Eliminar
                        </flux:button>
                    </x-generic-table.cell>
                </tr>
            @endforeach
        @endslot
    </x-generic-table>
    <div>
        {{ $familias->links() }}
    </div>
    <x-confirm-delete />
</div>
