<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Existencias por Sucursales</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 10px;
            margin: 15px;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #333;
            padding-bottom: 8px;
        }
        h1 {
            font-size: 16px;
            margin: 0 0 8px 0;
            color: #333;
        }
        .info {
            font-size: 9px;
            color: #666;
        }
        .filters {
            background-color: #f9f9f9;
            padding: 8px;
            margin-bottom: 12px;
            border: 1px solid #ddd;
            font-size: 9px;
        }
        .filters strong {
            color: #333;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 12px;
            font-size: 8px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 4px 6px;
            text-align: left;
        }
        .table th {
            background-color: #4a5568;
            color: white;
            font-weight: bold;
            font-size: 8px;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .footer {
            margin-top: 15px;
            text-align: center;
            font-size: 8px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 8px;
        }
        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            background-color: #e3f2fd;
            color: #1976d2;
            font-size: 8px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Reporte de Existencias por Sucursales</h1>
        <p class="info">Reporte generado el: {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>

    <div class="filters">
        <strong>Filtros aplicados:</strong><br>
        Total de productos: {{ count($productos) }}<br>
        Total de sucursales: {{ count($sucursales) }}<br>
        @if($search)
            Búsqueda: {{ $search }}<br>
        @endif
        @if($familia)
            Familia: {{ $familiaSeleccionada }}<br>
        @endif
        @if($tipoBusqueda)
            Tipo: {{ $tipoBusqueda }}<br>
        @endif
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>Folio</th>
                <th>Clave</th>
                <th>Familia</th>
                <th>Descripción</th>
                @foreach ($sucursales as $sucursal)
                    <th class="text-center">{{ $sucursal->razon_social }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach ($productos as $producto)
                <tr>
                    <td>{{ $producto->folio_correlativo }}</td>
                    <td>{{ $producto->clave }}</td>
                    <td><span class="badge">{{ $producto->familia ?? 'Sin familia' }}</span></td>
                    <td>{{ $producto->descripcion }}</td>
                    @foreach ($sucursales as $sucursal)
                        <td class="text-center">
                            {{ number_format($producto->existencias[$sucursal->idbranchoffice] ?? 0, 0) }}
                        </td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Documento generado automáticamente por el sistema | {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>
</body>
</html>
