<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cotización</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 20px;
            line-height: 1.2;
        }
        
        .header {
            width: 100%;
            margin-bottom: 20px;
            position: relative;
        }
        
        .title-section {
            text-align: left;
            margin-bottom: 15px;
        }
        
        .title-section h1 {
            font-size: 14px;
            font-weight: bold;
            margin: 0;
            letter-spacing: 2px;
        }
        
        .header-info {
            position: absolute;
            right: 0;
            top: 0;
            font-size: 10px;
        }
        
        .header-info div {
            margin-bottom: 2px;
        }
        
        .main-content {
            display: table;
            width: 100%;
            margin-bottom: 15px;
        }
        
        .logo-section {
            display: table-cell;
            width: 150px;
            vertical-align: top;
            padding-right: 15px;
        }
        
        .info-sections {
            display: table-cell;
            vertical-align: top;
            width: calc(100% - 150px);
        }
        
        .logo-placeholder {
            width: 120px;
            height: 80px;
            border: 1px solid #000;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 8px;
            margin-bottom: 10px;
        }
        
        .client-section {
            width: 100%;
            margin-bottom: 15px;
            overflow: hidden;
        }
        
        .emisor, .receptor {
            float: left;
            width: 45%;
            font-size: 9px;
        }
        
        .receptor {
            float: right;
            width: 45%;
        }
        
        .section-title {
            font-weight: bold;
            margin-bottom: 3px;
        }
        
        .section-content {
            margin-bottom: 10px;
        }
        
        .section-content div {
            margin-bottom: 1px;
        }
        
        .products-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 9px;
        }
        
        .products-table th {
            background-color: #f8f8f8;
            border: 1px solid #000;
            padding: 4px 3px;
            font-weight: bold;
        }
        
        .products-table td {
            border: 1px solid #000;
            padding: 3px;
            text-align: center;
        }
        
        .products-table td.text-left {
            text-align: left;
            padding-left: 5px;
        }
        
        .products-table td.text-right {
            text-align: right;
            padding-right: 5px;
        }
        
        .totals-section {
            float: right;
            width: 180px;
            margin-top: 20px;
            clear: both;
        }
        
        .totals-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
        }
        
        .totals-table td {
            border: 1px solid #000;
            padding: 4px 8px;
        }
        
        .totals-table td:first-child {
            font-weight: bold;
            text-align: left;
        }
        
        .totals-table td:last-child {
            text-align: right;
            white-space: nowrap;
            vertical-align: middle;
        }
        
        .money-amount {
            display: inline-block;
            white-space: nowrap;
            vertical-align: middle;
        }
        
        .total-words {
            clear: both;
            margin-top: 50px;
            font-size: 10px;
            font-weight: bold;
            text-align: left;
            margin-left: 20px;
        }
        
        .clearfix::after {
            content: "";
            display: table;
            clear: both;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="title-section">
            <h1>COTIZACION</h1>
        </div>
        <div class="header-info">
            <div><strong>FOLIO:</strong> {{ $folio }}</div>
            <div><strong>FECHA:</strong> {{ $fecha }}</div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="logo-section">
            <div class="logo-placeholder">
                <!-- Logo aquí -->
            </div>
        </div>
        
        <div class="info-sections">
            <!-- Emisor y Receptor lado a lado -->
            <div class="client-section">
                <div class="emisor">
                    <div class="section-title">Emisor:</div>
                    <div class="section-content">
                        <div><strong>{{ $empresa['razon_social'] }}</strong></div>
                        <div>{{ $empresa['rfc'] }}</div>
                        <div>{{ $empresa['direccion'] }}</div>
                        <div>{{ $empresa['ciudad'] }} C.P.: {{ $empresa['cp'] }}</div>
                        <div><strong>Lugar de Expedición:</strong> {{ $empresa['lugar_expedicion'] }}</div>
                        <div><strong>Régimen Fiscal:</strong> {{ $empresa['regimen_fiscal'] }}</div>
                        <div><strong>Tel:</strong> {{ $empresa['telefono'] }}</div>
                    </div>
                </div>
                
                <div class="receptor">
                    <div class="section-title">Receptor:</div>
                    <div class="section-content">
                        <div><strong>{{ $cliente['nombre'] }}</strong></div>
                        <div>{{ $cliente['rfc'] }}</div>
                        <div>{{ $cliente['direccion'] }}</div>
                        <div><strong>Código Postal:</strong> {{ $cliente['cp'] }}</div>
                        <div><strong>Régimen Fiscal:</strong> {{ $cliente['regimen_fiscal'] }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tabla de productos -->
    <table class="products-table">
        <thead>
            <tr>
                <th style="width: 12%;">Producto</th>
                <th style="width: 8%;">Cantidad</th>
                <th style="width: 8%;">Unidad</th>
                <th style="width: 10%;">Precio U</th>
                <th style="width: 52%;">Concepto(s)</th>
                <th style="width: 10%;">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach($productos as $producto)
            <tr>
                <td class="text-left">{{ $producto['clave'] ?? $producto['productoid'] ?? '' }}</td>
                <td>{{ $producto['cantidad'] }}</td>
                <td>{{ $producto['unidad'] ?? 'H87 Pieza' }}</td>
                <td class="text-right"><span class="money-amount">$ {{ number_format($producto['precio_unitario'], 2) }}</span></td>
                <td class="text-left">{{ $producto['descripcion'] }}</td>
                <td class="text-right"><span class="money-amount">$ {{ number_format($producto['subtotal'], 2) }}</span></td>
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <div class="clearfix">
        <!-- Totales -->
        <div class="totals-section">
            <table class="totals-table">
                <thead>
                    <tr>
                        <th>Concepto</th>
                        <th>Importe</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Subtotal:</td>
                        <td><span class="money-amount">$ {{ number_format($totales['subtotal'], 2) }}</span></td>
                    </tr>
                    <tr>
                        <td>IVA (16%):</td>
                        <td><span class="money-amount">$ {{ number_format($totales['iva'], 2) }}</span></td>
                    </tr>
                    @if($totales['ieps'] > 0)
                    <tr>
                        <td>IEPS:</td>
                        <td><span class="money-amount">$ {{ number_format($totales['ieps'], 2) }}</span></td>
                    </tr>
                    @endif
                    @if($totales['retenciones'] > 0)
                    <tr style="border-top: 1px solid #ccc;">
                        <td colspan="2" style="text-align: center; font-weight: bold; font-style: italic; padding: 3px;">Retenciones</td>
                    </tr>
                    @if(isset($totales['retencion_isr']) && $totales['retencion_isr'] > 0)
                    <tr>
                        <td style="padding-left: 10px;">(-) R.ISR:</td>
                        <td><span class="money-amount">-$ {{ number_format($totales['retencion_isr'], 2) }}</span></td>
                    </tr>
                    @endif
                    @if(isset($totales['retencion_iva']) && $totales['retencion_iva'] > 0)
                    <tr>
                        <td style="padding-left: 10px;">(-) R.IVA (10.67%):</td>
                        <td><span class="money-amount">-$ {{ number_format($totales['retencion_iva'], 2) }}</span></td>
                    </tr>
                    @endif
                    @endif
                    <tr style="border-top: 2px solid #000;">
                        <td><strong>Total:</strong></td>
                        <td><strong><span class="money-amount">$ {{ number_format($totales['total'], 2) }}</span></strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Total en letras -->
    <div class="total-words">
        ** {{ strtoupper($total_letras) }} **
    </div>
</body>
</html>
