<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">

<head>
    @include('partials.head')
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    {{-- Font Awesome 6.5.1 (versión estable con integrity correcto) --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    @vite(['resources/css/app.css', 'resources/js/app.js'])

</head>

<body class="flex flex-row min-h-screen w-full bg-white white:bg-zinc-800 text-black">
    <!-- component -->
    <div x-data="setup()" x-init="$refs.loading.classList.add('hidden');" @resize.window="watchScreen()">
        <div class="flex h-screen antialiased text-gray-900 bg-gray-100 dark:bg-dark dark:text-light">
            <!-- Loading screen -->
            <div x-ref="loading"
                class="fixed inset-0 z-50 flex items-center justify-center text-2xl font-semibold text-white bg-indigo-800">
                Loading.....
            </div>

            <!-- Sidebar -->
            @include('components.layouts.app.sidebar')

        </div>
    </div>
    <div class="w-full flex-1 flex flex-col h-screen overflow-auto">
        @include('components.layouts.app.navbar')
        <div id="scroll-box" class="flex-1 overflow-y-auto m-4">
            {{ $slot }}
        </div>
    </div>
    @livewireStyles
    @livewireScripts
    <script>
        const setup = () => {
            return {
                isSidebarOpen: false,
                isSidebarPinned: false, // Nueva propiedad para manejar el estado fijo del sidebar
                currentSidebarTab: null,
                isSettingsPanelOpen: false,
                isSubHeaderOpen: false,
                toggleTab(tab) {
                    if (this.currentSidebarTab === tab) {
                        // Si el botón actual está seleccionado, alterna el estado de fijación
                        this.isSidebarPinned = !this.isSidebarPinned;
                        if (!this.isSidebarPinned) {
                            this.isSidebarOpen = false;
                            this.currentSidebarTab = null;
                        }
                    } else {
                        // Cambia a la nueva pestaña y fija el sidebar
                        this.currentSidebarTab = tab;
                        this.isSidebarPinned = true;
                        this.isSidebarOpen = true;
                    }
                },
                hoverTab(tab) {
                    if (!this.isSidebarPinned) {
                        this.currentSidebarTab = tab;
                        this.isSidebarOpen = true;
                    }
                },
                leaveTab() {
                    if (!this.isSidebarPinned) {
                        this.isSidebarOpen = false;
                        this.currentSidebarTab = null;
                    }
                },
                watchScreen() {
                    if (window.innerWidth <= 1024) {
                        this.isSidebarOpen = false;
                        this.isSidebarPinned = false;
                    }
                },
            }
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
    @stack('scripts')
    @fluxScripts
        @stack('scripts')
</body>

</html>

