@props(['title', 'description', 'exportPdf', 'exportExcel'])

<div>
    <flux:modal name="exportar" class="max-w-md" {{ $attributes->only('wire:model') }}>

    <div class="space-y-6">
        <flux:heading size="lg">{{ $title }}</flux:heading>

        <div class="space-y-3">
            <p class="text-sm text-zinc-600 dark:text-zinc-400 mb-4">
                {{ $description }}
            </p>

            <button wire:click="{{ $exportExcel }}" type="button"
                class="w-full flex items-center gap-4 p-4 border dark:border-zinc-700 rounded-lg hover:bg-zinc-50 dark:hover:bg-zinc-800/50 transition-colors group">
                <div
                    class="flex-shrink-0 w-10 h-10 bg-green-100 dark:bg-green-900/20 rounded-lg flex items-center justify-center group-hover:bg-green-200 dark:group-hover:bg-green-900/30 transition-colors">
                    <flux:icon.document class="w-6 h-6 text-green-600 dark:text-green-400" />
                </div>
                <div class="flex-1 text-left">
                    <div class="font-medium">Exportar a Excel</div>
                    <div class="text-xs text-zinc-500 dark:text-zinc-400">Archivo compatible con Microsoft Excel
                    </div>
                </div>
                <flux:badge color="green">XLSX</flux:badge>
            </button>

            <button wire:click="{{ $exportPdf }}" type="button"
                class="w-full flex items-center gap-4 p-4 border dark:border-zinc-700 rounded-lg hover:bg-zinc-50 dark:hover:bg-zinc-800/50 transition-colors group">
                <div
                    class="flex-shrink-0 w-10 h-10 bg-red-100 dark:bg-red-900/20 rounded-lg flex items-center justify-center group-hover:bg-red-200 dark:group-hover:bg-red-900/30 transition-colors">
                    <flux:icon.document-text class="w-6 h-6 text-red-600 dark:text-red-400" />
                </div>
                <div class="flex-1 text-left">
                    <div class="font-medium">Exportar a PDF</div>
                    <div class="text-xs text-zinc-500 dark:text-zinc-400">Documento portátil para imprimir</div>
                </div>
                <flux:badge color="red">PDF</flux:badge>
            </button>
        </div>
        <flux:button variant="ghost" wire:click="$set('{{ $attributes->get('wire:model') }}', false)">
            Cancelar
        </flux:button>
    </div>

    </flux:modal>
</div>
