@props(['title' => '', 'total' => 0, 'count' => 0])

<div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
    {{-- Header --}}
    @if($title || $total > 0)
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                @if($title)
                    <h2 class="text-xl font-semibold text-gray-800 dark:text-white">
                        {{ $title }} @if($total > 0)({{ $total }})@endif
                    </h2>
                @endif
                @if($count > 0 && $total > 0)
                    <span class="text-sm text-gray-600 dark:text-gray-400">
                        Mostrando {{ $count }} de {{ $total }} registros
                    </span>
                @endif
            </div>
        </div>
    @endif

    {{-- Tabla responsive --}}
    <div class="overflow-x-auto">
        <table class="w-full text-sm">
            {{ $slot }}
        </table>
    </div>
</div>
