@props([
    'title' => '¡Éxito!',
    'text' => 'La operación se completó correctamente.',
    'close' => null,
])
@php
    $method = null !== $close ? $close[0] : '';
    $args = null !== $close ? array_slice($close, 1) : '';
@endphp
<div>
    <script>
        document.addEventListener('livewire:init', function() {
            window.addEventListener('create-alert', () => {
                Swal.fire({
                    title: @json($title),
                    text: @json($text),
                    icon: 'success',
                    confirmButtonText: 'Aceptar'
                }).then(() => {
                    if (@json($close) !== null) {
                        @this.call(@json($method), ...@json($args));
                    }
                });
            });
        });
    </script>
</div>
