/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `articulo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `articulo` (
  `idarticulo` int(11) NOT NULL AUTO_INCREMENT,
  `idcategoria` int(11) NOT NULL,
  `codigo` varchar(50) DEFAULT NULL,
  `nombre` varchar(100) NOT NULL,
  `stock` int(11) NOT NULL,
  `descripcion` varchar(512) DEFAULT NULL,
  `imagen` varchar(50) DEFAULT NULL,
  `estado` varchar(20) NOT NULL,
  PRIMARY KEY (`idarticulo`) USING BTREE,
  KEY `fk_articulo_categoria_idx` (`idcategoria`) USING BTREE,
  CONSTRAINT `fk_articulo_categoria` FOREIGN KEY (`idcategoria`) REFERENCES `categoria` (`idcategoria`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `bitacora_existencias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bitacora_existencias` (
  `idbinnacle` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idbitacora` bigint(20) NOT NULL,
  `fechahora_registro` timestamp NULL DEFAULT current_timestamp(),
  `tipo` varchar(20) NOT NULL,
  `signo` int(11) NOT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `origen_idmovimiento` bigint(20) NOT NULL,
  `origen_folio` bigint(20) DEFAULT NULL,
  `idproducto` bigint(20) NOT NULL,
  `existencia_anterior` decimal(18,6) NOT NULL,
  `movimiento_cantidad` decimal(18,6) NOT NULL,
  `existencia_final` decimal(18,6) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idalmacen` bigint(20) DEFAULT 0,
  `comentarios` varchar(120) NOT NULL,
  `fisico` decimal(18,6) DEFAULT NULL,
  `faltante` decimal(18,6) DEFAULT NULL,
  `excedente` decimal(18,6) DEFAULT NULL,
  `precio_unitario` decimal(18,6) DEFAULT NULL,
  `importe` decimal(18,6) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  `descargado` smallint(1) NOT NULL,
  PRIMARY KEY (`idbinnacle`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cajas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cajas` (
  `idbox` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idcaja` int(11) NOT NULL,
  `nombre_caja` varchar(30) NOT NULL,
  `hostname` varchar(30) NOT NULL,
  `direccionip` varchar(20) NOT NULL,
  `origen_registro` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`idbox`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_acciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_acciones` (
  `idaccion` int(11) NOT NULL AUTO_INCREMENT,
  `accion` varchar(20) NOT NULL,
  PRIMARY KEY (`idaccion`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_aduanas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_aduanas` (
  `idaduana` bigint(20) NOT NULL,
  `clave_aduana` varchar(10) DEFAULT NULL,
  `descripcion` varchar(150) NOT NULL,
  PRIMARY KEY (`idaduana`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_almacenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_almacenes` (
  `idwarehouse` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `comentarios` varchar(254) NOT NULL,
  `tipo_almacen` varchar(30) DEFAULT NULL,
  `es_de_control_interno` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`idwarehouse`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_almacenes_AI` AFTER INSERT ON `cat_almacenes`
 FOR EACH ROW BEGIN
  DECLARE m_idproduct INT;
  DECLARE vManejaInventario INT;
  DECLARE fin INT;  
  DECLARE cur_prod CURSOR FOR SELECT idproduct,manejainventario FROM cat_productos WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  OPEN cur_prod;
        ins_loop: LOOP
            FETCH cur_prod INTO m_idproduct,vManejaInventario;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
			IF vManejaInventario = 1 THEN
				INSERT INTO mov_inv_existencias (idempresa, idsucursal, idinventario, idproducto, idalmacen, 
                                                 existencia, contados, idsucursalorigen, origen_registro, descargado) 
            	VALUES (NEW.idempresa, NEW.idsucursal, 0, m_idproduct, NEW.idwarehouse,0,0,NEW.idwarehouse,'WEB',1);	
			END IF;
            
        END LOOP;
  CLOSE cur_prod;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_clientes` (
  `idclient` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `clave` varchar(30) NOT NULL,
  `espersonafisica` smallint(6) NOT NULL,
  `rfc` varchar(20) NOT NULL,
  `curp` varchar(20) NOT NULL,
  `nombrecorto` varchar(30) NOT NULL,
  `nombre` varchar(180) NOT NULL,
  `calle` varchar(100) NOT NULL,
  `cruzamientos` varchar(100) NOT NULL,
  `noexterior` varchar(100) NOT NULL,
  `nointerior` varchar(50) NOT NULL,
  `colonia` varchar(100) NOT NULL,
  `referencia` varchar(254) NOT NULL,
  `ciudad` varchar(50) NOT NULL,
  `municipio` varchar(50) NOT NULL,
  `estado` varchar(50) NOT NULL,
  `pais` varchar(50) NOT NULL,
  `clave_codigopostal` varchar(10) DEFAULT NULL,
  `codigopostal` varchar(30) NOT NULL,
  `telefono` varchar(50) NOT NULL,
  `email` varchar(300) NOT NULL,
  `http` varchar(80) NOT NULL,
  `contacto` varchar(80) NOT NULL,
  `fechaalta` date NOT NULL,
  `idlistaprecio` bigint(20) NOT NULL,
  `diasdecredito` smallint(6) NOT NULL,
  `limitecredito` decimal(18,6) NOT NULL,
  `comentarios` varchar(180) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idsucursalorigen` int(11) NOT NULL,
  `puntosacumulados` int(11) NOT NULL,
  `tarjetacliente` varchar(30) NOT NULL,
  `estatus` smallint(6) NOT NULL,
  `imagentarjetacliente` blob DEFAULT NULL,
  `imagenfotografia` blob DEFAULT NULL,
  `identificacion_tarjeta` varchar(50) NOT NULL,
  `identificacion_frontal` blob DEFAULT NULL,
  `identificacion_posterior` blob DEFAULT NULL,
  `comprobante_domiciliario` blob DEFAULT NULL,
  `nomanejadatosfiscales` smallint(6) NOT NULL,
  `formadepago` varchar(60) DEFAULT NULL,
  `metododepago` varchar(60) NOT NULL,
  `numerocuentapago` varchar(50) NOT NULL,
  `tipo_cliente` varchar(50) DEFAULT NULL,
  `comentarios2` blob DEFAULT NULL,
  `aplicar_desctox100` smallint(6) DEFAULT NULL,
  `descuento_a_aplicar` decimal(18,6) DEFAULT NULL,
  `regimenfiscal` varchar(130) DEFAULT NULL,
  `usocfdi` varchar(130) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idclient`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_clientes_insert` AFTER INSERT ON `cat_clientes` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

	IF (NEW.origen_registro = 'WEB') THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idclient, 'I', 'CLIENTES');
        END LOOP;
      CLOSE cur;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_clientes_update` AFTER UPDATE ON `cat_clientes` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

	IF (NEW.origen_registro = 'WEB') THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idclient, 'U', 'CLIENTES');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_clientes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_clientes_tipos` (
  `idclienttype` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idclientetipo` int(11) NOT NULL,
  `clientetipo` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`idclienttype`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_clientes_tipos_insert` AFTER INSERT ON `cat_clientes_tipos`
 FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idclienttype, 'I', 'CLIENTES_TIPOS');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_clientes_tipos_update` AFTER UPDATE ON `cat_clientes_tipos`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idclienttype, 'U', 'CLIENTES_TIPOS');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_codigospostales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_codigospostales` (
  `idcodigopostal` bigint(20) NOT NULL,
  `clave_codigopostal` varchar(10) DEFAULT NULL,
  `clave_estado` varchar(10) NOT NULL,
  `clave_municipio` varchar(10) DEFAULT NULL,
  `clave_localidad` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`idcodigopostal`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_conceptosinventarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_conceptosinventarios` (
  `idinventoryconcept` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idconceptoinventario` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `conceptoinventario` varchar(80) NOT NULL,
  `idaccion` int(11) NOT NULL,
  `signo` tinyint(4) NOT NULL,
  `editable` smallint(1) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idinventoryconcept`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_conceptosinventarios_insert` AFTER INSERT ON `cat_conceptosinventarios` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

	IF NEW.origen_registro = 'WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idinventoryconcept, 'I', 'CONCEPTOSINVENTARIOS');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_conceptosinventarios_update` AFTER UPDATE ON `cat_conceptosinventarios` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

	IF NEW.origen_registro = 'WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idinventoryconcept, 'U', 'CONCEPTOSINVENTARIOS');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_conceptosinventarios_delete` AFTER DELETE ON `cat_conceptosinventarios` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = OLD.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	
    DELETE FROM mov_changes 
    WHERE idempresa = OLD.idempresa
    AND tabla = 'CONCEPTOSINVENTARIOS' AND identable = OLD.idinventoryconcept;
    
    OPEN cur;
      ins_loop: LOOP
         FETCH cur INTO m_idsucursal;
         IF fin=1 THEN
           LEAVE ins_loop;
         END IF;
         INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
         VALUES (OLD.idempresa, m_idsucursal, OLD.idinventoryconcept, 'D', 'CONCEPTOSINVENTARIOS');
      END LOOP;
    CLOSE cur;
	
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_demo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_demo` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(120) NOT NULL,
  `total` decimal(10,0) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_empresas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_empresas` (
  `idempresa` bigint(20) NOT NULL AUTO_INCREMENT,
  `rfc` varchar(15) NOT NULL,
  `razon_social` varchar(120) NOT NULL,
  `telefono1` varchar(50) NOT NULL,
  `telefono2` varchar(50) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  `comentarios` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idempresa`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_estados` (
  `idestado` int(11) NOT NULL,
  `idpais` int(11) NOT NULL,
  `clave` varchar(10) DEFAULT NULL,
  `estado` varchar(50) NOT NULL,
  `clave_estado` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`idestado`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_familias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_familias` (
  `idfamily` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idfamilia` bigint(20) NOT NULL,
  `idfamiliapadre` bigint(20) NOT NULL,
  `cadenapadre` varchar(50) NOT NULL,
  `cadenahijo` varchar(50) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `nombrefamilia` varchar(30) NOT NULL,
  `comentario` varchar(80) NOT NULL,
  `esunasubfamilia` smallint(6) NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idfamily`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_familias_insert` AFTER INSERT ON `cat_familias` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idbranchoffice FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	IF NEW.origen_registro = 'WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla)
            VALUES (NEW.idempresa, m_idsucursal, NEW.idfamily, 'I', 'FAMILIAS');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_familiasupdate` AFTER UPDATE ON `cat_familias` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idbranchoffice FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	IF NEW.origen_registro = 'WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla)
            VALUES (NEW.idempresa, m_idsucursal, NEW.idfamily, 'U', 'FAMILIAS');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_familiasdelete` AFTER DELETE ON `cat_familias` FOR EACH ROW BEGIN
  DECLARE m_idsucursal INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
  	FROM cat_sucursales WHERE idempresa = OLD.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	      
  DELETE FROM mov_changes 
  WHERE idempresa = OLD.idempresa
  AND tabla = 'FAMILIAS' AND identable = OLD.idfamily;
            
  OPEN cur;
    ins_loop: LOOP
    
      FETCH cur INTO m_idsucursal;
      
      IF fin=1 THEN
        LEAVE ins_loop;
      END IF;
            
      INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
      VALUES (OLD.idempresa, m_idsucursal, OLD.idfamily, 'D', 'FAMILIAS');
    
    END LOOP;    
  CLOSE cur;
	
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_formasdepago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_formasdepago` (
  `idformadepago` bigint(20) NOT NULL,
  `clave_formadepago` varchar(10) DEFAULT NULL,
  `descripcion` varchar(80) NOT NULL,
  `bancarizado` varchar(10) NOT NULL,
  `numero_operacion` varchar(30) DEFAULT NULL,
  `rfc_emisor` varchar(20) DEFAULT NULL,
  `cuenta_ordenante` varchar(30) DEFAULT NULL,
  `rfc_beneficiario` varchar(20) DEFAULT NULL,
  `cuenta_beneficiario` varchar(30) DEFAULT NULL,
  `tipo_cadena_pago` varchar(50) DEFAULT NULL,
  `banco_emisor` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`idformadepago`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_impuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_impuestos` (
  `idimpuesto` bigint(20) NOT NULL,
  `clave_impuesto` varchar(10) DEFAULT NULL,
  `descripcion` varchar(80) NOT NULL,
  `retencion` varchar(2) NOT NULL,
  `traslado` varchar(2) NOT NULL,
  `local_federal` varchar(20) NOT NULL,
  `entidad_que_aplica` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idimpuesto`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_insumos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_insumos` (
  `idinput` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idinsumo` bigint(20) NOT NULL,
  `idimpuesto` bigint(20) NOT NULL,
  `idfamilia` bigint(20) NOT NULL,
  `idsubfamilia` bigint(20) NOT NULL,
  `idunidadmedida` bigint(20) NOT NULL,
  `descripcion` varchar(254) NOT NULL,
  `codigodebarras` varchar(30) NOT NULL DEFAULT '-1',
  `manejainventario` smallint(6) NOT NULL,
  `manejacaducidad` smallint(6) NOT NULL,
  `insumoactivo` smallint(6) NOT NULL,
  `fechaalta` date NOT NULL,
  `fechaultimacompra` date NOT NULL,
  `precioultimacomprasiniva` decimal(18,6) NOT NULL,
  `precioucompraconiva` decimal(18,6) NOT NULL,
  `costopromediosiniva` decimal(18,6) NOT NULL,
  `stockminimo` decimal(18,6) NOT NULL,
  `imagencodigobarras` blob DEFAULT NULL,
  PRIMARY KEY (`idinput`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_insumos_insert` AFTER INSERT ON `cat_insumos`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idinput, 'I', 'INSUMOS');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_insumos_update` AFTER UPDATE ON `cat_insumos`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idinput, 'U', 'INSUMOS');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_insumos_delete` AFTER DELETE ON `cat_insumos`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = OLD.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (OLD.idempresa, m_idsucursal, OLD.idinput, 'D', 'DELETE');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_marcas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_marcas` (
  `idbrand` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idmarca` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `marca` varchar(30) NOT NULL,
  `comentarios` varchar(50) NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idbrand`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `marca_insert` AFTER INSERT ON `cat_marcas` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idbranchoffice FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
    IF NEW.origen_registro='WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla)
            VALUES (NEW.idempresa, m_idsucursal, NEW.idbrand, 'I', 'MARCAS');
        END LOOP;
      CLOSE cur;
    END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `marca_update` AFTER UPDATE ON `cat_marcas` FOR EACH ROW BEGIN
  DECLARE m_idsucursal INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
    FROM cat_sucursales WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
  
  IF NEW.origen_registro='WEB' THEN
    OPEN cur;
      ins_loop: LOOP
      
        FETCH cur INTO m_idsucursal;
        
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;                                		

        INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
        VALUES (NEW.idempresa, m_idsucursal, NEW.idbrand, 'U', 'MARCAS');
      
      END LOOP;
    CLOSE cur;
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `marca_delete` AFTER DELETE ON `cat_marcas` FOR EACH ROW BEGIN
  DECLARE m_idsucursal INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
    FROM cat_sucursales WHERE idempresa = OLD.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
    
  DELETE FROM mov_changes 
  WHERE idempresa = OLD.idempresa
  AND tabla = 'MARCAS'
  AND identable = OLD.idbrand;
            
  OPEN cur;
    ins_loop: LOOP
    
      FETCH cur INTO m_idsucursal;
      
      IF fin=1 THEN
        LEAVE ins_loop;
      END IF;
            
      INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
      VALUES (OLD.idempresa, m_idsucursal, OLD.idbrand, 'D', 'MARCAS');
      
    END LOOP;
  CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_metododepago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_metododepago` (
  `idmetododepago` bigint(20) NOT NULL,
  `clave_metododepago` varchar(10) DEFAULT NULL,
  `descripcion` varchar(80) NOT NULL,
  PRIMARY KEY (`idmetododepago`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_monedas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_monedas` (
  `idmoneda` bigint(20) NOT NULL,
  `clave_moneda` varchar(10) NOT NULL,
  `descripcion` varchar(80) NOT NULL,
  `decimales` smallint(6) NOT NULL,
  `porcentaje_variacion` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idmoneda`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_municipios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_municipios` (
  `idmunicipio` int(11) NOT NULL,
  `idestado` int(11) NOT NULL,
  `clave` varchar(10) DEFAULT NULL,
  `municipio` varchar(50) NOT NULL,
  `siglas` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`idmunicipio`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_numpedimentoaduana`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_numpedimentoaduana` (
  `idnumpedimentoaduana` bigint(20) NOT NULL,
  `clave_numpedimentoaduana` varchar(10) NOT NULL,
  `patente` varchar(10) NOT NULL,
  `ejercicio` varchar(10) NOT NULL,
  `cantidad` varchar(10) NOT NULL,
  `fecha_inicio_vigencia` date DEFAULT NULL,
  `fecha_fin_vigencia` date DEFAULT NULL,
  PRIMARY KEY (`idnumpedimentoaduana`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_origeninventario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_origeninventario` (
  `idinventorysource` bigint(20) NOT NULL AUTO_INCREMENT,
  `idorigeninventario` bigint(20) NOT NULL,
  `origeninventario` varchar(250) NOT NULL,
  `comentarios` varchar(250) NOT NULL,
  PRIMARY KEY (`idinventorysource`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_paises`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_paises` (
  `idpais` int(11) NOT NULL,
  `clave` varchar(10) DEFAULT NULL,
  `pais` varchar(50) NOT NULL,
  `agrupaciones` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idpais`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_patenteaduanal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_patenteaduanal` (
  `idpatenteaduanal` bigint(20) NOT NULL,
  `clave_patenteaduanal` varchar(10) NOT NULL,
  `vigencia_inicio` date NOT NULL,
  `vigencia_fin` date DEFAULT NULL,
  PRIMARY KEY (`idpatenteaduanal`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_prodserv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_prodserv` (
  `idprodserv` bigint(20) NOT NULL,
  `clave_prodserv` varchar(10) DEFAULT NULL,
  `descripcion` varchar(150) NOT NULL,
  `fecha_inicio_vigencia` date DEFAULT NULL,
  `fecha_fin_vigencia` date DEFAULT NULL,
  `incluir_iva_trasladado` smallint(6) DEFAULT NULL,
  `incluir_ieps_trasladado` smallint(6) DEFAULT NULL,
  `complemento_a_incluir` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`idprodserv`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_productos` (
  `idproduct` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `idimpuesto` bigint(20) NOT NULL,
  `idmarca` bigint(20) NOT NULL,
  `idfamilia` bigint(20) NOT NULL,
  `idsubfamilia` bigint(20) NOT NULL,
  `idunidadmedida` bigint(20) NOT NULL,
  `clave` varchar(30) NOT NULL DEFAULT '-1',
  `nombrecorto` varchar(30) NOT NULL,
  `descripcion` varchar(254) NOT NULL,
  `manejanumeroserie` smallint(6) NOT NULL,
  `manejainventario` smallint(6) NOT NULL,
  `esproductocompuesto` smallint(6) NOT NULL,
  `codigodebarras` varchar(30) NOT NULL DEFAULT '-1',
  `manejacaducidad` smallint(6) NOT NULL,
  `productoexclusivo` smallint(6) NOT NULL,
  `productoactivo` smallint(6) NOT NULL,
  `leerbascula` smallint(6) NOT NULL,
  `fechaalta` date NOT NULL,
  `fechaultimacompra` date NOT NULL,
  `precioultimacompra` decimal(18,6) NOT NULL,
  `precioventaantesiva` decimal(18,6) NOT NULL,
  `porcentajeutilidad` decimal(18,6) NOT NULL,
  `precioventaconiva` decimal(18,6) NOT NULL,
  `preciocredito` decimal(18,6) NOT NULL,
  `stockminimo` decimal(18,6) NOT NULL,
  `esvisibleenventas` smallint(6) NOT NULL DEFAULT -1,
  `pormontoocantidad` smallint(6) NOT NULL DEFAULT -1,
  `limiteparamediomayoreo` decimal(18,6) NOT NULL,
  `preciomediomayoreo` decimal(18,6) NOT NULL,
  `limiteparamayoreo` decimal(18,6) NOT NULL,
  `preciomayoreo` decimal(18,6) NOT NULL,
  `porcentajepuntos` decimal(18,6) DEFAULT NULL,
  `habilitar_pesaje` smallint(6) NOT NULL,
  `pesaje` decimal(18,6) NOT NULL,
  `maneja_kilataje` smallint(6) NOT NULL,
  `idkilataje` int(11) NOT NULL,
  `comision1x100` decimal(18,6) NOT NULL,
  `comision2x100` decimal(18,6) NOT NULL,
  `comision3x100` decimal(18,6) NOT NULL,
  `comisiontipo` smallint(6) NOT NULL,
  `manejainsumos` smallint(6) DEFAULT NULL,
  `obtener_datos_from_cbb` smallint(6) DEFAULT NULL,
  `aplicar_tipodecambio` smallint(6) DEFAULT NULL,
  `costo_promedio_antesiva` decimal(18,6) DEFAULT NULL,
  `costo_promedio_iva` decimal(18,6) DEFAULT NULL,
  `costo_promedio_despuesiva` decimal(18,6) DEFAULT NULL,
  `es_trace` smallint(6) DEFAULT NULL,
  `nota1` varchar(400) DEFAULT NULL,
  `nota2` varchar(400) DEFAULT NULL,
  `nota3` varchar(400) DEFAULT NULL,
  `clave_prodserv` varchar(10) NOT NULL,
  `prodserv` varchar(150) NOT NULL,
  `clave_unidadmedida` varchar(10) NOT NULL,
  `unidadmedida` varchar(150) NOT NULL,
  `clave_impuesto` varchar(10) NOT NULL,
  `impuesto` varchar(80) NOT NULL,
  `clave_tipofactor` varchar(10) NOT NULL,
  `tasa_factor` varchar(20) NOT NULL,
  `tasa_impuesto` varchar(20) NOT NULL,
  `tasa_tipo_rango` varchar(10) NOT NULL,
  `tasa_valor_maximo` decimal(18,6) NOT NULL,
  `tasa_traslado` smallint(6) NOT NULL,
  `tasa_retencion` smallint(6) NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  `esproductobasepresentacion` tinyint(1) DEFAULT NULL,
  `imagen` varchar(255) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `traslado_iva_tipo_factor` varchar(20) DEFAULT NULL,
  `traslado_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_tipo_factor` varchar(20) DEFAULT NULL,
  `traslado_ieps_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `retencion_iva_tipo_factor` varchar(20) DEFAULT NULL,
  `retencion_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `retencion_isr_tipo_factor` varchar(20) DEFAULT NULL,
  `retencion_isr_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_iva_exento` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`idproduct`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `producto_insert` AFTER INSERT ON `cat_productos` FOR EACH ROW BEGIN
  DECLARE m_idbranchoffice INT;
  DECLARE m_idwarehouse INT;
	
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
  	FROM cat_sucursales WHERE idempresa = NEW.idempresa;
  DECLARE cur_alm CURSOR FOR SELECT idwarehouse, idsucursal 
  	FROM cat_almacenes WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  IF NEW.manejainventario=1 THEN
    OPEN cur_alm;
      ins_loop: LOOP
      
        FETCH cur_alm INTO m_idwarehouse, m_idbranchoffice;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;

        INSERT INTO mov_inv_existencias(idmovinvexistencia, idempresa, idinventario,
          idproducto, idalmacen, existencia, idsucursal, contados, idsucursalorigen)
        VALUES (0, NEW.idempresa, 0, NEW.idproduct, m_idwarehouse, 0, m_idbranchoffice, 0, m_idbranchoffice);

      END LOOP;
	CLOSE cur_alm;
  END IF;
  
  SET fin=0;
  
  IF NEW.origen_registro = 'WEB' THEN
    OPEN cur;
      ins_loop: LOOP
        FETCH cur INTO m_idbranchoffice;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;
        INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
        VALUES (NEW.idempresa, m_idbranchoffice, NEW.idproduct, 'I', 'PRODUCTOS');
      END LOOP;
    CLOSE cur;
  END IF;  
  
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `producto_update` AFTER UPDATE ON `cat_productos` FOR EACH ROW BEGIN
  DECLARE m_idsucursal BIGINT;
  DECLARE fin INT;
  DECLARE vInsertarInventarios BOOL;
  DECLARE vInventariosEncontrados INT;
  DECLARE vIdAlmacen BIGINT;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
    FROM cat_sucursales WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  IF NEW.origen_registro = 'WEB' THEN
    
    SET vInsertarInventarios = false;
    SET vInventariosEncontrados = 0;
 	  
    IF NEW.manejainventario > 0 THEN
      
      SELECT COUNT(idmovinvexistencia) 
      FROM `mov_inv_existencias`
      WHERE idempresa = NEW.idempresa AND idproducto = NEW.idproduct
      INTO vInventariosEncontrados;
        
      IF NOT vInventariosEncontrados > 0 THEN            
        SET vInsertarInventarios = true; 
      END IF;
      
    ELSE
      
	  DELETE FROM `mov_inv_existencias` 
      WHERE idempresa = NEW.idempresa AND idproducto = NEW.idproduct;
      
    END IF;
            
      
    OPEN cur;
      ins_loop: LOOP
        FETCH cur INTO m_idsucursal;
          
          IF fin=1 THEN
            LEAVE ins_loop;
          END IF;
            
          IF vInsertarInventarios THEN
            
            SELECT idwarehouse 
            FROM cat_almacenes 
            WHERE idempresa = NEW.idempresa
            AND idsucursal = m_idsucursal 
            INTO vIdAlmacen;
            	
            INSERT INTO `mov_inv_existencias`(`idempresa`, `idsucursal`, 
              		`idinventario`, `idproducto`, `idalmacen`, `existencia`, 
              		`contados`, `idsucursalorigen`, `origen_registro`, `descargado`) 
            VALUES (NEW.idempresa, m_idsucursal, 0, NEW.idproduct, vIdAlmacen, 
                    0, 0, m_idsucursal,'WEB', 0);
            
          END IF;                      
    		
          INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
          VALUES (NEW.idempresa, m_idsucursal, NEW.idproduct, 'U', 'PRODUCTOS');
            
      END LOOP;
    CLOSE cur;
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `producto_delete` AFTER DELETE ON `cat_productos` FOR EACH ROW BEGIN

  DECLARE m_idsucursal INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
  	FROM cat_sucursales WHERE idempresa = OLD.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	-- IF OLD.origen_registro = 'WEB' THEN
    
  DELETE FROM mov_changes 
  WHERE idempresa = OLD.idempresa
  AND tabla = 'PRODUCTOS'
  AND identable = OLD.idproduct;
      
  -- Se eliminan todos los registros de la tabla mov_inv_existencias que
  -- correspondan a al producto eliminado de la empresa correpondiente
  DELETE FROM mov_inv_existencias
  WHERE idempresa = OLD.idempresa
  AND idproducto = OLD.idproduct;
	
  -- Para eliminar invenarios detalle de changes que no se han descargado.
  DELETE c 
  FROM mov_changes c 
  INNER JOIN mov_inv_detalle vd ON vd.idmovinventariodet = c.identable 
  WHERE c.idempresa = OLD.idempresa AND vd.idproducto = OLD.idproduct;
      
  OPEN cur;
    ins_loop: LOOP
      
      FETCH cur INTO m_idsucursal;
      
      IF fin=1 THEN
        LEAVE ins_loop;
      END IF;
            
      INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
      VALUES (OLD.idempresa, m_idsucursal, OLD.idproduct, 'D', 'PRODUCTOS');
      
    END LOOP;
  CLOSE cur;
	
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_proveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_proveedores` (
  `idprovider` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idsucursal` int(11) DEFAULT NULL,
  `idproveedor` int(11) DEFAULT NULL,
  `clave` varchar(20) NOT NULL,
  `espersonafisica` smallint(6) NOT NULL,
  `rfc` varchar(20) NOT NULL,
  `curp` varchar(20) NOT NULL,
  `nombrecorto` varchar(30) NOT NULL,
  `nombrecomercial` varchar(120) NOT NULL,
  `nombre` varchar(180) NOT NULL,
  `calle` varchar(30) NOT NULL,
  `noexterior` varchar(20) NOT NULL,
  `nointerior` varchar(20) NOT NULL,
  `cruzamientos` varchar(100) NOT NULL,
  `colonia` varchar(100) NOT NULL,
  `codigopostal` varchar(10) NOT NULL,
  `ciudad` varchar(30) NOT NULL,
  `municipio` varchar(30) NOT NULL,
  `estado` varchar(30) NOT NULL,
  `pais` varchar(30) NOT NULL,
  `referencia` varchar(150) NOT NULL,
  `telefono` varchar(30) NOT NULL,
  `fax` varchar(20) NOT NULL,
  `email` varchar(50) NOT NULL,
  `contacto` varchar(80) NOT NULL,
  `limitecredito` decimal(18,6) NOT NULL,
  `diasdecredito` smallint(6) NOT NULL,
  `fechaalta` date NOT NULL,
  `idsucursalrepl` int(11) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idprovider`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_proveedores_insert` AFTER INSERT ON `cat_proveedores` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

	IF NEW.origen_registro='WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idprovider, 'I', 'PROVEEDORES');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_proveedores_update` AFTER UPDATE ON `cat_proveedores` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

	IF NEW.origen_registro='WEB' THEN
      OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.idprovider, 'U', 'PROVEEDORES');
        END LOOP;
      CLOSE cur;
	END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_proveedores_delete` AFTER DELETE ON `cat_proveedores` FOR EACH ROW BEGIN

	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR 
      SELECT idsucursal 
      FROM cat_sucursales 
      WHERE idempresa = OLD.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
    
    DELETE FROM mov_changes 
    WHERE idempresa = OLD.idempresa AND tabla = 'PROVEEDORES' 
    AND identable = OLD.idprovider;
	
    OPEN cur;
      ins_loop: LOOP
        FETCH cur INTO m_idsucursal;
          IF fin=1 THEN
            LEAVE ins_loop;
          END IF;
          INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
        VALUES (OLD.idempresa, m_idsucursal, OLD.idprovider, 'D', 'PROVEEDORES');
      END LOOP;
    CLOSE cur;
	
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_regimenfiscal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_regimenfiscal` (
  `idregimenfiscal` bigint(20) NOT NULL,
  `clave_regimenfiscal` varchar(10) NOT NULL,
  `descripcion` varchar(120) NOT NULL,
  `aplica_persona_fisica` smallint(6) NOT NULL,
  `aplica_persona_moral` smallint(6) NOT NULL,
  PRIMARY KEY (`idregimenfiscal`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_sucursales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_sucursales` (
  `idbranchoffice` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `rfc` varchar(15) NOT NULL,
  `razon_social` varchar(120) NOT NULL,
  `direccion_fiscal` varchar(120) NOT NULL,
  `telefono1` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `activo` int(11) NOT NULL,
  PRIMARY KEY (`idbranchoffice`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `sucursal_insert` AFTER INSERT ON `cat_sucursales` FOR EACH ROW BEGIN
	DECLARE m_idproduct BIGINT;
    DECLARE m_idfamily BIGINT;
    DECLARE m_idbrand BIGINT;
	DECLARE m_idprovider BIGINT;
	DECLARE m_idconceptinventory BIGINT;
    DECLARE m_idcompoundproduct BIGINT;
	DECLARE m_idconceptoingegre BIGINT;

	DECLARE fin INT;
	DECLARE m_numsuc INT;
	DECLARE m_nombrealmacen VARCHAR(50);
	DECLARE m_comentarios VARCHAR(254);
	DECLARE m_nombreempresa VARCHAR(200);
    
    DECLARE cur_prod CURSOR FOR 
		SELECT idproduct FROM cat_productos WHERE idempresa = NEW.idempresa;
		
    DECLARE cur_fam CURSOR FOR 
		SELECT idfamily FROM cat_familias WHERE idempresa = NEW.idempresa;
		
    DECLARE cur_marc CURSOR FOR 
		SELECT idbrand FROM cat_marcas WHERE idempresa = NEW.idempresa;
		
    DECLARE cur_prov CURSOR FOR 
		SELECT idprovider FROM cat_proveedores WHERE idempresa = NEW.idempresa;
	
	-- CONCEPTOSINVENTARIOS
    DECLARE cur_conceptoinv CURSOR FOR 
		SELECT idinventoryconcept FROM cat_conceptosinventarios WHERE idempresa = NEW.idempresa OR idempresa=0;
		
	-- PRODUCTOSCOMPUESTOS
    DECLARE cur_prodcomp CURSOR FOR 
		SELECT idcompoundproduct FROM productoscompuestos WHERE idempresa = NEW.idempresa;
	
	-- CONCEPTOSINGRESOSEGRESOS
	DECLARE cur_conceptosingegre CURSOR FOR
		SELECT idconceptegressincome FROM conceptosingresosegresos WHERE idempresa = NEW.idempresa;
			   
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur_fam;
        ins_loop: LOOP
            FETCH cur_fam INTO m_idfamily;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idfamily, 'I', 'FAMILIAS');
        END LOOP;
    CLOSE cur_fam;
    
    SET fin=0;
    
    OPEN cur_marc;
        ins_loop: LOOP
            FETCH cur_marc INTO m_idbrand;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idbrand, 'I', 'MARCAS');
        END LOOP;
    CLOSE cur_marc;

	SET fin=0;

	OPEN cur_prod;
        ins_loop: LOOP
            FETCH cur_prod INTO m_idproduct;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idproduct, 'I', 'PRODUCTOS');
        END LOOP;
    CLOSE cur_prod;

	SET fin=0;

	OPEN cur_prov;
        ins_loop: LOOP
            FETCH cur_prov INTO m_idprovider;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idprovider, 'I', 'PROVEEDORES');
        END LOOP;
    CLOSE cur_prov;

	SET fin=0;

	OPEN cur_conceptoinv;
        ins_loop: LOOP
            FETCH cur_conceptoinv INTO m_idconceptinventory;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idconceptinventory, 'I', 'CONCEPTOSINVENTARIOS');
        END LOOP;
    CLOSE cur_conceptoinv;
    
    SET fin=0;
    
	OPEN cur_prodcomp;
        ins_loop: LOOP
            FETCH cur_prodcomp INTO m_idcompoundproduct;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idcompoundproduct, 'I', 'PRODUCTOSCOMPUESTOS');
        END LOOP;
    CLOSE cur_prodcomp;
	
	SET fin=0;
	
	OPEN cur_conceptosingegre;
		ins_loop: LOOP
			FETCH cur_conceptosingegre INTO m_idconceptoingegre;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, NEW.idbranchoffice, m_idconceptoingegre, 'I', 'CONCEPTOSINGRESOSEGRESOS');
		END LOOP;
	CLOSE cur_conceptosingegre;
	

	SELECT COUNT(*) FROM cat_sucursales WHERE idempresa=NEW.idempresa INTO m_numsuc;
	SELECT razon_social FROM cat_empresas WHERE idempresa=NEW.idempresa INTO m_nombreempresa;
	SET m_nombrealmacen = CONCAT('ALM_' ,NEW.rfc);
	SET m_comentarios = CONCAT('ALMACEN NUMERO ' , m_numsuc , ' DE LA EMPRESA ' , m_nombreempresa , 
		' CORRESPONDIENTE A LA SUCURSAL ' , NEW.razon_social);

	INSERT INTO cat_almacenes (
		idempresa
		,idsucursal
		,idalmacen
		,clave
		,nombre
		,comentarios
		,tipo_almacen
		,es_de_control_interno
		)
	VALUES (
		NEW.idempresa
		,NEW.idbranchoffice
		,0
		,'ALMACEN_WEB'
		,m_nombrealmacen
		,m_comentarios
		,'GENERAL'
		,0
		);
	
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_tasa_o_cuota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_tasa_o_cuota` (
  `idtasaimpuesto` bigint(20) NOT NULL,
  `tipo_rango` varchar(10) NOT NULL,
  `valor_minimo` decimal(18,6) DEFAULT NULL,
  `valor_maximo` decimal(18,6) NOT NULL,
  `impuesto` varchar(20) NOT NULL,
  `factor` varchar(20) NOT NULL,
  `traslado` smallint(6) NOT NULL,
  `retencion` smallint(6) NOT NULL,
  PRIMARY KEY (`idtasaimpuesto`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_tipocomprobante`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_tipocomprobante` (
  `idtipocomprobante` bigint(20) NOT NULL,
  `clave_tipocomprobante` varchar(10) NOT NULL,
  `descripcion` varchar(20) NOT NULL,
  `valor_maximo` decimal(18,6) NOT NULL,
  PRIMARY KEY (`idtipocomprobante`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_tipofactor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_tipofactor` (
  `idtipofactor` bigint(20) NOT NULL,
  `clave_tipofactor` varchar(10) NOT NULL,
  PRIMARY KEY (`idtipofactor`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_tiporelacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_tiporelacion` (
  `idtiporelacon` bigint(20) NOT NULL,
  `clave_tiporelacion` varchar(10) NOT NULL,
  `descripcion` varchar(120) NOT NULL,
  PRIMARY KEY (`idtiporelacon`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_tiposdepago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_tiposdepago` (
  `idpaymenttype` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(11) NOT NULL,
  `idtipopago` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `nombrecorto` varchar(20) NOT NULL,
  `nombre` varchar(60) NOT NULL,
  `estarjetadecredito` smallint(6) NOT NULL,
  `escredito` smallint(6) NOT NULL,
  `plazocredito` smallint(6) NOT NULL,
  `darcambio` smallint(6) NOT NULL,
  `visible` smallint(6) NOT NULL,
  `comision` decimal(18,6) NOT NULL,
  `tipodecambio` decimal(18,6) NOT NULL,
  `requierereferencia` smallint(6) NOT NULL,
  `prioridadvisualizacion` smallint(6) NOT NULL,
  `imagen` blob DEFAULT NULL,
  `fechaalta` date NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idpaymenttype`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_unidades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_unidades` (
  `idunidad` bigint(20) NOT NULL,
  `clave_unidad` varchar(10) DEFAULT NULL,
  `nombre` varchar(150) NOT NULL,
  `descripcion` varchar(254) DEFAULT NULL,
  `fecha_inicio_vigencia` date DEFAULT NULL,
  `fecha_fin_vigencia` date DEFAULT NULL,
  `simbolo` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`idunidad`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_unidadesmedida`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_unidadesmedida` (
  `idunit` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idunidadmedida` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  PRIMARY KEY (`idunit`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_usocfdi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_usocfdi` (
  `idusocfdi` bigint(20) NOT NULL,
  `clave_usocfdi` varchar(10) NOT NULL,
  `descripcion` varchar(120) NOT NULL,
  `aplica_persona_fisica` smallint(6) NOT NULL,
  `aplica_persona_moral` smallint(6) NOT NULL,
  PRIMARY KEY (`idusocfdi`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cat_usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_usuarios` (
  `iduser` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `nombre` varchar(50) NOT NULL,
  `usuario` varchar(20) NOT NULL,
  `pasword` varchar(20) NOT NULL,
  `idperfil` bigint(20) NOT NULL,
  `nopermitirborrarreg` smallint(6) NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`iduser`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuarios_insert` AFTER INSERT ON `cat_usuarios` FOR EACH ROW -- No es necesario insertar el mismo usuario para todas las sucursales
-- ya que desde la interfaz de la pagina web se establece a que
-- sucursal se insertara.
BEGIN
  IF NEW.origen_registro = 'WEB' THEN
    INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
    VALUES (NEW.idempresa, NEW.idsucursal, NEW.iduser, 'I', 'USUARIOS');
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuarios_update` AFTER UPDATE ON `cat_usuarios` FOR EACH ROW -- No es necesario actualizar el mismo usuario para todas las sucursales 
-- ya que desde la interfaz de la pagina web se establece a que 
-- sucursal se actualizara. 
BEGIN
  IF NEW.origen_registro = 'WEB' THEN
    INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
    VALUES (NEW.idempresa, NEW.idsucursal, NEW.iduser, 'U', 'USUARIOS');
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuarios_delete` AFTER DELETE ON `cat_usuarios` FOR EACH ROW -- No es necesario eliminar el mismo usuario para todas las sucursales 
-- ya que desde la interfaz de la pagina web se establece a que 
-- sucursal se eliminara. 
BEGIN

  DELETE FROM mov_changes 
  WHERE idempresa = OLD.idempresa AND tabla = 'USUARIOS' 
  AND identable = OLD.iduser;
  
  INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
  VALUES (OLD.idempresa, OLD.idsucursal, OLD.iduser, 'D', 'USUARIOS');

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_usuarios_02`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_usuarios_02` (
  `iduser` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `nombre` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish2_ci NOT NULL,
  `usuario` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci NOT NULL,
  `password` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci NOT NULL,
  `idperfil` int(11) NOT NULL,
  `nopermitirborrarreg` tinyint(1) NOT NULL,
  `origen_registro` tinyint(1) NOT NULL,
  PRIMARY KEY (`iduser`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuarios_02_AI` AFTER INSERT ON `cat_usuarios_02`
  FOR EACH ROW
BEGIN

DECLARE m_idsucursal INT;
DECLARE fin INT;
DECLARE cur CURSOR FOR 
  SELECT idbranchoffice 
  FROM cat_sucursales 
  WHERE idempresa = NEW.idempresa;

IF NEW.origen_registro = 1 THEN -- 1 significa WEB
  OPEN cur;
    ins_loop: LOOP
      FETCH cur INTO m_idsucursal;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;        
        INSERT INTO mov_changes (
          idempresa, idsucursal, identable, accion, tabla) 
        VALUES (
          NEW.idempresa, m_idsucursal, NEW.iduser, 'I', 'USUARIOS_02');
    END LOOP;
  CLOSE cur;
END IF;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuarios_02_AU` AFTER UPDATE ON `cat_usuarios_02`
  FOR EACH ROW
BEGIN

DECLARE m_idsucursal INT;
DECLARE fin INT;
DECLARE cur CURSOR FOR 
  SELECT idbranchoffice 
  FROM cat_sucursales 
  WHERE idempresa = NEW.idempresa;

IF NEW.origen_registro = 1 THEN -- 1 significa WEB
  OPEN cur;
    ins_loop: LOOP
      FETCH cur INTO m_idsucursal;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;        
        INSERT INTO mov_changes (
          idempresa, idsucursal, identable, accion, tabla) 
        VALUES (
          NEW.idempresa, m_idsucursal, NEW.iduser, 'U', 'USUARIOS_02');
    END LOOP;
  CLOSE cur;
END IF;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuarios_02_AD` AFTER DELETE ON `cat_usuarios_02`
  FOR EACH ROW
BEGIN

DECLARE m_idsucursal INT;
DECLARE fin INT;
DECLARE cur CURSOR FOR 
  SELECT idbranchoffice 
  FROM cat_sucursales 
  WHERE idempresa = OLD.idempresa;

DELETE FROM mov_changes 
WHERE idempresa = OLD.idempresa
AND tabla = 'USUARIOS_02' AND identable = OLD.iduser;

OPEN cur;
  ins_loop: LOOP
  
    FETCH cur INTO m_idsucursal;
    
    IF fin=1 THEN
      LEAVE ins_loop;
    END IF;        
    
    INSERT INTO mov_changes (
      idempresa, idsucursal, identable, accion, tabla) 
    VALUES (
      OLD.idempresa, m_idsucursal, OLD.iduser, 'U', 'USUARIOS');
      
  END LOOP;
CLOSE cur;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cat_usuariossucursales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_usuariossucursales` (
  `idusuariosucursal` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idusuario_web` bigint(20) NOT NULL,
  `idusuario_desk` bigint(20) NOT NULL,
  `activo` tinyint(1) NOT NULL,
  PRIMARY KEY (`idusuariosucursal`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cat_usuariossucursales_AI` AFTER INSERT ON `cat_usuariossucursales`
  FOR EACH ROW
BEGIN

INSERT INTO mov_changes(
    idempresa, idsucursal, identable, accion, tabla)
VALUES(NEW.idempresa, NEW.idsucursal, NEW.idusuariosucursal,
       'I', 'CAT_USUARIOSSUCURSALES');

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `categoria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categoria` (
  `idcategoria` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `descripcion` varchar(256) DEFAULT NULL,
  `condicion` tinyint(1) NOT NULL,
  PRIMARY KEY (`idcategoria`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `central_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `central_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) NOT NULL,
  `email` varchar(191) NOT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tenant_id` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `central_users_email_unique` (`email`),
  KEY `central_users_tenant_id_foreign` (`tenant_id`),
  CONSTRAINT `central_users_tenant_id_foreign` FOREIGN KEY (`tenant_id`) REFERENCES `tenants` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cfdi_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cfdi_detalle` (
  `idcfdidetalle` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idcfdi_detalle` bigint(20) NOT NULL,
  `idcfdi_general` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `clave_prodserv` varchar(10) NOT NULL,
  `prodserv` varchar(150) NOT NULL,
  `noidentificacion` varchar(100) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `clave_unidad` varchar(10) NOT NULL,
  `unidadmedida` varchar(150) NOT NULL,
  `descripcion` varchar(1000) NOT NULL,
  `valorunitario` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `clave_impuesto` varchar(10) NOT NULL,
  `impuesto` varchar(80) NOT NULL,
  `clave_tipofactor` varchar(10) NOT NULL,
  `tasa_factor` varchar(10) DEFAULT NULL,
  `tasa_impuesto` varchar(20) DEFAULT NULL,
  `tasa_tipo_rango` varchar(10) DEFAULT NULL,
  `tasa_valor_maximo` decimal(18,6) DEFAULT NULL,
  `tasa_traslado` smallint(6) DEFAULT NULL,
  `tasa_retencion` smallint(6) DEFAULT NULL,
  `importe_impuesto` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `web_idempresa` bigint(20) DEFAULT NULL,
  `web_idsucursal` bigint(20) DEFAULT NULL,
  `enviado_web` smallint(6) DEFAULT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `costopromedio` decimal(18,6) DEFAULT NULL,
  `info_cuentapredial` varchar(50) DEFAULT NULL,
  `clave_producto` varchar(30) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idcfdidetalle`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cfdi_detalle01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cfdi_detalle01` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `iddesk` bigint(20) NOT NULL,
  `idcfdi_general` bigint(20) NOT NULL,
  `idcfdi_general_desk` bigint(20) NOT NULL,
  `idproducto` bigint(20) DEFAULT NULL,
  `idfamilia` bigint(20) DEFAULT NULL,
  `idmarca` bigint(20) DEFAULT NULL,
  `idusuario` int(11) DEFAULT NULL,
  `idusuario_desk` int(11) DEFAULT NULL,
  `clave_prodserv` varchar(10) NOT NULL,
  `prodserv` varchar(150) NOT NULL,
  `noidentificacion` varchar(100) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `clave_unidad` varchar(10) NOT NULL,
  `unidadmedida` varchar(150) NOT NULL,
  `descripcion` varchar(1000) NOT NULL,
  `valorunitario` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `clave_impuesto` varchar(10) NOT NULL,
  `impuesto` varchar(80) NOT NULL,
  `clave_tipofactor` varchar(10) NOT NULL,
  `tasa_factor` varchar(10) DEFAULT NULL,
  `tasa_impuesto` varchar(20) DEFAULT NULL,
  `tasa_tipo_rango` varchar(10) DEFAULT NULL,
  `tasa_valor_maximo` decimal(18,6) DEFAULT NULL,
  `tasa_traslado` smallint(6) DEFAULT NULL,
  `tasa_retencion` smallint(6) DEFAULT NULL,
  `importe_impuesto` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `costopromedio` decimal(18,6) DEFAULT NULL,
  `info_cuentapredial` varchar(50) DEFAULT NULL,
  `clave_producto` varchar(30) DEFAULT NULL,
  `origen_registro` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`idweb`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `cfdi_detalle01_AI` AFTER INSERT ON `cfdi_detalle01` FOR EACH ROW BEGIN
    
    DECLARE vFECHAHORA_REGISTRO TIMESTAMP;
    DECLARE vUSUARIO VARCHAR(50);
    DECLARE vFROM_HOST VARCHAR(50);
    DECLARE vORIGEN_MOVIMIENTO VARCHAR(50);
    DECLARE vFOLIODOCUMENTO BIGINT;
    DECLARE vIDTURNO BIGINT;
    DECLARE vEXISTENCIA_ANTERIOR DECIMAL(18,6);
    DECLARE vEXISTENCIA_FINAL DECIMAL(18,6);
    DECLARE vSIGNO SMALLINT;
    DECLARE vMANEJAINVENTARIO SMALLINT;
    DECLARE vESPRODUCTOCOMPUESTO SMALLINT;
    DECLARE vfisico DECIMAL(18,6);
    DECLARE vfaltante DECIMAL(18,6);
    DECLARE vexcedente DECIMAL(18,6);
    
    DECLARE m_idcomponente BIGINT;
    DECLARE m_cantidad_componente DECIMAL(18,6);
    DECLARE m_manejainventario TINYINT;
    DECLARE m_costopromedio DECIMAL(18,6);
    DECLARE fin INT;
    
    DECLARE curComponentes CURSOR FOR 
      SELECT c.idcomponente, c.cantidad, p.manejainventario, p.costo_promedio_antesiva 
      FROM productoscompuestos AS c 
      INNER JOIN cat_productos AS p ON c.idcomponente = p.idproduct AND c.idempresa = p.idempresa
      WHERE c.idproducto = NEW.idproducto AND c.idempresa = NEW.idempresa;
    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
    
    
    SET fin = 0;
    SET vSIGNO = -1;
    SET vfisico=0;
    SET vfaltante=0;
    SET vexcedente=0;

    -- 01 BUSCAR LOS DATOS QUE ESTAN EN VENTASGENERAL
    SELECT v.fechahora_registro_desk, v.usuario, v.from_host,
      v.origen_movimiento, v.folio, v.idturno 
    FROM cfdi_general01 v
    WHERE v.idweb = new.idcfdi_general 
      -- AND v.idempresa=NEW.idempresa 
      -- AND v.idsucursal=NEW.idsucursal
    LIMIT 1
    INTO vFECHAHORA_REGISTRO, vUSUARIO, vFROM_HOST,
      vORIGEN_MOVIMIENTO, vFOLIODOCUMENTO, vIDTURNO;

    -- 02 cargar datos de producto
    SELECT p.manejainventario, p.esproductocompuesto   
    FROM cat_productos p
    WHERE p.idproduct = NEW.idproducto AND p.idempresa=NEW.idempresa LIMIT 1 
    INTO vMANEJAINVENTARIO, vESPRODUCTOCOMPUESTO;

    IF (vMANEJAINVENTARIO=1 AND vORIGEN_MOVIMIENTO = 'FACTURACION CFDI') THEN
      
      -- 02 cargar datos de existencias
      SELECT i.existencia 
      FROM mov_inv_existencias i
      WHERE i.idproducto = NEW.idproducto AND i.idempresa=NEW.idempresa 
      AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
      LIMIT 1
      INTO vEXISTENCIA_ANTERIOR;

      IF (vEXISTENCIA_ANTERIOR IS NOT NULL) THEN
      
      -- 03 calcular nueva existencia
      SET vEXISTENCIA_FINAL = vEXISTENCIA_ANTERIOR - NEW.cantidad; 
        
      INSERT INTO bitacora_existencias (idempresa,idsucursal,fechahora_registro,tipo,signo,usuario,
        from_host,origen_movimiento,origen_idmovimiento,origen_folio,idproducto, existencia_anterior, 
        movimiento_cantidad, existencia_final,idturno, idalmacen, comentarios,
        fisico,faltante,excedente,precio_unitario,importe,origen_registro,descargado)
      VALUES (NEW.idempresa, NEW.idsucursal, vFECHAHORA_REGISTRO,'SALIDA X VENTA',vSIGNO,vUSUARIO,
        vFROM_HOST,vORIGEN_MOVIMIENTO,NEW.idweb,vFOLIODOCUMENTO,NEW.idproducto,vEXISTENCIA_ANTERIOR,
        NEW.cantidad,vEXISTENCIA_FINAL,vIDTURNO,NULL,'',
        vfisico,vfaltante,vexcedente, NEW.costopromedio,(NEW.cantidad*NEW.costopromedio),'ESCRITORIO',1);

      -- actualizar las existencias
      UPDATE mov_inv_existencias i SET 
      i.existencia = vEXISTENCIA_FINAL
      WHERE i.idproducto = NEW.idproducto AND i.idempresa=NEW.idempresa AND i.idsucursal = NEW.idsucursal;
          
      END IF;
    END IF;
	  
    IF (vESPRODUCTOCOMPUESTO=1 AND vORIGEN_MOVIMIENTO = 'FACTURACION CFDI') THEN
    
      OPEN curComponentes;
        ins_loop: LOOP
          FETCH curComponentes INTO m_idcomponente, m_cantidad_componente, m_manejainventario, m_costopromedio;
          IF fin=1 THEN
            LEAVE ins_loop;
          END IF;
          
          IF (m_manejainventario = 1) THEN 
            SELECT i.existencia 
            FROM mov_inv_existencias i
            WHERE i.idproducto = m_idcomponente AND i.idempresa=NEW.idempresa 
            AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
            LIMIT 1
            INTO vEXISTENCIA_ANTERIOR;
            
            IF (vEXISTENCIA_ANTERIOR IS NOT NULL) THEN

              -- 03 calcular nueva existencia
              SET vEXISTENCIA_FINAL = vEXISTENCIA_ANTERIOR - (NEW.cantidad * m_cantidad_componente); 
              
              INSERT INTO bitacora_existencias (
                idempresa, idsucursal, fechahora_registro, tipo, signo, 
                usuario, from_host, origen_movimiento,origen_idmovimiento,
                origen_folio, idproducto, existencia_anterior, movimiento_cantidad, 
                existencia_final, idturno, idalmacen, comentarios, 
                fisico, faltante, excedente, precio_unitario,
                importe, origen_registro, descargado)
              VALUES (
                NEW.idempresa, NEW.idsucursal, vFECHAHORA_REGISTRO,'SALIDA X VENTA', 
                vSIGNO, vUSUARIO, vFROM_HOST, vORIGEN_MOVIMIENTO,
                NEW.idweb, vFOLIODOCUMENTO, m_idcomponente, vEXISTENCIA_ANTERIOR, 
                NEW.cantidad * m_cantidad_componente, vEXISTENCIA_FINAL, vIDTURNO, NULL,
                CONCAT('SALIÓ COMO COMPONENTE DE ', NEW.descripcion), vfisico, vfaltante, vexcedente, 
                m_costopromedio, (NEW.cantidad*m_cantidad_componente*m_costopromedio), 'ESCRITORIO', 1);            

              -- actualizar las existencias
              UPDATE mov_inv_existencias i SET i.existencia = vEXISTENCIA_FINAL
              WHERE i.idproducto = m_idcomponente AND i.idempresa=NEW.idempresa AND i.idsucursal = NEW.idsucursal;

            END IF; 
          END  IF;        
        END LOOP;
      CLOSE curComponentes;
      
    END IF;  

  END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `cfdi_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cfdi_general` (
  `idcfdigral` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idcfdi_general` bigint(20) NOT NULL,
  `idventageneral` bigint(20) NOT NULL,
  `versioncfd` varchar(10) NOT NULL,
  `serie` varchar(25) DEFAULT NULL,
  `folio` bigint(20) DEFAULT NULL,
  `fechahora` timestamp NULL DEFAULT NULL,
  `sello` varchar(800) DEFAULT NULL,
  `clave_formadepago` varchar(100) DEFAULT NULL,
  `formadepago` varchar(100) DEFAULT NULL,
  `nocertificado` varchar(40) NOT NULL,
  `certificado` varchar(800) NOT NULL,
  `condicionesdepago` varchar(254) NOT NULL,
  `subtotalantesdesc` decimal(18,6) NOT NULL,
  `porcentajedescto` decimal(18,6) NOT NULL,
  `importedescto` decimal(18,6) NOT NULL,
  `motivodescuento` varchar(250) NOT NULL,
  `clave_moneda` varchar(10) NOT NULL,
  `moneda` varchar(20) NOT NULL,
  `tipocambio` decimal(18,6) DEFAULT NULL,
  `subtotaldespuesdesc` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `importeletra` varchar(120) NOT NULL,
  `clave_tipocomprobante` varchar(10) NOT NULL,
  `tipocomprobante` varchar(20) NOT NULL,
  `clave_metododepago` varchar(10) NOT NULL,
  `metododepago` varchar(100) NOT NULL,
  `lugar_expedicion` varchar(10) NOT NULL,
  `confirmacion_pac` varchar(10) NOT NULL,
  `cancelada` smallint(6) NOT NULL,
  `emisoridempresa` bigint(20) NOT NULL,
  `emisorrfc` varchar(15) NOT NULL,
  `emisornombre` varchar(180) NOT NULL,
  `emisor_clave_regfiscal` varchar(10) NOT NULL,
  `emisorregimenfiscal` varchar(180) NOT NULL,
  `emisordomiciliofiscal` varchar(254) NOT NULL,
  `emisorreferencia` varchar(100) NOT NULL,
  `emisormunicipio` varchar(50) NOT NULL,
  `emisorestado` varchar(50) NOT NULL,
  `emisorpais` varchar(50) NOT NULL,
  `emisorcodigopostal` varchar(10) NOT NULL,
  `receptoridcliente` bigint(20) NOT NULL,
  `receptorrfc` varchar(15) NOT NULL,
  `receptornombre` varchar(180) NOT NULL,
  `receptordomiciliofiscal` varchar(254) NOT NULL,
  `receptorreferencia` varchar(254) NOT NULL,
  `receptormunicipio` varchar(50) NOT NULL,
  `receptorestado` varchar(50) NOT NULL,
  `receptorpais` varchar(50) NOT NULL,
  `receptorcodigopostal` varchar(10) NOT NULL,
  `recept_clave_residfiscal` varchar(10) NOT NULL,
  `recept_residenciafiscal` varchar(50) NOT NULL,
  `rec_numregidtrib` varchar(50) NOT NULL,
  `clave_usocfdi` varchar(10) NOT NULL,
  `usocfdi` varchar(120) NOT NULL,
  `totalimpuestoretenido` decimal(18,6) NOT NULL,
  `totalimpuestotrasladado` decimal(18,6) NOT NULL,
  `idusuariocancela` bigint(20) DEFAULT NULL,
  `nombreusuariocancela` varchar(30) DEFAULT NULL,
  `cfdi_version` varchar(10) NOT NULL,
  `cfdi_uuid` varchar(40) NOT NULL,
  `cfdi_fechatimbrado` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cfdi_fecha` date DEFAULT NULL,
  `cfdi_sellocfd` varchar(800) NOT NULL,
  `cfdi_nocertificadosat` varchar(40) NOT NULL,
  `cfdi_sellosat` varchar(800) NOT NULL,
  `cfdi_cadenaoriginal` blob DEFAULT NULL,
  `certificado_emisor` varchar(50) NOT NULL,
  `cfdi_cbb` blob DEFAULT NULL,
  `archivo_xml` blob DEFAULT NULL,
  `observaciones1` varchar(254) NOT NULL,
  `numerocuentapago` varchar(50) NOT NULL,
  `leyendaformapago` varchar(254) NOT NULL,
  `totalanticiposamortizacion` decimal(18,6) NOT NULL,
  `totalretencionesreguladas` decimal(18,6) NOT NULL,
  `totalnetoarecibir` decimal(18,6) NOT NULL,
  `comentarios` varchar(254) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `enviado_web` smallint(6) DEFAULT NULL,
  `fechahora_registro` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `usuario` varchar(50) DEFAULT NULL,
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `web_idempresa` bigint(20) DEFAULT NULL,
  `web_idsucursal` bigint(20) DEFAULT NULL,
  `observaciones2` varchar(254) DEFAULT NULL,
  `xml_cancelacion` blob DEFAULT NULL,
  `cfdis_relacionados` blob DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idcfdigral`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cfdi_general01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cfdi_general01` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idventageneral` bigint(20) NOT NULL,
  `idventageneral_desk` bigint(20) DEFAULT NULL,
  `serie` varchar(25) DEFAULT NULL,
  `folio` int(11) DEFAULT NULL,
  `fechahora` timestamp NULL DEFAULT NULL,
  `sello` varchar(800) DEFAULT NULL,
  `clave_formadepago` varchar(100) DEFAULT NULL,
  `formadepago` varchar(100) DEFAULT NULL,
  `nocertificado` varchar(40) NOT NULL,
  `certificado` varchar(800) NOT NULL,
  `condicionesdepago` varchar(254) NOT NULL,
  `subtotalantesdesc` decimal(18,6) NOT NULL,
  `porcentajedescto` decimal(18,6) NOT NULL,
  `importedescto` decimal(18,6) NOT NULL,
  `motivodescuento` varchar(250) NOT NULL,
  `clave_moneda` varchar(10) NOT NULL,
  `moneda` varchar(20) NOT NULL,
  `tipocambio` decimal(18,6) DEFAULT NULL,
  `subtotaldespuesdesc` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `importeletra` varchar(120) NOT NULL,
  `clave_tipocomprobante` varchar(10) NOT NULL,
  `tipocomprobante` varchar(20) NOT NULL,
  `clave_metododepago` varchar(10) NOT NULL,
  `metododepago` varchar(100) NOT NULL,
  `lugar_expedicion` varchar(10) NOT NULL,
  `confirmacion_pac` varchar(10) NOT NULL,
  `cancelada` smallint(6) NOT NULL,
  `emisorrfc` varchar(15) NOT NULL,
  `emisornombre` varchar(180) NOT NULL,
  `emisor_clave_regfiscal` varchar(10) NOT NULL,
  `emisorregimenfiscal` varchar(180) NOT NULL,
  `emisordomiciliofiscal` varchar(254) NOT NULL,
  `emisorreferencia` varchar(100) NOT NULL,
  `emisormunicipio` varchar(50) NOT NULL,
  `emisorestado` varchar(50) NOT NULL,
  `emisorpais` varchar(50) NOT NULL,
  `emisorcodigopostal` varchar(10) NOT NULL,
  `receptoridcliente` bigint(20) NOT NULL,
  `receptorrfc` varchar(15) NOT NULL,
  `receptornombre` varchar(180) NOT NULL,
  `receptordomiciliofiscal` varchar(254) NOT NULL,
  `receptorreferencia` varchar(254) NOT NULL,
  `receptormunicipio` varchar(50) NOT NULL,
  `receptorestado` varchar(50) NOT NULL,
  `receptorpais` varchar(50) NOT NULL,
  `receptorcodigopostal` varchar(10) NOT NULL,
  `recept_clave_residfiscal` varchar(10) NOT NULL,
  `recept_residenciafiscal` varchar(50) NOT NULL,
  `rec_numregidtrib` varchar(50) NOT NULL,
  `clave_usocfdi` varchar(10) NOT NULL,
  `usocfdi` varchar(120) NOT NULL,
  `totalimpuestoretenido` decimal(18,6) NOT NULL,
  `totalimpuestotrasladado` decimal(18,6) NOT NULL,
  `idusuariocancela` bigint(20) DEFAULT NULL,
  `idusuariocancela_desk` bigint(20) DEFAULT NULL,
  `nombreusuariocancela` varchar(30) DEFAULT NULL,
  `cfdi_version` varchar(10) NOT NULL,
  `cfdi_uuid` varchar(40) NOT NULL,
  `cfdi_fechatimbrado` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cfdi_sellocfd` varchar(800) NOT NULL,
  `cfdi_nocertificadosat` varchar(40) NOT NULL,
  `cfdi_sellosat` varchar(800) NOT NULL,
  `cfdi_cadenaoriginal` varchar(2000) NOT NULL,
  `certificado_emisor` varchar(50) NOT NULL,
  `ruta_archivo_xml` varchar(260) DEFAULT NULL,
  `observaciones1` varchar(254) NOT NULL,
  `numerocuentapago` varchar(50) NOT NULL,
  `leyendaformapago` varchar(254) NOT NULL,
  `totalanticiposamortizacion` decimal(18,6) NOT NULL,
  `totalretencionesreguladas` decimal(18,6) NOT NULL,
  `totalnetoarecibir` decimal(18,6) NOT NULL,
  `comentarios` varchar(254) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `fechahora_registro_desk` timestamp NULL DEFAULT NULL,
  `idusuario` int(11) DEFAULT NULL,
  `idusuario_desk` int(11) DEFAULT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `observaciones2` varchar(254) DEFAULT NULL,
  `ruta_xml_cancelacion` varchar(260) DEFAULT NULL,
  `cfdis_relacionados` varchar(200) DEFAULT NULL,
  `origen_registro` tinyint(4) DEFAULT NULL,
  `fecha_cancelacion` timestamp NULL DEFAULT NULL,
  `info_cancelacion` varchar(254) DEFAULT NULL,
  PRIMARY KEY (`idweb`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `clientes_direcciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clientes_direcciones` (
  `iddirectionclient` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `iddireccioncliente` bigint(20) NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `tipodireccion` varchar(10) NOT NULL,
  `calle` varchar(100) NOT NULL,
  `noexterior` varchar(100) NOT NULL,
  `nointerior` varchar(50) DEFAULT NULL,
  `cruzamientos` varchar(100) DEFAULT NULL,
  `colonia` varchar(100) NOT NULL,
  `referencia` varchar(254) DEFAULT NULL,
  `localidad` varchar(50) NOT NULL,
  `municipio` varchar(50) NOT NULL,
  `estado` varchar(50) NOT NULL,
  `pais` varchar(50) NOT NULL,
  `codigopostal` varchar(30) NOT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `contacto` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`iddirectionclient`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `clientes_direcciones_insert` AFTER INSERT ON `clientes_direcciones`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.iddirectionclient, 'I', 'CLIENTES_DIRECCIONES');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `clientes_direcciones_update` AFTER UPDATE ON `clientes_direcciones`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = NEW.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (NEW.idempresa, m_idsucursal, NEW.iddirectionclient, 'U', 'CLIENTES_DIRECCIONES');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `clientes_direcciones_delete` AFTER DELETE ON `clientes_direcciones`
  FOR EACH ROW
BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales WHERE idempresa = OLD.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (OLD.idempresa, m_idsucursal, OLD.iddirectionclient, 'D', 'CLIENTES_DIRECCIONES');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `componentes_existenciaproporcional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `componentes_existenciaproporcional` (
  `idcomponenteexistencia` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idcompoundproduct` bigint(20) DEFAULT NULL,
  `idcomponente` bigint(20) NOT NULL,
  `idproductopadre` bigint(20) NOT NULL,
  `existencia_proporcional` decimal(18,6) NOT NULL DEFAULT 0.000000,
  PRIMARY KEY (`idcomponenteexistencia`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `comprasdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprasdetalle` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `iddesk` bigint(20) DEFAULT NULL,
  `idcomprageneral` bigint(20) DEFAULT NULL,
  `idproducto` bigint(20) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `fechacaducidad` date NOT NULL,
  `precio` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `fechahoradocumento` timestamp NULL DEFAULT NULL,
  `idfamilia` bigint(20) DEFAULT NULL,
  `clave_familia` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `idmarca` bigint(20) DEFAULT NULL,
  `clave_marca` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `idusuario` bigint(20) DEFAULT NULL,
  `usuario` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `idalmacen` bigint(20) DEFAULT NULL,
  `almacen` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `clave` varchar(30) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `descripcion` varchar(254) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `traslado_iva_tipo_factor` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `traslado_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_iva_importe` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_tipo_factor` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `traslado_ieps_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_importe` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idweb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `comprasgeneral`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comprasgeneral` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` bigint(20) DEFAULT NULL,
  `idsucursal` bigint(20) DEFAULT NULL,
  `origen_registro` smallint(6) DEFAULT NULL,
  `idstatus` tinyint(4) NOT NULL,
  `fechacomprageneral` date NOT NULL,
  `idproveedor` bigint(20) NOT NULL,
  `idtipodocumento` int(11) NOT NULL,
  `numerodocumento` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `fechadocumento` date NOT NULL,
  `horadocumento` varchar(8) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `pagado` smallint(6) NOT NULL,
  `idtipopago` bigint(20) NOT NULL,
  `referencia` varchar(80) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `totaldocumentocompra` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `totalcompra` decimal(18,6) NOT NULL,
  `comentarios` varchar(400) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `numeromovimiento` varchar(30) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `abono` decimal(18,6) NOT NULL,
  `saldo` decimal(18,6) NOT NULL,
  `folio` bigint(20) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `fechahora_registro` timestamp NULL DEFAULT NULL,
  `usuario` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `from_host` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `origen_movimiento` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `traslado_ieps_importe` decimal(18,6) DEFAULT NULL,
  `traslado_iva_importe` decimal(18,6) DEFAULT NULL,
  `retencion_iva_importe` decimal(18,6) DEFAULT NULL,
  `retencion_isr_importe` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idweb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `conceptosingresosegresos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conceptosingresosegresos` (
  `idconceptegressincome` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `concepto` varchar(80) NOT NULL,
  `comentario` varchar(150) NOT NULL,
  `egresoingreso` smallint(6) NOT NULL,
  `origen_registro` tinyint(1) NOT NULL,
  PRIMARY KEY (`idconceptegressincome`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `conceptosingresosegresos_insert` AFTER INSERT ON `conceptosingresosegresos` FOR EACH ROW BEGIN
  DECLARE m_idbranchoffice INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
    FROM cat_sucursales WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  IF NEW.origen_registro = 1 THEN -- 1 => 'WEB', 0 => 'ESCRITORIO'
    OPEN cur;
      ins_loop: LOOP
        FETCH cur INTO m_idbranchoffice;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;
        
        INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
        VALUES (NEW.idempresa, m_idbranchoffice, NEW.idconceptegressincome, 'I', 'CONCEPTOSINGRESOSEGRESOS');
      END LOOP;
    CLOSE cur;
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `conceptosingresosegresos_update` AFTER UPDATE ON `conceptosingresosegresos` FOR EACH ROW BEGIN
  DECLARE m_idsucursal BIGINT;
  DECLARE fin INT;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
    FROM cat_sucursales WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  IF NEW.origen_registro = 1 THEN -- 0 => ESCRITORIO | 1 => WEB
    OPEN cur;
      ins_loop: LOOP
      
        FETCH cur INTO m_idsucursal;
        
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;                   
            	
        INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
        VALUES (NEW.idempresa, m_idsucursal, NEW.idconceptegressincome, 'U', 'CONCEPTOSINGRESOSEGRESOS');
                    
        END LOOP;
    CLOSE cur;  
  END IF;    
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `conceptosingresosegresos_delete` AFTER DELETE ON `conceptosingresosegresos` FOR EACH ROW BEGIN
  DECLARE m_idsucursal INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
  	FROM cat_sucursales WHERE idempresa = OLD.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	
  DELETE FROM mov_changes 
  WHERE tabla='CONCEPTOSINGRESOSEGRESOS' 
  AND idempresa = OLD.idempresa
  AND identable = OLD.idconceptegressincome;

  OPEN cur;
    ins_loop: LOOP
      
      FETCH cur INTO m_idsucursal;
      
      IF fin=1 THEN
                LEAVE ins_loop;
      END IF;
      
      INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
      VALUES (OLD.idempresa, m_idsucursal, OLD.idconceptegressincome, 'D', 'CONCEPTOSINGRESOSEGRESOS');
      
    END LOOP;
  CLOSE cur;
	
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `config` (
  `idempresa` bigint(20) NOT NULL COMMENT 'ID de la empresa/tenant - Llave primaria',
  `afectainventarios` tinyint(4) DEFAULT NULL COMMENT 'Configuración para afectar inventarios (0=No, 1=Sí)',
  `habilitarpredo` tinyint(4) DEFAULT NULL COMMENT 'Configuración para habilitar precio predeterminado (0=No, 1=Sí)',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idempresa`),
  KEY `idx_config_idempresa` (`idempresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cortes_turnos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cortes_turnos` (
  `idturn` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idturno` bigint(20) NOT NULL,
  `idusuario` int(11) NOT NULL,
  `idcaja_apertura` int(11) NOT NULL,
  `fechahora_apertura` timestamp NULL DEFAULT NULL,
  `importe_caja_inicial` decimal(18,6) NOT NULL,
  `turno_cerrado` smallint(6) NOT NULL,
  `idcaja_cierre` int(11) DEFAULT NULL,
  `fechahora_cierre` timestamp NULL DEFAULT NULL,
  `ing_notasrem` decimal(18,6) DEFAULT NULL,
  `ing_facturas` decimal(18,6) DEFAULT NULL,
  `ing_cobranza_cxc` decimal(18,6) DEFAULT NULL,
  `ing_servicios` decimal(18,6) DEFAULT NULL,
  `ing_apartados` decimal(18,6) DEFAULT NULL,
  `ing_reparaciones` decimal(18,6) DEFAULT NULL,
  `ing_encargos` decimal(18,6) DEFAULT NULL,
  `ing_refrendos` decimal(18,6) DEFAULT NULL,
  `ing_abonos_capital` decimal(18,6) DEFAULT NULL,
  `ing_empenios` decimal(18,6) DEFAULT NULL,
  `ing_taller` decimal(18,6) DEFAULT NULL,
  `ing_otros_ingresos` decimal(18,6) DEFAULT NULL,
  `egr_otros_egresos` decimal(18,6) DEFAULT NULL,
  `egr_compras` decimal(18,6) DEFAULT NULL,
  `total_billetes` decimal(18,6) DEFAULT NULL,
  `total_monedas` decimal(18,6) DEFAULT NULL,
  `total_tarjetas_credito` decimal(18,6) DEFAULT NULL,
  `total_tarjetas_debito` decimal(18,6) DEFAULT NULL,
  `total_corte` decimal(18,6) DEFAULT NULL,
  `total_corte_mas_cajai` decimal(18,6) DEFAULT NULL,
  `gastos_fijos` decimal(18,6) DEFAULT NULL,
  `gastos_pagos_proveedores` decimal(18,6) DEFAULT NULL,
  `gastos_consumos` decimal(18,6) DEFAULT NULL,
  `gastos_cocina` decimal(18,6) DEFAULT NULL,
  `gastos_otros` decimal(18,6) DEFAULT NULL,
  `origen_registro` tinyint(1) DEFAULT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `transferencia_electronica` decimal(18,6) DEFAULT NULL,
  `vales_electronicos` decimal(18,6) DEFAULT NULL,
  `cheques` decimal(18,6) DEFAULT NULL,
  `otros` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idturn`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cortes_turnos_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cortes_turnos_detalle` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idturno` bigint(20) NOT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `tipo` smallint(6) NOT NULL,
  `descripcion` varchar(60) CHARACTER SET utf8 COLLATE utf8_spanish2_ci NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `origen_registro` tinyint(4) NOT NULL,
  PRIMARY KEY (`idweb`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `cortesdecaja`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cortesdecaja` (
  `idcutbox` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(11) NOT NULL,
  `idcortedecaja` bigint(20) NOT NULL,
  `fechacortedecaja` date NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `turnocorte` varchar(50) NOT NULL,
  `comentarios` varchar(240) NOT NULL,
  `totalbilletes1000` int(11) NOT NULL,
  `totalbilletes500` int(11) NOT NULL,
  `totalbilletes200` int(11) NOT NULL,
  `totalbilletes100` int(11) NOT NULL,
  `totalbilletes50` int(11) NOT NULL,
  `totalbilletes20` int(11) NOT NULL,
  `totalmonedas20` int(11) NOT NULL,
  `totalmonedas10` int(11) NOT NULL,
  `totalmonedas5` int(11) NOT NULL,
  `totalmonedas2` int(11) NOT NULL,
  `totalmonedas1` int(11) NOT NULL,
  `totalmonedas50c` int(11) NOT NULL,
  `totalmonedas20c` int(11) NOT NULL,
  `totalmonedas10c` int(11) NOT NULL,
  `cantidadinicialcaja` decimal(18,6) NOT NULL,
  `importetotalbilletes` decimal(18,6) NOT NULL,
  `importetotalmonedas` decimal(18,6) NOT NULL,
  `importetotalefectivo` decimal(18,6) NOT NULL,
  `totalturnocorte` decimal(18,6) NOT NULL,
  `importebilletes1000` decimal(18,6) NOT NULL,
  `importebilletes500` decimal(18,6) NOT NULL,
  `importebilletes200` decimal(18,6) NOT NULL,
  `importebilletes100` decimal(18,6) NOT NULL,
  `importebilletes50` decimal(18,6) NOT NULL,
  `importebilletes20` decimal(18,6) NOT NULL,
  `importemonedas20` decimal(18,6) NOT NULL,
  `importemonedas10` decimal(18,6) NOT NULL,
  `importemonedas5` decimal(18,6) NOT NULL,
  `importemonedas2` decimal(18,6) NOT NULL,
  `importemonedas1` decimal(18,6) NOT NULL,
  `importemonedas50c` decimal(18,6) NOT NULL,
  `importemonedas20c` decimal(18,6) NOT NULL,
  `importemonedas10c` decimal(18,6) NOT NULL,
  `importetarjetascredito` decimal(18,6) NOT NULL,
  `importetarjetasdebito` decimal(18,6) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `origen_registro` tinyint(1) DEFAULT NULL,
  `transferencia_electronica` decimal(18,6) DEFAULT NULL,
  `vales_electronicos` decimal(18,6) DEFAULT NULL,
  `cheques` decimal(18,6) DEFAULT NULL,
  `otros` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idcutbox`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `detalle_ingreso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `detalle_ingreso` (
  `iddetalle_ingreso` int(11) NOT NULL AUTO_INCREMENT,
  `idingreso` int(11) NOT NULL,
  `idarticulo` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_compra` decimal(11,2) NOT NULL,
  `precio_venta` decimal(11,2) NOT NULL,
  PRIMARY KEY (`iddetalle_ingreso`) USING BTREE,
  KEY `fk_detalle_ingreso_idx` (`idingreso`) USING BTREE,
  KEY `fk_detalle_ingreso_articulo_idx` (`idarticulo`) USING BTREE,
  CONSTRAINT `fk_detalle_ingreso` FOREIGN KEY (`idingreso`) REFERENCES `ingreso` (`idingreso`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_detalle_ingreso_articulo` FOREIGN KEY (`idarticulo`) REFERENCES `articulo` (`idarticulo`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `tr_updStockIngreso` AFTER INSERT ON `detalle_ingreso`
  FOR EACH ROW
BEGIN
	UPDATE articulo SET stock = stock + NEW.cantidad 
	WHERE articulo.idarticulo = NEW.idarticulo;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `detalle_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `detalle_venta` (
  `iddetalle_venta` int(11) NOT NULL AUTO_INCREMENT,
  `idventa` int(11) NOT NULL,
  `idarticulo` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_venta` decimal(11,2) NOT NULL,
  `descuento` decimal(11,2) NOT NULL,
  PRIMARY KEY (`iddetalle_venta`) USING BTREE,
  KEY `fk_detalle_venta_articulo_idx` (`idarticulo`) USING BTREE,
  KEY `fk_detalle_venta_idx` (`idventa`) USING BTREE,
  CONSTRAINT `fk_detalle_venta` FOREIGN KEY (`idventa`) REFERENCES `venta` (`idventa`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_detalle_venta_articulo` FOREIGN KEY (`idarticulo`) REFERENCES `articulo` (`idarticulo`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `tr_updStockVenta` AFTER INSERT ON `detalle_venta`
  FOR EACH ROW
BEGIN
	UPDATE articulo SET stock = stock - NEW.cantidad 
	WHERE articulo.idarticulo = NEW.idarticulo;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `documentosingresosegresos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentosingresosegresos` (
  `iddocument` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `iddocumento` bigint(20) NOT NULL,
  `fechadocumento` timestamp NULL DEFAULT NULL,
  `horadocumento` varchar(11) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `idconcepto` bigint(20) NOT NULL,
  `importedocumento` decimal(18,6) NOT NULL,
  `referencia` varchar(250) NOT NULL,
  `quien_recibe` varchar(250) NOT NULL,
  `quien_entrega` varchar(250) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `estatus` smallint(6) DEFAULT NULL,
  `origen_registro` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`iddocument`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `domains` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `tenant_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domains_domain_unique` (`domain`),
  KEY `domains_tenant_id_foreign` (`tenant_id`),
  CONSTRAINT `domains_tenant_id_foreign` FOREIGN KEY (`tenant_id`) REFERENCES `tenants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `emp_kilatajes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emp_kilatajes` (
  `idkilatage` int(11) NOT NULL AUTO_INCREMENT,
  `idkilataje` int(11) NOT NULL,
  `kilataje` varchar(20) NOT NULL,
  PRIMARY KEY (`idkilatage`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ing_ventasdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ing_ventasdetalle` (
  `idsaledetail` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idventageneral` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `idfamilia` bigint(20) DEFAULT 1,
  `clave` varchar(30) CHARACTER SET latin1 COLLATE latin1_spanish_ci NOT NULL,
  `descripcion` varchar(1000) DEFAULT NULL,
  `precio` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `fechahora` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `precionormal` decimal(18,6) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `cantidaddevueltaxnc` decimal(18,6) DEFAULT NULL,
  `descripcionadicional` blob DEFAULT NULL,
  `costopromedio` decimal(18,6) DEFAULT NULL,
  `costo_venta` decimal(18,6) NOT NULL,
  `utilidad` decimal(18,6) NOT NULL,
  `clave_prodserv` varchar(10) DEFAULT NULL,
  `clave_unidadmedida` varchar(10) DEFAULT NULL,
  `unidadmedida` varchar(30) DEFAULT NULL,
  `clave_impuesto` varchar(10) DEFAULT NULL,
  `impuesto` varchar(10) DEFAULT NULL,
  `tasa_factor` varchar(20) DEFAULT NULL,
  `clave_tipofactor` varchar(10) DEFAULT NULL,
  `tasa_impuesto` varchar(20) DEFAULT NULL,
  `tasa_tipo_rango` varchar(20) DEFAULT NULL,
  `tasa_valor_maximo` decimal(18,6) DEFAULT NULL,
  `tasa_traslado` smallint(6) DEFAULT NULL,
  `tasa_retencion` smallint(6) DEFAULT NULL,
  `importe_impuesto` decimal(18,6) DEFAULT NULL,
  `ccb_frombascula` varchar(30) NOT NULL,
  PRIMARY KEY (`idsaledetail`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ing_ventasdetalle01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ing_ventasdetalle01` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idventageneral` bigint(20) NOT NULL,
  `idventageneral_desk` bigint(20) DEFAULT NULL,
  `idusuario` int(11) DEFAULT NULL,
  `idusuario_desk` int(11) DEFAULT NULL,
  `idproducto` bigint(20) DEFAULT NULL,
  `idfamilia` bigint(20) DEFAULT NULL,
  `idmarca` bigint(20) DEFAULT NULL,
  `precio` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `precionormal` decimal(18,6) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `cantidaddevueltaxnc` decimal(18,6) DEFAULT NULL,
  `descripcionadicional` varchar(1000) DEFAULT NULL,
  `clave_prodserv` varchar(10) DEFAULT NULL,
  `noidentificacion` varchar(100) DEFAULT NULL,
  `clave_unidadmedida` varchar(10) DEFAULT NULL,
  `unidadmedida` varchar(30) DEFAULT NULL,
  `descripcion` varchar(1000) DEFAULT NULL,
  `clave_impuesto` varchar(10) DEFAULT NULL,
  `impuesto` varchar(10) DEFAULT NULL,
  `tasa_factor` varchar(20) DEFAULT NULL,
  `clave_tipofactor` varchar(10) DEFAULT NULL,
  `tasa_impuesto` varchar(20) DEFAULT NULL,
  `tasa_tipo_rango` varchar(20) DEFAULT NULL,
  `tasa_valor_maximo` decimal(18,6) DEFAULT NULL,
  `tasa_traslado` smallint(6) DEFAULT NULL,
  `tasa_retencion` smallint(6) DEFAULT NULL,
  `importe_impuesto` decimal(18,6) DEFAULT NULL,
  `ccb_frombascula` varchar(30) DEFAULT NULL,
  `origen_registro` tinyint(1) DEFAULT NULL,
  `costo_venta` decimal(18,6) DEFAULT NULL,
  `utilidad` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idweb`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ing_ventasgeneral`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ing_ventasgeneral` (
  `idgeneralsale` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idventageneral` bigint(20) NOT NULL,
  `idstatus` int(11) NOT NULL,
  `fechaventa` date NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `cliente` varchar(180) DEFAULT NULL,
  `idtipodocumento` int(11) NOT NULL,
  `numerodocumento` varchar(20) NOT NULL,
  `fechadocumento` date NOT NULL,
  `horadocumento` varchar(8) NOT NULL,
  `pagado` smallint(6) NOT NULL,
  `idtipopago` bigint(20) NOT NULL,
  `tipopago` varchar(30) DEFAULT NULL,
  `comentarios` blob DEFAULT NULL,
  `idusuario` bigint(20) NOT NULL,
  `totalventa` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `totalapagar` decimal(18,6) NOT NULL,
  `totalentregado` decimal(18,6) NOT NULL,
  `cambioaentregar` decimal(18,6) NOT NULL,
  `comision` decimal(18,6) NOT NULL DEFAULT -1.000000,
  `total_retencion_iva` decimal(18,6) NOT NULL,
  `total_retencion_isr` decimal(18,6) NOT NULL,
  `observaciones1` varchar(50) NOT NULL,
  `observaciones2` varchar(50) NOT NULL,
  `fechahoradocumento` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `foliodocumento` bigint(20) DEFAULT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idpedidogeneral` bigint(20) DEFAULT NULL,
  `total_cobrado` decimal(18,6) DEFAULT NULL,
  `total_xcobrar` decimal(18,6) DEFAULT NULL,
  `fechahora_registro` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `usuario` varchar(50) DEFAULT NULL,
  `costototal` decimal(18,6) DEFAULT NULL,
  `utilidadtotal` decimal(18,6) DEFAULT NULL,
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `descargado` smallint(6) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`idgeneralsale`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ing_ventasgeneral01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ing_ventasgeneral01` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idstatus` smallint(6) DEFAULT NULL,
  `fechaventa` date NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `idcliente_desk` bigint(20) DEFAULT NULL,
  `cliente` varchar(50) DEFAULT NULL,
  `idtipodocumento` int(11) DEFAULT NULL,
  `tipodocumento` varchar(80) NOT NULL,
  `numerodocumento` int(11) NOT NULL,
  `fechahoradocumento` timestamp NULL DEFAULT NULL,
  `pagado` tinyint(1) NOT NULL,
  `idtipopago` bigint(20) DEFAULT NULL,
  `idtipopago_desk` bigint(20) DEFAULT NULL,
  `tipopago` varchar(20) NOT NULL,
  `referencia` varchar(80) NOT NULL,
  `comentarios` varchar(300) NOT NULL,
  `idusuario` bigint(20) DEFAULT NULL,
  `idusuario_desk` bigint(20) DEFAULT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `totalventa` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `totalapagar` decimal(18,6) NOT NULL,
  `totalentregado` decimal(18,6) NOT NULL,
  `cambioaentregar` decimal(18,6) NOT NULL,
  `comision` decimal(18,6) NOT NULL DEFAULT -1.000000,
  `total_retencion_iva` decimal(18,6) NOT NULL,
  `total_retencion_isr` decimal(18,6) NOT NULL,
  `observaciones1` varchar(50) NOT NULL,
  `observaciones2` varchar(50) NOT NULL,
  `foliodocumento` bigint(20) DEFAULT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `idpedidogeneral` bigint(20) DEFAULT NULL,
  `idpedidogeneral_desk` bigint(20) DEFAULT NULL,
  `total_cobrado` decimal(18,6) DEFAULT NULL,
  `total_xcobrar` decimal(18,6) DEFAULT NULL,
  `fechahora_registro` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `costototal` decimal(18,6) DEFAULT 0.000000,
  `utilidadtotal` decimal(18,6) DEFAULT 0.000000,
  `origen_registro` tinyint(1) DEFAULT NULL,
  `total_retencion_regulada` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idweb`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ingreso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ingreso` (
  `idingreso` int(11) NOT NULL AUTO_INCREMENT,
  `idproveedor` int(11) NOT NULL,
  `tipo_comprobante` varchar(20) NOT NULL,
  `serie_comprobante` varchar(7) DEFAULT NULL,
  `num_comprobante` varchar(10) NOT NULL,
  `fecha_hora` datetime NOT NULL,
  `impuesto` decimal(4,2) NOT NULL,
  `estado` varchar(20) NOT NULL,
  PRIMARY KEY (`idingreso`) USING BTREE,
  KEY `fk_ingreso_persona_idx` (`idproveedor`) USING BTREE,
  CONSTRAINT `fk_ingreso_persona` FOREIGN KEY (`idproveedor`) REFERENCES `persona` (`idpersona`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `menuopciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `menuopciones` (
  `idmenuopcion` int(11) NOT NULL AUTO_INCREMENT,
  `idmenu` int(11) NOT NULL,
  `descripcion` varchar(120) NOT NULL,
  `visible` smallint(6) NOT NULL,
  PRIMARY KEY (`idmenuopcion`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `menus` (
  `idmenu` int(11) NOT NULL,
  `descripcion` varchar(50) NOT NULL,
  `visible` smallint(6) NOT NULL,
  PRIMARY KEY (`idmenu`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `mov_catalogos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mov_catalogos` (
  `idmovimiento` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `tabla` varchar(50) NOT NULL,
  `actualizado` smallint(6) NOT NULL,
  `fecha_subida` timestamp NULL DEFAULT NULL,
  `fecha_aplicacion_sucursal` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idmovimiento`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `mov_changes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mov_changes` (
  `idchange` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `identable` bigint(20) NOT NULL,
  `accion` varchar(10) NOT NULL,
  `tabla` varchar(50) NOT NULL,
  `fecha_hora` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`idchange`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `mov_inv_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mov_inv_detalle` (
  `idmovinventariodet` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idmovinventariodet_desk` bigint(20) DEFAULT NULL,
  `idinventariofisicodet` bigint(20) DEFAULT NULL,
  `idinventariofisicogral` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `idfamilia` bigint(20) DEFAULT NULL,
  `idmarca` bigint(20) DEFAULT NULL,
  `justificacion` varchar(120) NOT NULL,
  `costoinventario` decimal(18,6) NOT NULL,
  `idsucursal_local` int(11) NOT NULL,
  `cantidad` decimal(18,6) DEFAULT NULL,
  `folio_lote_entrada` bigint(20) DEFAULT NULL,
  `lote_entrada` varchar(20) DEFAULT NULL,
  `existencia` decimal(18,6) DEFAULT NULL,
  `fisico` decimal(18,6) DEFAULT NULL,
  `faltante` decimal(18,6) DEFAULT NULL,
  `excedente` decimal(18,6) DEFAULT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `idsucursal_web_origen` int(11) DEFAULT NULL,
  `idsucursal_web_destino` int(11) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  `descargado` smallint(1) DEFAULT NULL,
  `nombre_corto_producto` varchar(30) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha_hora` timestamp NULL DEFAULT NULL,
  `clave_familia` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `clave_marca` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `idconceptoinventario` int(11) DEFAULT NULL,
  PRIMARY KEY (`idmovinventariodet`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `movinvdetalle_insert_before` BEFORE INSERT ON `mov_inv_detalle` FOR EACH ROW BEGIN

  DECLARE vIdMovInvGral INT;
  DECLARE vFechaHora TIMESTAMP;
  DECLARE vIdConceptoInventario INT;
  
  IF NEW.origen_registro = 'ESCRITORIO' THEN
    
    SELECT idmovinventariogral, fechahora_registro, idconceptoinventario
    FROM mov_inv_general 
	WHERE idmovinventariogral_desk = NEW.idinventariofisicogral 
	AND idempresa = NEW.idempresa
	AND idsucursal = NEW.idsucursal
	INTO vIdMovInvGral, vFechaHora, vIdConceptoInventario;

    SET NEW.idinventariofisicogral = vIdMovInvGral;
    SET NEW.fecha_hora = vFechaHora;
    SET NEW.idconceptoinventario = vIdConceptoInventario;
    
  END IF;
  
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `mov_inv_detalle_insert` AFTER INSERT ON `mov_inv_detalle` FOR EACH ROW BEGIN

DECLARE vIdEmpresa BIGINT;
DECLARE vIdSucursal BIGINT;
DECLARE vManejaInventario INT;
DECLARE vOrigenRegistro VARCHAR(15);
DECLARE vEsProductoCompuesto INT;

DECLARE vFechahoraRegistro TIMESTAMP;
DECLARE vTipoMovimiento VARCHAR(20);
DECLARE vSigno INT;
DECLARE vUsuario VARCHAR(50);
DECLARE vFromHost VARCHAR(50);
DECLARE vOrigenMovimiento VARCHAR(50);
DECLARE vOrigenIdMovimiento INT;
DECLARE vOrigenFolio BIGINT;
DECLARE vIdProducto BIGINT;
DECLARE vExistenciaAnterior DECIMAL(18,6);
DECLARE vNuevaExistencia DECIMAL(18,6);
DECLARE vExistenciaFinal DECIMAL(18,6);
DECLARE vIdTurno BIGINT;
DECLARE vIdAlmacen BIGINT;
DECLARE vComentarios VARCHAR(120);
DECLARE vFisico DECIMAL(18,6);
DECLARE vFaltante DECIMAL(18,6);
DECLARE vExcedente DECIMAL(18,6);
DECLARE vCostoPromedioSinIVA DECIMAL(18,6);
DECLARE vImporte DECIMAL(18,6);

DECLARE m_idcomponente BIGINT;
DECLARE m_cantidad_componente DECIMAL(18,6);
DECLARE m_manejainventario TINYINT;
DECLARE m_costopromedio DECIMAL(18,6);
DECLARE fin INT;

DECLARE curComponentes CURSOR FOR SELECT c.idcomponente, c.cantidad, p.manejainventario, p.costo_promedio_antesiva 
FROM productoscompuestos AS c 
INNER JOIN cat_productos AS p ON c.idcomponente = p.idproduct AND c.idempresa = p.idempresa
WHERE c.idproducto = NEW.idproducto AND c.idempresa = NEW.idempresa;
	
DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

SET fin = 0;

-- 01 BUSCAR LOS DATOS QUE ESTAN EN mov_inv_general
SELECT v.idempresa,v.idsucursal,v.fechahora_registro,v.usuario,v.from_host,v.origen_movimiento,v.idturno,
	v.tipo_movimiento,v.signo
FROM mov_inv_general v
WHERE v.idmovinventariogral = new.idinventariofisicogral LIMIT 1
INTO vIdEmpresa,vIdSucursal,vFechahoraRegistro,vUsuario,vFromHost,vOrigenMovimiento,vIdTurno,vTipoMovimiento,vSigno;

-- 02 cargar datos de existencias
SELECT P.manejainventario, P.esproductocompuesto -- , P.costo_promedio_antesiva   
FROM cat_productos P
WHERE P.idproduct = NEW.idproducto AND P.idempresa = NEW.idempresa
LIMIT 1 
INTO vManejaInventario,vEsProductoCompuesto; -- ,vCostoPromedioSinIVA;

SET vFisico = 0;
SET vFaltante = 0;
SET vExcedente = 0;

IF NEW.origen_registro = 'WEB' THEN
  INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
  VALUES (NEW.idempresa, NEW.idsucursal, NEW.idmovinventariodet, 'I', 'INVENTARIOFISICODET');
END IF;

	IF vManejaInventario = 1 THEN

		SELECT i.existencia 
		FROM mov_inv_existencias i
		WHERE i.idproducto = NEW.idproducto AND i.idempresa = NEW.idempresa 
		AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
		INTO vExistenciaAnterior;

		IF (vExistenciaAnterior IS NOT NULL) THEN

			IF (vTipoMovimiento = 'INICIAL') THEN
				SET vFisico = NEW.fisico;
				SET vFaltante = NEW.faltante;
				SET vExcedente = NEW.excedente;
				SET vExistenciaFinal = NEW.cantidad;
				SET vNuevaExistencia = vExistenciaFinal;
			ELSEIF (vTipoMovimiento = 'ENTRADA') THEN
				SET vExistenciaFinal = vExistenciaAnterior + NEW.cantidad;
				SET vNuevaExistencia = vExistenciaFinal;
			ELSEIF (vTipoMovimiento = 'SALIDA') THEN
				SET vExistenciaFinal = vExistenciaAnterior - NEW.CANTIDAD;
				SET vNuevaExistencia = vExistenciaFinal;
			END IF;
			
			-- Para evitar error en caso de dividir costo entre 0
			IF(NEW.cantidad = 0) THEN
				 SET vCostoPromedioSinIVA = 0;			 
			ELSE			 
				 SET vCostoPromedioSinIVA = NEW.costoinventario / NEW.cantidad;
			END IF;
		 
			INSERT INTO bitacora_existencias (idempresa,idsucursal,idbitacora,fechahora_registro,tipo,
					signo,usuario,from_host,origen_movimiento,origen_idmovimiento,
					origen_folio,idproducto,existencia_anterior,movimiento_cantidad,
					existencia_final,idturno,idalmacen,comentarios,fisico,
					faltante,excedente,origen_registro,descargado,precio_unitario,importe) 
			VALUES(NEW.idempresa,NEW.idsucursal,0,vFechahoraRegistro,vTipoMovimiento,vSigno,vUsuario,vFromHost,vOrigenMovimiento,
					NEW.idinventariofisicogral,NEW.idinventariofisicogral,NEW.idproducto,vExistenciaAnterior,New.cantidad,
					vNuevaExistencia,vIdTurno,NEW.idalmacen,vOrigenMovimiento,vFisico,vFaltante,vExcedente,
					NEW.origen_registro,0,vCostoPromedioSinIVA,NEW.costoinventario);

			-- actualizar las existencias
			UPDATE mov_inv_existencias i SET i.existencia = vNuevaExistencia
			WHERE i.idproducto = NEW.idproducto AND i.idempresa=NEW.idempresa AND i.idsucursal = NEW.idsucursal;
		-- ELSE
			-- CREAR REGISTRO EN 0 EXISTENCIAS
		END IF;
	END IF;
		
	IF (vESPRODUCTOCOMPUESTO=1) THEN
	
		OPEN curComponentes;
			ins_loop: LOOP
				FETCH curComponentes INTO m_idcomponente, m_cantidad_componente, m_manejainventario, m_costopromedio;
				IF fin=1 THEN
					LEAVE ins_loop;
				END IF;
				
				IF (m_manejainventario = 1) THEN 
					
					SELECT i.existencia 
					FROM mov_inv_existencias i
					WHERE i.idproducto = m_idcomponente AND i.idempresa = NEW.idempresa 
					AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
					INTO vExistenciaAnterior;
					
					IF (vExistenciaAnterior IS NOT NULL) THEN
					
						IF (vTipoMovimiento = 'ENTRADA') THEN
							SET vExistenciaFinal = vExistenciaAnterior + (NEW.cantidad * m_cantidad_componente);
							SET vNuevaExistencia = vExistenciaFinal;
						ELSEIF (vTipoMovimiento = 'SALIDA') THEN
							SET vExistenciaFinal = vExistenciaAnterior - (NEW.cantidad * m_cantidad_componente);
							SET vNuevaExistencia = vExistenciaFinal;
						END IF;

						INSERT INTO bitacora_existencias (idempresa,idsucursal,idbitacora,fechahora_registro,tipo,
							signo,usuario,from_host,origen_movimiento,origen_idmovimiento,
							origen_folio,idproducto,existencia_anterior,movimiento_cantidad,
							existencia_final,idturno,idalmacen,comentarios,fisico,
							faltante,excedente,origen_registro,descargado,precio_unitario,importe) 
						VALUES(NEW.idempresa,NEW.idsucursal,0,vFechahoraRegistro,vTipoMovimiento,vSigno,vUsuario,vFromHost,vOrigenMovimiento,
							NEW.idinventariofisicogral,NEW.idinventariofisicogral,m_idcomponente,vExistenciaAnterior,(New.cantidad * m_cantidad_componente),
							vNuevaExistencia,vIdTurno,NEW.idalmacen,vOrigenMovimiento,vFisico,vFaltante,vExcedente,
							NEW.origen_registro,0,m_costopromedio, m_costopromedio * (NEW.cantidad * m_cantidad_componente));

						-- actualizar las existencias
						UPDATE mov_inv_existencias i SET i.existencia = vNuevaExistencia
						WHERE i.idproducto = NEW.idproducto AND i.idempresa=NEW.idempresa AND i.idsucursal = NEW.idsucursal;

					END IF; 
				END	IF;				
			END LOOP;
		CLOSE curComponentes;
		
	END IF;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `mov_inv_existencias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mov_inv_existencias` (
  `idmovinvexistencia` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idinventario` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `existencia` decimal(18,6) NOT NULL,
  `contados` int(11) NOT NULL,
  `idsucursalorigen` int(11) NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  `descargado` smallint(1) NOT NULL,
  `existencia_en_presentaciones` decimal(18,6) DEFAULT NULL,
  `existencia_proporcional` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idmovinvexistencia`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `mov_inv_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mov_inv_general` (
  `idmovinventariogral` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idmovinventariogral_desk` bigint(20) NOT NULL,
  `idinventariofisicogral` bigint(20) DEFAULT NULL,
  `fecha` date NOT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `estatus` smallint(6) NOT NULL,
  `idconceptoinventario` bigint(20) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `costoinventario` decimal(18,6) NOT NULL,
  `idalmacendestino` bigint(20) NOT NULL,
  `idorigeninventario` int(11) DEFAULT NULL,
  `comentarios` varchar(120) NOT NULL,
  `horamovimiento` varchar(20) NOT NULL,
  `nombre_proveedor` varchar(180) DEFAULT NULL,
  `idturno` bigint(20) NOT NULL,
  `fechahora_registro` timestamp NOT NULL DEFAULT current_timestamp(),
  `usuario` varchar(50) NOT NULL,
  `from_host` varchar(50) NOT NULL,
  `origen_movimiento` varchar(50) NOT NULL,
  `tipo_movimiento` varchar(50) NOT NULL,
  `signo` smallint(6) NOT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  `descargado` smallint(1) DEFAULT NULL,
  `idproveedor` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`idmovinventariogral`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `movinvgeneral_AI` AFTER INSERT ON `mov_inv_general` FOR EACH ROW IF NEW.origen_registro = 'WEB' THEN

	INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
    VALUES (NEW.idempresa, NEW.idsucursal, NEW.idmovinventariogral, 'I', 'INVENTARIOFISICOGRAL');

END IF */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  KEY `password_resets_email_index` (`email`) USING BTREE,
  KEY `password_resets_token_index` (`token`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `pedidos_detalle_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pedidos_detalle_01` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `origen_registro` smallint(6) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `idpedidogeneral` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `clave` varchar(30) NOT NULL,
  `descripcion` varchar(254) NOT NULL,
  `unidadmedida` varchar(30) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `precio` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `productoyavendido` smallint(6) NOT NULL,
  `cantidadfaltantexvender` decimal(18,6) NOT NULL,
  `descripcionadicional` varchar(100) DEFAULT NULL,
  `cancelado` smallint(6) NOT NULL,
  `justificacion_cancelacion` varchar(254) NOT NULL,
  `cantidadyaenviada` decimal(18,6) DEFAULT NULL,
  `cantidadxenviar` decimal(18,6) DEFAULT NULL,
  `idalmacen` bigint(20) DEFAULT NULL,
  `costopromedio` decimal(18,6) DEFAULT NULL,
  `fechahoradocumento` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `idfamilia` bigint(20) DEFAULT NULL,
  `clave_familia` varchar(20) DEFAULT NULL,
  `idmarca` bigint(20) DEFAULT NULL,
  `clave_marca` varchar(20) DEFAULT NULL,
  `idusuario` bigint(20) DEFAULT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `traslado_iva_tipo_factor` varchar(20) DEFAULT NULL,
  `traslado_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_iva_importe` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_tipo_factor` varchar(20) DEFAULT NULL,
  `traslado_ieps_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_importe` decimal(18,6) DEFAULT NULL,
  `retencion_iva_tipo_factor` varchar(20) DEFAULT NULL,
  `retencion_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `retencion_iva_importe` decimal(18,6) DEFAULT NULL,
  `retencion_isr_tipo_factor` varchar(20) DEFAULT NULL,
  `retencion_isr_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `retencion_isr_importe` decimal(18,6) DEFAULT NULL,
  `peso_bruto` decimal(18,6) DEFAULT NULL,
  `peso_tara` decimal(18,6) DEFAULT NULL,
  `peso_agua` decimal(18,6) DEFAULT NULL,
  `peso_neto` decimal(18,6) DEFAULT NULL,
  `peso_promedio` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idweb`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `pedidos_general_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pedidos_general_01` (
  `idweb` bigint(20) NOT NULL AUTO_INCREMENT,
  `iddesk` bigint(20) NOT NULL,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `origen_registro` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `foliopedido` bigint(20) NOT NULL,
  `idstatus` int(11) NOT NULL,
  `fechapedidogeneral` date NOT NULL,
  `horapedidogeneral` varchar(20) NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `comentarios` varchar(100) DEFAULT NULL,
  `repartidor` varchar(80) NOT NULL,
  `pedidoyaentregado` smallint(6) NOT NULL,
  `origen` varchar(30) NOT NULL,
  `idorigen` bigint(20) DEFAULT NULL,
  `condiciones` varchar(60) DEFAULT NULL,
  `rfc_a_facturar` varchar(20) DEFAULT NULL,
  `idcliente_a_facturar` bigint(20) DEFAULT NULL,
  `facturado` smallint(6) DEFAULT NULL,
  `idcfdigeneral` bigint(20) DEFAULT NULL,
  `cfdi_uuid` varchar(36) DEFAULT NULL,
  `pagado` smallint(6) DEFAULT NULL,
  `total_abonado` decimal(18,6) DEFAULT NULL,
  `total_saldo` decimal(18,6) DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `fecha_pago` date DEFAULT NULL,
  `referencia1` varchar(80) DEFAULT NULL,
  `referencia2` varchar(80) DEFAULT NULL,
  `moneda` varchar(20) DEFAULT NULL,
  `importeletra` varchar(120) DEFAULT NULL,
  `anio` int(11) DEFAULT NULL,
  `mes` int(11) DEFAULT NULL,
  `dia` int(11) DEFAULT NULL,
  `cfdi_serie` varchar(25) DEFAULT NULL,
  `cfdi_folio` bigint(20) DEFAULT NULL,
  `cfdi_receptornombre` varchar(180) DEFAULT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `costototal` decimal(18,6) DEFAULT 0.000000,
  `utilidadtotal` decimal(18,6) DEFAULT 0.000000,
  `idturno` bigint(20) DEFAULT NULL,
  `traslado_ieps_importe` decimal(18,6) DEFAULT NULL,
  `traslado_iva_importe` decimal(18,6) DEFAULT NULL,
  `retencion_iva_importe` decimal(18,6) DEFAULT NULL,
  `retencion_isr_importe` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idweb`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `pedidos_intermedios_detalle_movil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pedidos_intermedios_detalle_movil` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `id_pedido_intermedio_general_movil` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `clave` varchar(30) DEFAULT NULL,
  `descripcion` varchar(254) DEFAULT NULL,
  `unidadmedida` varchar(150) DEFAULT NULL,
  `cantidad` decimal(18,6) DEFAULT NULL,
  `cantidadyaenviada` tinyint(4) DEFAULT NULL,
  `cantidadxenviar` decimal(18,6) DEFAULT NULL,
  `precio` decimal(18,6) DEFAULT NULL,
  `importe` decimal(18,6) DEFAULT NULL,
  `descuentox100` decimal(18,6) DEFAULT NULL,
  `descuento` decimal(18,6) DEFAULT NULL,
  `subtotal` decimal(18,6) DEFAULT NULL,
  `iva` decimal(18,6) DEFAULT NULL,
  `total` decimal(18,6) DEFAULT NULL,
  `traslado_iva_tipo_factor` varchar(20) DEFAULT NULL,
  `traslado_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_iva_importe` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_tipo_factor` varchar(20) DEFAULT NULL,
  `traslado_ieps_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `traslado_ieps_importe` decimal(18,6) DEFAULT NULL,
  `retencion_iva_tipo_factor` varchar(20) DEFAULT NULL,
  `retencion_iva_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `retencion_iva_importe` decimal(18,6) DEFAULT NULL,
  `retencion_isr_tipo_factor` varchar(20) DEFAULT NULL,
  `retencion_isr_tasa_cuota` decimal(18,6) DEFAULT NULL,
  `retencion_isr_importe` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_idempesa` (`idempresa`),
  KEY `index_idsucursal` (`idsucursal`),
  KEY `index_id_pedido_intermedio_general_movil` (`id_pedido_intermedio_general_movil`),
  KEY `index_idproducto` (`idproducto`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `pedidos_intermedios_detalle_movil_insert` AFTER INSERT ON `pedidos_intermedios_detalle_movil` FOR EACH ROW INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
VALUES (NEW.idempresa, NEW.idsucursal, NEW.id, 'I', 'PEDIDOS_INTERMEDIOS_DETALLE_MOVIL') */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `pedidos_intermedios_general_movil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pedidos_intermedios_general_movil` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `idstatus` tinyint(4) NOT NULL,
  `fecha_pedido` date NOT NULL,
  `fecha_pedido_entrega` date NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `nombre_cliente` varchar(80) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `idvendedor` bigint(20) NOT NULL,
  `nombre_vendedor` varchar(80) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `pedidoyaaplicado` tinyint(4) NOT NULL,
  `comentarios` varchar(80) DEFAULT NULL,
  `idpedidogeneral` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_idempresa` (`idempresa`),
  KEY `index_idsucursal` (`idsucursal`),
  KEY `index_fecha_pedido` (`fecha_pedido`),
  KEY `index_fecha_pedido_entrega` (`fecha_pedido_entrega`),
  KEY `index_idcliente` (`idcliente`),
  KEY `index_idvendedor` (`idvendedor`),
  KEY `index_pedidoyaaplicado` (`pedidoyaaplicado`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `pedidos_intermedios_general_movil_insert` AFTER INSERT ON `pedidos_intermedios_general_movil` FOR EACH ROW INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
VALUES (NEW.idempresa, NEW.idsucursal, NEW.id, 'I', 'PEDIDOS_INTERMEDIOS_GENERAL_MOVIL') */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `perfiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `perfiles` (
  `idprofile` bigint(20) NOT NULL AUTO_INCREMENT,
  `idperfil` bigint(20) NOT NULL,
  `nombre` varchar(20) NOT NULL,
  `nivel_acceso` smallint(6) NOT NULL,
  `comentario` varchar(80) NOT NULL,
  PRIMARY KEY (`idprofile`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `permisos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permisos` (
  `idpermit` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `iddesk` bigint(20) NOT NULL,
  `idmenu` bigint(20) NOT NULL,
  `idmenuopcion` bigint(20) NOT NULL,
  `permitir` smallint(6) NOT NULL,
  `idperfil` bigint(20) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `origen_registro` tinyint(1) NOT NULL,
  PRIMARY KEY (`idpermit`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `permisos_AI` AFTER INSERT ON `permisos` FOR EACH ROW -- No es necesario insertar el mismo usuario para todas las sucursales
-- ya que desde la interfaz de la pagina web se establece a que
-- sucursal se insertara.
BEGIN
  IF NEW.origen_registro = 1 THEN -- 1 sifnifica WEB
    INSERT INTO mov_changes (idempresa, idsucursal, 
      identable, accion, tabla) 
    VALUES (NEW.idempresa, NEW.idsucursal, 
      NEW.idpermit, 'I', 'PERMISOS');
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `permisos_AU` AFTER UPDATE ON `permisos` FOR EACH ROW -- No es necesario insertar el mismo usuario para todas las sucursales
-- ya que desde la interfaz de la pagina web se establece a que
-- sucursal se insertara.
BEGIN
  IF NEW.origen_registro = 1 THEN -- 1 sifnifica WEB
    INSERT INTO mov_changes (idempresa, idsucursal, 
      identable, accion, tabla) 
    VALUES (NEW.idempresa, NEW.idsucursal, 
      NEW.idpermit, 'U', 'PERMISOS');
  END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `permisos_AD` AFTER DELETE ON `permisos` FOR EACH ROW BEGIN
    -- No es necesario insertar el mismo usuario para todas las sucursales
    -- ya que desde la interfaz de la pagina web se establece a que
    -- sucursal se insertara.
  
    DELETE FROM mov_changes 
    WHERE idempresa = OLD.idempresa
    AND tabla = 'PERMISOS' AND identable = OLD.idpermit;
    
    INSERT INTO mov_changes (idempresa, idsucursal, 
      identable, accion, tabla) 
    VALUES (OLD.idempresa, OLD.idsucursal, 
      OLD.idpermit, 'D', 'PERMISOS');  
  END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `permisos_02`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permisos_02` (
  `idpermit` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idmenu` bigint(20) NOT NULL,
  `idmenuopcion` bigint(20) NOT NULL,
  `permitir` tinyint(1) NOT NULL,
  `idperfil` int(11) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `origen_registro` tinyint(1) NOT NULL,
  PRIMARY KEY (`idpermit`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `permisos_02_AI` AFTER INSERT ON `permisos_02`
  FOR EACH ROW
BEGIN

DECLARE m_idsucursal INT;
DECLARE fin INT;
DECLARE cur CURSOR FOR 
  SELECT idbranchoffice 
  FROM cat_sucursales 
  WHERE idempresa = NEW.idempresa;

IF NEW.origen_registro = 1 THEN -- 1 significa WEB
  OPEN cur;
    ins_loop: LOOP
      FETCH cur INTO m_idsucursal;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;        
        INSERT INTO mov_changes (
          idempresa, idsucursal, identable, accion, tabla) 
        VALUES (
          NEW.idempresa, m_idsucursal, NEW.idpermit, 'I', 'PERMISOS_02');
    END LOOP;
  CLOSE cur;
END IF;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `permisos_02_AU` AFTER UPDATE ON `permisos_02`
  FOR EACH ROW
BEGIN

DECLARE m_idsucursal INT;
DECLARE fin INT;
DECLARE cur CURSOR FOR 
  SELECT idbranchoffice 
  FROM cat_sucursales 
  WHERE idempresa = NEW.idempresa;

IF NEW.origen_registro = 1 THEN -- 1 significa WEB
  OPEN cur;
    ins_loop: LOOP
      FETCH cur INTO m_idsucursal;
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;        
        INSERT INTO mov_changes (
          idempresa, idsucursal, identable, accion, tabla) 
        VALUES (
          NEW.idempresa, m_idsucursal, NEW.idpermit, 'U', 'PERMISOS_02');
    END LOOP;
  CLOSE cur;
END IF;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `permisos_02_AD` AFTER DELETE ON `permisos_02`
  FOR EACH ROW
BEGIN

DECLARE m_idsucursal INT;
DECLARE fin INT;
DECLARE cur CURSOR FOR 
  SELECT idbranchoffice 
  FROM cat_sucursales 
  WHERE idempresa = OLD.idempresa;
 
DELETE FROM mov_changes 
WHERE idempresa = OLD.idempresa
AND tabla = 'PERMISOS_02' AND identable = OLD.idpermit;

OPEN cur;
  ins_loop: LOOP
    
    FETCH cur INTO m_idsucursal;
    
    IF fin=1 THEN
      LEAVE ins_loop;
    END IF;        
    
    INSERT INTO mov_changes (
      idempresa, idsucursal, identable, accion, tabla) 
    VALUES (
      OLD.idempresa, m_idsucursal, OLD.idpermit, 'D', 'PERMISOS_02');
        
  END LOOP;
CLOSE cur;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `persona`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `persona` (
  `idpersona` int(11) NOT NULL AUTO_INCREMENT,
  `tipo_persona` varchar(20) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `tipo_documento` varchar(20) DEFAULT NULL,
  `num_documento` varchar(15) DEFAULT NULL,
  `direccion` varchar(70) DEFAULT NULL,
  `telefono` varchar(15) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idpersona`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`) USING BTREE,
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `productoscompuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productoscompuestos` (
  `idcompoundproduct` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idcomponente` bigint(20) NOT NULL,
  `idproducto` bigint(20) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `origen_registro` tinyint(1) NOT NULL,
  `existencia_proporcional` decimal(18,6) DEFAULT NULL,
  PRIMARY KEY (`idcompoundproduct`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `productoscompuestos_AI` AFTER INSERT ON `productoscompuestos` FOR EACH ROW BEGIN
  DECLARE m_idbranchoffice INT;
  DECLARE fin int;
  DECLARE cur CURSOR FOR SELECT idbranchoffice 
    FROM cat_sucursales WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  IF NEW.origen_registro = 1 THEN -- 1 => 'WEB', 0 => 'ESCRITORIO'
    OPEN cur;
      ins_loop: LOOP
        
        FETCH cur INTO m_idbranchoffice;
        
        IF fin=1 THEN
          LEAVE ins_loop;
        END IF;
        
        INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
        VALUES (NEW.idempresa, m_idbranchoffice, NEW.idcompoundproduct, 'I', 'PRODUCTOSCOMPUESTOS');
        
      END LOOP;
    CLOSE cur;
  END IF;  
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `productoscompuestos_AU` AFTER UPDATE ON `productoscompuestos` FOR EACH ROW BEGIN

  DECLARE m_idbranchoffice INT;
  DECLARE fin INT;
  DECLARE cur CURSOR FOR
    SELECT idbranchoffice
    FROM cat_sucursales
    WHERE idempresa = NEW.idempresa;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

  SET fin = 0;

  IF NEW.origen_registro = 1 THEN -- 1 => 'WEB', 0 => 'ESCRITORIO'
      OPEN cur;
        ins_loop: LOOP

          FETCH cur INTO m_idbranchoffice;

          IF fin=1 THEN
            LEAVE ins_loop;
          END IF;

          INSERT INTO mov_changes (
            idempresa, idsucursal, identable,
            accion, tabla)
          VALUES (
            NEW.idempresa, m_idbranchoffice, NEW.idcompoundproduct,
            'U', 'PRODUCTOSCOMPUESTOS');

        END LOOP;
      CLOSE cur;
  END IF;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `productoscompuestos_AD` AFTER DELETE ON `productoscompuestos` FOR EACH ROW BEGIN
	DECLARE m_idsucursal INT;
	DECLARE fin int;
    DECLARE cur CURSOR FOR SELECT idbranchoffice FROM cat_sucursales WHERE idempresa = OLD.idempresa;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	
	DELETE FROM mov_changes
	WHERE tabla ='PRODUCTOSCOMPUESTOS' 
  	AND identable=OLD.idcompoundproduct
	AND idempresa=OLD.idempresa;
	
    OPEN cur;
        ins_loop: LOOP
            FETCH cur INTO m_idsucursal;
            IF fin=1 THEN
                LEAVE ins_loop;
            END IF;
            INSERT INTO mov_changes (idempresa, idsucursal, identable, accion, tabla) 
            VALUES (OLD.idempresa, m_idsucursal, OLD.idcompoundproduct, 'D', 'PRODUCTOSCOMPUESTOS');
        END LOOP;
    CLOSE cur;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `productoscompuestos_existenciaproporcional`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productoscompuestos_existenciaproporcional` (
  `idcomponenteexistencia` bigint(20) NOT NULL AUTO_INCREMENT,
  `idsucursal` bigint(20) NOT NULL,
  `idcompoundproduct` bigint(20) NOT NULL,
  `idcomponente` bigint(20) NOT NULL,
  `idproductopadre` bigint(20) NOT NULL,
  `existencia_proporcional` decimal(18,6) NOT NULL DEFAULT 0.000000,
  PRIMARY KEY (`idcomponenteexistencia`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sqldownloads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sqldownloads` (
  `idsqldownload` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `sqlejecutar` text CHARACTER SET utf8 COLLATE utf8_spanish2_ci NOT NULL,
  `descargado` tinyint(1) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  PRIMARY KEY (`idsqldownload`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `status` (
  `idstatus` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(80) NOT NULL,
  PRIMARY KEY (`idstatus`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `subidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subidas` (
  `idsubida` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `tabla` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish2_ci NOT NULL,
  `iddesk` bigint(20) NOT NULL,
  `idweb` bigint(20) NOT NULL,
  PRIMARY KEY (`idsubida`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `subidas_AI` AFTER INSERT ON `subidas` FOR EACH ROW BEGIN

  DECLARE m_idbranchoffice INT;
  DECLARE fin INT;
  DECLARE cur CURSOR FOR 
    SELECT idbranchoffice 
    FROM cat_sucursales 
    WHERE idempresa = NEW.idempresa 
    AND idsucursal != NEW.idsucursal;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
  
  SET fin=0;

  OPEN cur;
    ins_loop: LOOP

      FETCH cur INTO m_idbranchoffice;

      IF fin=1 THEN
        LEAVE ins_loop;
      END IF;

      INSERT INTO mov_changes (
        idempresa, idsucursal, identable, accion, tabla) 
      VALUES (
        NEW.idempresa, m_idbranchoffice, NEW.idweb, 'I', NEW.tabla);

    END LOOP;
  CLOSE cur;

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `tenants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tenants` (
  `id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tiposdedocumentos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tiposdedocumentos` (
  `idtipodocumento` int(11) NOT NULL,
  `tipodocumento` varchar(80) NOT NULL,
  `descripcion` varchar(120) NOT NULL,
  `visible` smallint(6) NOT NULL,
  PRIMARY KEY (`idtipodocumento`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tiposdepago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tiposdepago` (
  `idtipopago` bigint(20) NOT NULL,
  `clave` varchar(20) NOT NULL,
  `nombrecorto` varchar(20) NOT NULL,
  `nombre` varchar(60) NOT NULL,
  `estarjetadecredito` smallint(6) NOT NULL,
  `escredito` smallint(6) NOT NULL,
  `plazocredito` smallint(6) NOT NULL,
  `darcambio` smallint(6) NOT NULL,
  `visible` smallint(6) NOT NULL,
  `comision` decimal(18,6) NOT NULL,
  `tipodecambio` decimal(18,6) NOT NULL,
  `requierereferencia` smallint(6) NOT NULL,
  `prioridadvisualizacion` smallint(6) NOT NULL,
  `imagen` blob DEFAULT NULL,
  `fechaalta` date NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idsucursalrepl` int(11) NOT NULL,
  PRIMARY KEY (`idtipopago`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `idempresa` int(11) DEFAULT NULL,
  `idsucursal` int(11) DEFAULT NULL,
  `idperfil` int(11) DEFAULT NULL,
  `essuperusuario` smallint(1) NOT NULL DEFAULT 0,
  `password` varchar(255) NOT NULL,
  `two_factor_secret` text DEFAULT NULL,
  `two_factor_recovery_codes` text DEFAULT NULL,
  `two_factor_confirmed_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `usuarios_nube_escritorio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuarios_nube_escritorio` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` bigint(20) NOT NULL,
  `id_users` bigint(20) NOT NULL,
  `id_cat_usuarios` bigint(20) NOT NULL,
  `activo` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `venta` (
  `idventa` int(11) NOT NULL AUTO_INCREMENT,
  `idcliente` int(11) NOT NULL,
  `tipo_comprobante` varchar(20) NOT NULL,
  `serie_comprobante` varchar(7) NOT NULL,
  `num_comprobante` varchar(10) NOT NULL,
  `fecha_hora` datetime NOT NULL,
  `impuesto` decimal(4,2) NOT NULL,
  `total_venta` decimal(11,2) NOT NULL,
  `estado` varchar(20) NOT NULL,
  PRIMARY KEY (`idventa`) USING BTREE,
  KEY `fk_venta_cliente_idx` (`idcliente`) USING BTREE,
  CONSTRAINT `fk_venta_cliente` FOREIGN KEY (`idcliente`) REFERENCES `persona` (`idpersona`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ventasdetalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ventasdetalle` (
  `idventadetalle` bigint(20) NOT NULL AUTO_INCREMENT,
  `idventadetalle_desk` bigint(20) DEFAULT NULL,
  `idventageneral` bigint(20) NOT NULL,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idproducto` bigint(20) DEFAULT NULL,
  `idfamilia` bigint(20) DEFAULT NULL,
  `idmarca` bigint(20) DEFAULT NULL,
  `clave` varchar(30) DEFAULT NULL,
  `descripcion` varchar(120) NOT NULL,
  `cantidad` decimal(18,6) NOT NULL,
  `precio` decimal(18,6) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `fechahora` timestamp NULL DEFAULT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `idalmacen` bigint(20) NOT NULL,
  `costopromedio` decimal(18,6) DEFAULT NULL,
  `costo_venta` decimal(18,6) NOT NULL,
  `utilidad` decimal(18,6) NOT NULL,
  `origen_registro` tinyint(1) DEFAULT NULL,
  `clave_marca` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `clave_familia` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `idusuario` bigint(20) DEFAULT NULL,
  `idusuario_desk` bigint(20) DEFAULT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idturno_desk` bigint(20) DEFAULT NULL,
  `vtagral_idstatus` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`idventadetalle`),
  KEY `ventasdetalle_01` (`idempresa`,`idsucursal`,`idventadetalle_desk`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`root`@`localhost`*/ /*!50003 TRIGGER `ventasdetalle_AI` AFTER INSERT ON `ventasdetalle` FOR EACH ROW BEGIN
  DECLARE vFECHAHORA_REGISTRO TIMESTAMP;
  DECLARE vUSUARIO VARCHAR(50);
  DECLARE vFROM_HOST VARCHAR(50);
  DECLARE vORIGEN_MOVIMIENTO VARCHAR(50);
  DECLARE vFOLIODOCUMENTO BIGINT;
  DECLARE vIDTURNO BIGINT;
  DECLARE vWEB_IDSUCURSAL BIGINT;
  DECLARE vEXISTENCIA_ANTERIOR DECIMAL(18,6);
  DECLARE vEXISTENCIA_FINAL DECIMAL(18,6);
  DECLARE vSIGNO SMALLINT;
  DECLARE vMANEJAINVENTARIO SMALLINT;
  DECLARE vESPRODUCTOCOMPUESTO SMALLINT;
  DECLARE vfisico DECIMAL(18,6);
  DECLARE vfaltante DECIMAL(18,6);
  DECLARE vexcedente DECIMAL(18,6);
	
  DECLARE m_idcomponente BIGINT;
  DECLARE m_cantidad_componente DECIMAL(18,6);
  DECLARE m_manejainventario TINYINT;
  DECLARE m_costopromedio DECIMAL(18,6);
  DECLARE fin INT;
	
  DECLARE curComponentes CURSOR FOR 
		SELECT c.idcomponente, c.cantidad, p.manejainventario, p.costo_promedio_antesiva 
		FROM productoscompuestos AS c 
		INNER JOIN cat_productos AS p ON c.idcomponente = p.idproduct AND c.idempresa = p.idempresa
		WHERE c.idproducto = NEW.idproducto AND c.idempresa = NEW.idempresa;
	
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;
	
  
	SET fin = 0;
  SET vSIGNO = -1;
  SET vfisico=0;
  SET vfaltante=0;
  SET vexcedente=0;

  -- 01 BUSCAR LOS DATOS QUE ESTAN EN VENTASGENERAL
  SELECT v.idsucursal,v.fechahora,v.usuario,v.from_host,
		v.origen_movimiento,v.folio,v.idturno 
  FROM ventasgeneral v
  WHERE v.idventageneral = new.idventageneral AND v.idempresa=NEW.idempresa 
	AND v.idsucursal=NEW.idsucursal
  LIMIT 1
  INTO vWEB_IDSUCURSAL, vFECHAHORA_REGISTRO, vUSUARIO,
		vFROM_HOST,vORIGEN_MOVIMIENTO,vFOLIODOCUMENTO,vIDTURNO;

  -- 02 cargar datos de producto
  SELECT p.manejainventario, p.esproductocompuesto   
  FROM cat_productos p
  WHERE p.idproduct = NEW.idproducto AND p.idempresa=NEW.idempresa LIMIT 1 
  INTO vMANEJAINVENTARIO, vESPRODUCTOCOMPUESTO;

	IF (vMANEJAINVENTARIO=1) THEN
    
		-- 02 cargar datos de existencias
		SELECT i.existencia 
		FROM mov_inv_existencias i
		WHERE i.idproducto = NEW.idproducto AND i.idempresa=NEW.idempresa 
		AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
		LIMIT 1
		INTO vEXISTENCIA_ANTERIOR;

	  IF (vEXISTENCIA_ANTERIOR IS NOT NULL) THEN
		
		-- 03 calcular nueva existencia
		SET vEXISTENCIA_FINAL = vEXISTENCIA_ANTERIOR - NEW.cantidad; 
			
		INSERT INTO bitacora_existencias (idempresa,idsucursal,fechahora_registro,tipo,signo,usuario,
			from_host,origen_movimiento,origen_idmovimiento,origen_folio,idproducto, existencia_anterior, 
			movimiento_cantidad, existencia_final,idturno, idalmacen, comentarios,
			fisico,faltante,excedente,precio_unitario,importe,origen_registro,descargado)
		VALUES (NEW.idempresa, NEW.idsucursal, vFECHAHORA_REGISTRO,'SALIDA X VENTA',vSIGNO,vUSUARIO,
			vFROM_HOST,vORIGEN_MOVIMIENTO,NEW.idventageneral,vFOLIODOCUMENTO,NEW.idproducto,vEXISTENCIA_ANTERIOR,
			NEW.cantidad,vEXISTENCIA_FINAL,vIDTURNO,NEW.idalmacen,'',
			vfisico,vfaltante,vexcedente, NEW.costopromedio,(NEW.cantidad*NEW.costopromedio),'ESCRITORIO',1);

		-- actualizar las existencias
		UPDATE mov_inv_existencias i SET 
		i.existencia = vEXISTENCIA_FINAL
		WHERE i.idproducto = NEW.idproducto AND i.idempresa=NEW.idempresa AND i.idsucursal = NEW.idsucursal;
				
	  END IF;
	END IF;
	  
	IF (vESPRODUCTOCOMPUESTO=1) THEN
	
		OPEN curComponentes;
			ins_loop: LOOP
				FETCH curComponentes INTO m_idcomponente, m_cantidad_componente, m_manejainventario, m_costopromedio;
				IF fin=1 THEN
					LEAVE ins_loop;
				END IF;
				
				IF (m_manejainventario = 1) THEN 
					SELECT i.existencia 
					FROM mov_inv_existencias i
					WHERE i.idproducto = m_idcomponente AND i.idempresa=NEW.idempresa 
					AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
					LIMIT 1
					INTO vEXISTENCIA_ANTERIOR;
					
					IF (vEXISTENCIA_ANTERIOR IS NOT NULL) THEN

						-- 03 calcular nueva existencia
						SET vEXISTENCIA_FINAL = vEXISTENCIA_ANTERIOR - (NEW.cantidad * m_cantidad_componente); 
						
						INSERT INTO bitacora_existencias (
							idempresa, idsucursal, fechahora_registro, tipo, signo, 
							usuario, from_host, origen_movimiento,origen_idmovimiento,
							origen_folio, idproducto, existencia_anterior, movimiento_cantidad, 
							existencia_final, idturno, idalmacen, comentarios, 
							fisico, faltante, excedente, precio_unitario,
							importe, origen_registro, descargado)
						VALUES (
							NEW.idempresa, NEW.idsucursal, vFECHAHORA_REGISTRO,'SALIDA X VENTA', 
							vSIGNO, vUSUARIO, vFROM_HOST, vORIGEN_MOVIMIENTO,
							NEW.idventageneral, vFOLIODOCUMENTO, m_idcomponente, vEXISTENCIA_ANTERIOR, 
							NEW.cantidad * m_cantidad_componente, vEXISTENCIA_FINAL, vIDTURNO, NEW.idalmacen,
							CONCAT('SALIÓ COMO COMPONENTE DE ', NEW.descripcion), vfisico, vfaltante, vexcedente, 
							m_costopromedio, (NEW.cantidad*m_cantidad_componente*m_costopromedio), 'ESCRITORIO', 1);						

						-- actualizar las existencias
						UPDATE mov_inv_existencias i SET i.existencia = vEXISTENCIA_FINAL
						WHERE i.idproducto = m_idcomponente AND i.idempresa=NEW.idempresa AND i.idsucursal = NEW.idsucursal;

					END IF; 
				END	IF;				
			END LOOP;
		CLOSE curComponentes;
		
	END IF;  

END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
DROP TABLE IF EXISTS `ventasgeneral`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ventasgeneral` (
  `idventagral` bigint(20) NOT NULL AUTO_INCREMENT,
  `idventageneral` bigint(20) NOT NULL,
  `idempresa` bigint(20) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `idstatus` int(11) NOT NULL,
  `idcliente` bigint(20) NOT NULL,
  `cliente` varchar(180) DEFAULT NULL,
  `idtipodocumento` int(11) NOT NULL,
  `documento` varchar(120) DEFAULT NULL,
  `fechaventa` date NOT NULL,
  `horaventa` time NOT NULL,
  `fechahora` timestamp NULL DEFAULT NULL,
  `folio` bigint(20) NOT NULL,
  `pagado` smallint(6) NOT NULL,
  `tipopago` varchar(30) NOT NULL,
  `idusuario` bigint(20) NOT NULL,
  `importe` decimal(18,6) NOT NULL,
  `descuentox100` decimal(18,6) NOT NULL,
  `descuento` decimal(18,6) NOT NULL,
  `subtotal` decimal(18,6) NOT NULL,
  `iva` decimal(18,6) NOT NULL,
  `total` decimal(18,6) NOT NULL,
  `comision` decimal(18,6) NOT NULL DEFAULT -1.000000,
  `totalentregado` decimal(18,6) NOT NULL,
  `cambioaentregar` decimal(18,6) NOT NULL,
  `observaciones1` varchar(50) NOT NULL,
  `idturno` bigint(20) DEFAULT NULL,
  `idtipopago` bigint(20) DEFAULT NULL,
  `costototal` decimal(18,6) DEFAULT NULL,
  `utilidadtotal` decimal(18,6) DEFAULT NULL,
  `usuario` varchar(50) DEFAULT NULL,
  `from_host` varchar(50) DEFAULT NULL,
  `origen_movimiento` varchar(50) DEFAULT NULL,
  `origen_registro` varchar(15) DEFAULT NULL,
  `descargado` smallint(1) DEFAULT NULL,
  `deletedofdesk` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`idventagral`) USING BTREE,
  KEY `i_idtipodocumento` (`idtipodocumento`),
  KEY `i_idempresa` (`idempresa`),
  KEY `i_idtipopago` (`idtipopago`),
  KEY `i_idcliente` (`idcliente`),
  KEY `i_idsucursal` (`idsucursal`),
  KEY `i_idusuario` (`idusuario`),
  KEY `i_fechaventa` (`fechaventa`),
  KEY `i_idturno` (`idturno`),
  KEY `i_idstatus` (`idstatus`),
  KEY `i_horaventa` (`horaventa`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2014_10_12_000000_create_users_table',1);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2014_10_12_100000_create_password_resets_table',1);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('0001_01_01_000000_create_users_table',2);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('0001_01_01_000001_create_cache_table',2);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('0001_01_01_000002_create_jobs_table',2);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_03_18_143212_add_two_factor_columns_to_users_table',2);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_03_18_143322_create_personal_access_tokens_table',3);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_03_18_150604_add_two_factor_columns_to_users_table',4);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_03_18_150708_create_personal_access_tokens_table',4);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_03_18_154300_create_sessions',5);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2019_09_15_000010_create_tenants_table',6);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2019_09_15_000020_create_domains_table',6);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_07_02_230130_central_user',6);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_09_18_141939_recreate_config_table_with_idempresa',7);
INSERT INTO `migrations` (`migration`, `batch`) VALUES ('2025_09_18_143016_create_config_table_unified',8);
