<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('ventasdetalle_AI', function ($trigger) {
            $trigger->on('ventasdetalle');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'DECLARE vFECHAHORA_REGISTRO TIMESTAMP;
                DECLARE vUSUARIO VARCHAR(50);
                DECLARE vFROM_HOST VARCHAR(50);
                DECLARE vORIGEN_MOVIMIENTO VARCHAR(50);
                DECLARE vFOLIODOCUMENTO BIGINT;
                DECLARE vIDTURNO BIGINT;
                DECLARE vWEB_IDSUCURSAL BIGINT;
                DECLARE vEXISTENCIA_ANTERIOR DECIMAL(18,6);
                DECLARE vEXISTENCIA_FINAL DECIMAL(18,6);
                DECLARE vSIGNO SMALLINT;
                DECLARE vMANEJAINVENTARIO SMALLINT;
                DECLARE vESPRODUCTOCOMPUESTO SMALLINT;
                DECLARE vfisico DECIMAL(18,6);
                DECLARE vfaltante DECIMAL(18,6);
                DECLARE vexcedente DECIMAL(18,6);
                DECLARE m_idcomponente BIGINT;
                DECLARE m_cantidad_componente DECIMAL(18,6);
                DECLARE m_manejainventario TINYINT;
                DECLARE m_costopromedio DECIMAL(18,6);
                DECLARE fin INT;
                DECLARE curComponentes CURSOR FOR
                    SELECT c.idcomponente, c.cantidad, p.manejainventario, p.costo_promedio_antesiva
                    FROM productoscompuestos AS c
                    INNER JOIN cat_productos AS p ON c.idcomponente = p.idproduct
                    WHERE c.idproducto = NEW.idproducto;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                SET fin = 0;
                SET vSIGNO = -1;
                SET vfisico=0;
                SET vfaltante=0;
                SET vexcedente=0;

                SELECT v.idsucursal,v.fechahora,v.usuario,v.from_host,v.origen_movimiento,v.folio,v.idturno
                FROM ventasgeneral v
                WHERE v.idventagral = new.idventageneral AND v.idsucursal=NEW.idsucursal                LIMIT 1
                INTO vWEB_IDSUCURSAL, vFECHAHORA_REGISTRO, vUSUARIO, vFROM_HOST,vORIGEN_MOVIMIENTO,vFOLIODOCUMENTO,vIDTURNO;

                SELECT p.manejainventario, p.esproductocompuesto
                FROM cat_productos p
                WHERE p.idproduct = NEW.idproducto LIMIT 1
                INTO vMANEJAINVENTARIO, vESPRODUCTOCOMPUESTO;

                IF (vMANEJAINVENTARIO=1) THEN
                    SELECT i.existencia
                    FROM mov_inv_existencias i
                    WHERE i.idproducto = NEW.idproducto AND i.idsucursal = NEW.idsucursal
                    LIMIT 1
                    INTO vEXISTENCIA_ANTERIOR;

                    IF (vEXISTENCIA_ANTERIOR IS NOT NULL) THEN
                        SET vEXISTENCIA_FINAL = vEXISTENCIA_ANTERIOR - NEW.cantidad;
                        INSERT INTO bitacora_existencias (idsucursal,idbitacora,fechahora_registro,tipo,signo,usuario,from_host,origen_movimiento,origen_idmovimiento,origen_folio,idproducto, existencia_anterior, movimiento_cantidad, existencia_final,idturno, idalmacen, comentarios,fisico,faltante,excedente,precio_unitario,importe,origen_registro,descargado)
                        VALUES (NEW.idsucursal, 0, vFECHAHORA_REGISTRO,\'SALIDA X VENTA\',vSIGNO,vUSUARIO,vFROM_HOST,vORIGEN_MOVIMIENTO,NEW.idventageneral,vFOLIODOCUMENTO,NEW.idproducto,vEXISTENCIA_ANTERIOR,NEW.cantidad,vEXISTENCIA_FINAL,vIDTURNO,NEW.idalmacen,\'\',vfisico,vfaltante,vexcedente, NEW.costopromedio,(NEW.cantidad*NEW.costopromedio),\'ESCRITORIO\',1);
                        UPDATE mov_inv_existencias i SET i.existencia = vEXISTENCIA_FINAL
                        WHERE i.idproducto = NEW.idproducto AND i.idsucursal = NEW.idsucursal;
                    END IF;
                END IF;

                IF (vESPRODUCTOCOMPUESTO=1) THEN
                    OPEN curComponentes;
                        ins_loop: LOOP
                            FETCH curComponentes INTO m_idcomponente, m_cantidad_componente, m_manejainventario, m_costopromedio;
                            IF fin=1 THEN LEAVE ins_loop; END IF;
                            IF (m_manejainventario = 1) THEN
                                SELECT i.existencia
                                FROM mov_inv_existencias i
                                WHERE i.idproducto = m_idcomponente AND i.idsucursal = NEW.idsucursal
                                LIMIT 1
                                INTO vEXISTENCIA_ANTERIOR;
                                IF (vEXISTENCIA_ANTERIOR IS NOT NULL) THEN
                                    SET vEXISTENCIA_FINAL = vEXISTENCIA_ANTERIOR - (NEW.cantidad * m_cantidad_componente);
                                    INSERT INTO bitacora_existencias (idsucursal, idbitacora, fechahora_registro, tipo, signo, usuario, from_host, origen_movimiento,origen_idmovimiento,origen_folio, idproducto, existencia_anterior, movimiento_cantidad, existencia_final, idturno, idalmacen, comentarios, fisico, faltante, excedente, precio_unitario,importe, origen_registro, descargado)
                                    VALUES (NEW.idsucursal, 0, vFECHAHORA_REGISTRO,\'SALIDA X VENTA\', vSIGNO, vUSUARIO, vFROM_HOST, vORIGEN_MOVIMIENTO,NEW.idventageneral, vFOLIODOCUMENTO, m_idcomponente, vEXISTENCIA_ANTERIOR, (NEW.cantidad * m_cantidad_componente), vEXISTENCIA_FINAL, vIDTURNO, NEW.idalmacen,CONCAT(\'SALIÓ COMO COMPONENTE DE \', NEW.descripcion), vfisico, vfaltante, vexcedente, m_costopromedio, (NEW.cantidad*m_cantidad_componente*m_costopromedio), \'ESCRITORIO\', 1);
                                    UPDATE mov_inv_existencias i SET i.existencia = vEXISTENCIA_FINAL
                                    WHERE i.idproducto = m_idcomponente AND i.idsucursal = NEW.idsucursal;
                                END IF;
                            END IF;
                        END LOOP;
                    CLOSE curComponentes;
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('ventasdetalle_AI');
    }
};
