<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('subidas_AI', function ($trigger) {
            $trigger->on('subidas');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'DECLARE m_idbranchoffice INT;
                DECLARE fin INT;
                DECLARE cur CURSOR FOR SELECT idbranchoffice FROM cat_sucursales WHERE idsucursal != NEW.idsucursal;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                OPEN cur;
                  ins_loop: LOOP
                    FETCH cur INTO m_idbranchoffice;
                    IF fin=1 THEN
                      LEAVE ins_loop;
                    END IF;
                    INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                    VALUES (m_idbranchoffice, NEW.idweb, \'I\', NEW.tabla);
                  END LOOP;
                CLOSE cur;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('subidas_AI');
    }
};
