<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('productoscompuestos_AU', function ($trigger) {
            $trigger->on('productoscompuestos');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::UPDATE);
            $trigger->statement(
                'DECLARE m_idbranchoffice INT;
                DECLARE fin INT;
                DECLARE cur CURSOR FOR SELECT idbranchoffice FROM cat_sucursales;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                IF NEW.origen_registro = 1 THEN
                  OPEN cur;
                    ins_loop: LOOP
                      FETCH cur INTO m_idbranchoffice;
                      IF fin=1 THEN
                        LEAVE ins_loop;
                      END IF;
                      INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                      VALUES (m_idbranchoffice, NEW.idcompoundproduct, \'U\', \'PRODUCTOSCOMPUESTOS\');
                    END LOOP;
                  CLOSE cur;
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('productoscompuestos_AU');
    }
};
