<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('permisos_AD', function ($trigger) {
            $trigger->on('permisos');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::DELETE);
            $trigger->statement(
                'DELETE FROM mov_changes
                WHERE tabla = \'PERMISOS\' AND identable = OLD.idpermit;

                INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                VALUES (OLD.idsucursal, OLD.idpermit, \'D\', \'PERMISOS\');'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('permisos_AD');
    }
};
