<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('permisos_AI', function ($trigger) {
            $trigger->on('permisos');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'IF NEW.origen_registro = 1 THEN
                    INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                    VALUES (NEW.idsucursal, NEW.idpermit, \'I\', \'PERMISOS\');
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('permisos_AI');
    }
};
