<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('movinvgeneral_AI', function ($trigger) {
            $trigger->on('mov_inv_general');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'IF NEW.origen_registro = \'WEB\' THEN
                    INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                    VALUES (NEW.idsucursal, NEW.idmovinventariogral, \'I\', \'INVENTARIOFISICOGRAL\');
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('movinvgeneral_AI');
    }
};
