<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('movinvdetalle_insert_before', function ($trigger) {
            $trigger->on('mov_inv_detalle');
            $trigger->timing(TriggerTiming::BEFORE);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'DECLARE vIdMovInvGral INT;
                DECLARE vFechaHora TIMESTAMP;
                DECLARE vIdConceptoInventario INT;

                IF NEW.origen_registro = \'ESCRITORIO\' THEN
                  SELECT idmovinventariogral, fechahora_registro, idconceptoinventario
                  FROM mov_inv_general
                  WHERE idmovinventariogral_desk = NEW.idinventariofisicogral
                  AND idsucursal = NEW.idsucursal
                  INTO vIdMovInvGral, vFechaHora, vIdConceptoInventario;

                  SET NEW.idinventariofisicogral = vIdMovInvGral;
                  SET NEW.fecha_hora = vFechaHora;
                  SET NEW.idconceptoinventario = vIdConceptoInventario;
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('movinvdetalle_insert_before');
    }
};
