<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('tr_updStockIngreso', function ($trigger) {
            $trigger->on('detalle_ingreso');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'UPDATE cat_productos SET existencia = existencia + NEW.cantidad
                WHERE cat_productos.idproduct = NEW.idarticulo;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('tr_updStockIngreso');
    }
};
