<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('cat_usuarios_update', function ($trigger) {
            $trigger->on('cat_usuarios');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::UPDATE);
            $trigger->statement(
                'IF NEW.origen_registro = \'WEB\' THEN
                    INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                    VALUES (NEW.idsucursal, NEW.iduser, \'U\', \'USUARIOS\');
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('cat_usuarios_update');
    }
};
