<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('sucursal_insert', function ($trigger) {
            $trigger->on('cat_sucursales');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'DECLARE m_idproduct BIGINT;
                DECLARE m_idfamily BIGINT;
                DECLARE m_idbrand BIGINT;
                DECLARE m_idprovider BIGINT;
                DECLARE m_idconceptinventory BIGINT;
                DECLARE m_idcompoundproduct BIGINT;
                DECLARE m_idconceptoingegre BIGINT;
                DECLARE fin INT;
                DECLARE m_numsuc INT;
                DECLARE m_nombrealmacen VARCHAR(50);
                DECLARE m_comentarios VARCHAR(254);
                DECLARE m_nombreempresa VARCHAR(200);
                DECLARE cur_prod CURSOR FOR SELECT idproduct FROM cat_productos;
                DECLARE cur_fam CURSOR FOR SELECT idfamily FROM cat_familias;
                DECLARE cur_marc CURSOR FOR SELECT idbrand FROM cat_marcas;
                DECLARE cur_prov CURSOR FOR SELECT idprovider FROM cat_proveedores;
                DECLARE cur_conceptoinv CURSOR FOR SELECT idinventoryconcept FROM cat_conceptosinventarios;
                DECLARE cur_prodcomp CURSOR FOR SELECT idcompoundproduct FROM productoscompuestos;
                DECLARE cur_conceptosingegre CURSOR FOR SELECT idconceptegressincome FROM conceptosingresosegresos;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                OPEN cur_fam;
                    ins_loop_fam: LOOP
                        FETCH cur_fam INTO m_idfamily;
                        IF fin=1 THEN LEAVE ins_loop_fam; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idfamily, \'I\', \'FAMILIAS\');
                    END LOOP;
                CLOSE cur_fam;
                SET fin=0;

                OPEN cur_marc;
                    ins_loop_marc: LOOP
                        FETCH cur_marc INTO m_idbrand;
                        IF fin=1 THEN LEAVE ins_loop_marc; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idbrand, \'I\', \'MARCAS\');
                    END LOOP;
                CLOSE cur_marc;
                SET fin=0;

                OPEN cur_prod;
                    ins_loop_prod: LOOP
                        FETCH cur_prod INTO m_idproduct;
                        IF fin=1 THEN LEAVE ins_loop_prod; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idproduct, \'I\', \'PRODUCTOS\');
                    END LOOP;
                CLOSE cur_prod;
                SET fin=0;

                OPEN cur_prov;
                    ins_loop_prov: LOOP
                        FETCH cur_prov INTO m_idprovider;
                        IF fin=1 THEN LEAVE ins_loop_prov; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idprovider, \'I\', \'PROVEEDORES\');
                    END LOOP;
                CLOSE cur_prov;
                SET fin=0;

                OPEN cur_conceptoinv;
                    ins_loop_ci: LOOP
                        FETCH cur_conceptoinv INTO m_idconceptinventory;
                        IF fin=1 THEN LEAVE ins_loop_ci; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idconceptinventory, \'I\', \'CONCEPTOSINVENTARIOS\');
                    END LOOP;
                CLOSE cur_conceptoinv;
                SET fin=0;

                OPEN cur_prodcomp;
                    ins_loop_pc: LOOP
                        FETCH cur_prodcomp INTO m_idcompoundproduct;
                        IF fin=1 THEN LEAVE ins_loop_pc; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idcompoundproduct, \'I\', \'PRODUCTOSCOMPUESTOS\');
                    END LOOP;
                CLOSE cur_prodcomp;
                SET fin=0;

                OPEN cur_conceptosingegre;
                    ins_loop_cie: LOOP
                        FETCH cur_conceptosingegre INTO m_idconceptoingegre;
                        IF fin=1 THEN LEAVE ins_loop_cie; END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla) VALUES (NEW.idsucursal, m_idconceptoingegre, \'I\', \'CONCEPTOSINGRESOSEGRESOS\');
                    END LOOP;
                CLOSE cur_conceptosingegre;

                SELECT COUNT(*) FROM cat_sucursales INTO m_numsuc;
                SET m_nombrealmacen = CONCAT(\'ALM_\' ,NEW.rfc);
                SET m_comentarios = CONCAT(\'ALMACEN NUMERO \' , m_numsuc , \' CORRESPONDIENTE A LA SUCURSAL \' , NEW.razon_social);

                INSERT INTO cat_almacenes (idsucursal, idalmacen, clave, nombre, comentarios, tipo_almacen, es_de_control_interno)
                VALUES (NEW.idsucursal, 0, \'ALMACEN_WEB\', m_nombrealmacen, m_comentarios, \'GENERAL\', 0);'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('sucursal_insert');
    }
};
