<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('producto_update', function ($trigger) {
            $trigger->on('cat_productos');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::UPDATE);
            $trigger->statement(
                'DECLARE m_idsucursal BIGINT;
                DECLARE fin INT;
                DECLARE vInsertarInventarios BOOL;
                DECLARE vInventariosEncontrados INT;
                DECLARE vIdAlmacen BIGINT;
                DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                IF NEW.origen_registro = \'WEB\' THEN
                    SET vInsertarInventarios = false;
                    SET vInventariosEncontrados = 0;
                    IF NEW.manejainventario > 0 THEN
                        SELECT COUNT(idmovinvexistencia)
                        FROM `mov_inv_existencias`
                        WHERE idproducto = NEW.idproduct
                        INTO vInventariosEncontrados;
                        IF NOT vInventariosEncontrados > 0 THEN
                            SET vInsertarInventarios = true;
                        END IF;
                    ELSE
                        DELETE FROM `mov_inv_existencias` WHERE idproducto = NEW.idproduct;
                    END IF;

                    OPEN cur;
                    ins_loop: LOOP
                        FETCH cur INTO m_idsucursal;
                        IF fin=1 THEN
                            LEAVE ins_loop;
                        END IF;
                        IF vInsertarInventarios THEN
                            SELECT idwarehouse
                            FROM cat_almacenes
                            WHERE idsucursal = m_idsucursal
                            INTO vIdAlmacen;
                            INSERT INTO `mov_inv_existencias`(`idsucursal`, `idinventario`, `idproducto`, `idalmacen`, `existencia`, `contados`, `idsucursalorigen`, `origen_registro`, `descargado`)
                            VALUES (m_idsucursal, 0, NEW.idproduct, vIdAlmacen, 0, 0, m_idsucursal,\'WEB\', 0);
                        END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                        VALUES (m_idsucursal, NEW.idproduct, \'U\', \'PRODUCTOS\');
                    END LOOP;
                    CLOSE cur;
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('producto_update');
    }
};
