<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ventasgeneral', function (Blueprint $table) {
            $table->id('idventagral');
            $table->bigInteger('idventageneral');
            $table->integer('idsucursal')->index('i_idsucursal');
            $table->integer('idstatus')->index('i_idstatus');
            $table->bigInteger('idcliente')->index('i_idcliente');
            $table->string('cliente', 180)->nullable();
            $table->integer('idtipodocumento')->index('i_idtipodocumento');
            $table->string('documento', 120)->nullable();
            $table->date('fechaventa')->nullable()->index('i_fechaventa');
            $table->time('horaventa')->index('i_horaventa');
            $table->timestamp('fechahora')->nullable();
            $table->bigInteger('folio');
            $table->smallInteger('pagado');
            $table->string('tipopago', 30);
            $table->bigInteger('idusuario')->index('i_idusuario');
            $table->decimal('importe', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->decimal('comision', 18, 6)->default(-1);
            $table->decimal('totalentregado', 18, 6);
            $table->decimal('cambioaentregar', 18, 6);
            $table->string('observaciones1', 50);
            $table->bigInteger('idturno')->nullable()->index('i_idturno');
            $table->bigInteger('idtipopago')->nullable()->index('i_idtipopago');
            $table->decimal('costototal', 18, 6)->nullable();
            $table->decimal('utilidadtotal', 18, 6)->nullable();
            $table->string('usuario', 50)->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->string('origen_registro', 15)->nullable();
            $table->smallInteger('descargado')->nullable();
            $table->boolean('deletedofdesk')->nullable()->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ventasgeneral');
    }
};
