<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usuarios_nube_escritorio', function (Blueprint $table) {
            $table->id('id');
            $table->bigInteger('idsucursal');
            $table->bigInteger('id_users');
            $table->bigInteger('id_cat_usuarios');
            $table->boolean('activo');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usuarios_nube_escritorio');
    }
};
