<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productoscompuestos', function (Blueprint $table) {
            $table->id('idcompoundproduct');
            $table->bigInteger('idcomponente');
            $table->bigInteger('idproducto');
            $table->decimal('cantidad', 18, 6);
            $table->boolean('origen_registro');
            $table->decimal('existencia_proporcional', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productoscompuestos');
    }
};
