<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos_intermedios_general_movil', function (Blueprint $table) {
            $table->id('id');
            $table->bigInteger('idsucursal')->index('index_idsucursal');
            $table->tinyInteger('idstatus');
            $table->date('fecha_pedido')->nullable()->index('index_fecha_pedido');
            $table->date('fecha_pedido_entrega')->nullable()->index('index_fecha_pedido_entrega');
            $table->bigInteger('idcliente')->index('index_idcliente');
            $table->string('nombre_cliente', 80);
            $table->bigInteger('idvendedor')->index('index_idvendedor');
            $table->string('nombre_vendedor', 80);
            $table->tinyInteger('pedidoyaaplicado')->index('index_pedidoyaaplicado');
            $table->string('comentarios', 80)->nullable();
            $table->bigInteger('idpedidogeneral')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos_intermedios_general_movil');
    }
};
