<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos_intermedios_detalle_movil', function (Blueprint $table) {
            $table->id('id');
            $table->bigInteger('idsucursal')->index('index_idsucursal');
            $table->bigInteger('id_pedido_intermedio_general_movil')->index('index_id_pedido_intermedio_general_movil');
            $table->bigInteger('idproducto')->index('index_idproducto');
            $table->string('clave', 30)->nullable();
            $table->string('descripcion', 254)->nullable();
            $table->string('unidadmedida', 150)->nullable();
            $table->decimal('cantidad', 18, 6)->nullable();
            $table->tinyInteger('cantidadyaenviada')->nullable();
            $table->decimal('cantidadxenviar', 18, 6)->nullable();
            $table->decimal('precio', 18, 6)->nullable();
            $table->decimal('importe', 18, 6)->nullable();
            $table->decimal('descuentox100', 18, 6)->nullable();
            $table->decimal('descuento', 18, 6)->nullable();
            $table->decimal('subtotal', 18, 6)->nullable();
            $table->decimal('iva', 18, 6)->nullable();
            $table->decimal('total', 18, 6)->nullable();
            $table->string('traslado_iva_tipo_factor', 20)->nullable();
            $table->decimal('traslado_iva_tasa_cuota', 18, 6)->nullable();
            $table->decimal('traslado_iva_importe', 18, 6)->nullable();
            $table->string('traslado_ieps_tipo_factor', 20)->nullable();
            $table->decimal('traslado_ieps_tasa_cuota', 18, 6)->nullable();
            $table->decimal('traslado_ieps_importe', 18, 6)->nullable();
            $table->string('retencion_iva_tipo_factor', 20)->nullable();
            $table->decimal('retencion_iva_tasa_cuota', 18, 6)->nullable();
            $table->decimal('retencion_iva_importe', 18, 6)->nullable();
            $table->string('retencion_isr_tipo_factor', 20)->nullable();
            $table->decimal('retencion_isr_tasa_cuota', 18, 6)->nullable();
            $table->decimal('retencion_isr_importe', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos_intermedios_detalle_movil');
    }
};
